/**
 * Copyright 110100110101101 ( http://wonderfl.net/user/110100110101101 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qv70
 */

// forked from esukei's [最適化 Tips] if ... else と switch と 三項演算 での処理速度の違い
// forked from muta244's [最適化 Tips] if ... else と switch での処理速度の違い
//　三項演算も追加してみた。普通三項演算で10個も入れ子にしたりしないとは思いますが…
package {

import flash.display.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const _NUM_TIMES:uint = 1000000;
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        var n:uint = 10;
        
        _measure("ループのみ", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                
            }
        });
        
        _measure("1 回のみ比較する if ... else 文", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                if (n === 0) {}
            }
        });
        
        _measure("1 回のみ比較する switch 文", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                switch (n) {
                    case 0: break;
                    default: break;
                }
            }
        });
        
        _measure("1 回のみ比較する 三項演算", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                (n === 0)? true : null ;
            }
        });
        
        _measure("10 回比較する if ... else 文", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                if (n === 0) {}
                else if (n === 1) {}
                else if (n === 2) {}
                else if (n === 3) {}
                else if (n === 4) {}
                else if (n === 5) {}
                else if (n === 6) {}
                else if (n === 7) {}
                else if (n === 8) {}
                else if (n === 9) {}
                else {}
            }
        });
        
        _measure("10 回比較する switch 文", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                switch (n) {
                    case 0: break;
                    case 1: break;
                    case 2: break;
                    case 3: break;
                    case 4: break;
                    case 5: break;
                    case 6: break;
                    case 7: break;
                    case 8: break;
                    case 9: break;
                    default: break;
                }
            }
        });
        
        _measure("10 回比較する 三項演算", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                (n === 0)? true
                :(n === 1)? true
                :(n === 2)? true
                :(n === 3)? true
                :(n === 4)? true
                :(n === 5)? true
                :(n === 6)? true
                :(n === 7)? true
                :(n === 8)? true
                :(n === 9)? true: false;
            }
        });
        
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
