/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qv3S
 */

// forked from siouxcitizen's PV3DのTriangleMesh3Dの練習07　Sphereクラスを修正して半球クラス作成実験
//PV3DのTriangleMesh3Dの練習08　Primitives等も使って無理やりDroid作成実験
//引き続きかなりムリヤリテキトーに、Hemisphereモデルに加えてCylinderモデルも使いつつをDroid作成してます。。。
//
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import org.papervision3d.objects.primitives.Cylinder;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.view.*;
    public class Main extends BasicView {

        private var light:PointLight3D
        private var head:Hemisphere;
        private var body:Cylinder;
        private var leftHand:Cylinder;
        private var rightHand:Cylinder;
        private var leftFoot:Cylinder;
        private var rightFoot:Cylinder;
        private var leftAntenna:Cylinder;
        private var rightAntenna:Cylinder;
        private var leftEye:Hemisphere;
        private var rightEye:Hemisphere;

        public function Main() {
            //光源設定
            light = new PointLight3D();
            light.y = -8000;
            light.x = -8000;
            light.z = -8000;

            //var wMate : WireframeMaterial = new WireframeMaterial(0x0000ff);
            var cMate : ColorMaterial = new ColorMaterial(0xdddddd);
            var fMate : FlatShadeMaterial = new FlatShadeMaterial(light, 0x779977, 0x00ff00);
            fMate.doubleSided = true;

            head = new Hemisphere(fMate, 300, 10, 10);
            head.y = 300;

            body = new Cylinder(fMate, 300, 500, 14, 3);
            body.y = 280;
            head.addChild(body);

            leftHand = new Cylinder(fMate, 100, 450, 12, 3);
            leftHand.x = -420;
            leftHand.y = -30;
            body.addChild(leftHand);

            rightHand = new Cylinder(fMate, 100, 450, 12, 3);
            rightHand.x = 420;
            rightHand.y = -30;
            body.addChild(rightHand);

            leftFoot = new Cylinder(fMate, 100, 250, 12, 3);
            leftFoot.x = -160;
            leftFoot.y = 380;
            body.addChild(leftFoot);

            rightFoot = new Cylinder(fMate, 100, 250, 12, 3);
            rightFoot.x = 160;
            rightFoot.y = 380;
            body.addChild(rightFoot);

            leftAntenna = new Cylinder(fMate, 15, 150, 4, 3);
            leftAntenna.x = -160;
            leftAntenna.y = -330;
            leftAntenna.rotationZ = -45;
            head.addChild(leftAntenna);

            rightAntenna = new Cylinder(fMate, 15, 150, 4, 3);
            rightAntenna.x = 160;
            rightAntenna.y = -330;
            rightAntenna.rotationZ = 45;
            head.addChild(rightAntenna);

leftEye = new Hemisphere(cMate, 30, 8, 4);
            leftEye.x = -100;
            leftEye.y = -70;
            leftEye.z = -280;
            leftEye.rotationX = 90;
            head.addChild(leftEye);

rightEye = new Hemisphere(cMate, 30, 8, 4);
            rightEye.x = 100;
            rightEye.y = -70;
            rightEye.z = -280;
            rightEye.rotationX = 90;
            head.addChild(rightEye);

            scene.addChild(head);
            
            startRendering();
            
            this.addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(evt:Event):void {
            head.rotationX=viewport.mouseX;
            head.rotationY=viewport.mouseY;
        }
    }
}

import org.papervision3d.Papervision3D;
import org.papervision3d.core.geom.*;
import org.papervision3d.core.geom.renderables.Triangle3D;
import org.papervision3d.core.geom.renderables.Vertex3D;
import org.papervision3d.core.math.NumberUV;
import org.papervision3d.core.proto.*;  
class Hemisphere extends TriangleMesh3D {

    private var segmentsW :Number;
    private var segmentsH :Number;
    static public var DEFAULT_RADIUS :Number = 100;
    static public var DEFAULT_SCALE :Number = 1;
    static public var DEFAULT_SEGMENTSW :Number = 8;
    static public var DEFAULT_SEGMENTSH :Number = 6;
    static public var MIN_SEGMENTSW :Number = 3;
    static public var MIN_SEGMENTSH :Number = 2;

    public function Hemisphere( material:MaterialObject3D=null, radius:Number=100, segmentsW:int=8, segmentsH:int=6 ) {
        super( material, new Array(), new Array(), null );

        this.segmentsW = Math.max( MIN_SEGMENTSW, segmentsW || DEFAULT_SEGMENTSW); // Defaults to 8
        this.segmentsH = Math.max( MIN_SEGMENTSH, segmentsH || DEFAULT_SEGMENTSH); // Defaults to 6
        if (radius==0) radius = DEFAULT_RADIUS; // Defaults to 100

        var scale :Number = DEFAULT_SCALE;

        buildHemiphere( radius );
    }

    private function buildHemiphere( fRadius:Number ):void {
        var i:Number, j:Number, k:Number;
        var iHor:Number = Math.max(3,this.segmentsW);
        var iVer:Number = Math.max(2,this.segmentsH);
        var aVertice:Array = this.geometry.vertices;
        var aFace:Array = this.geometry.faces;
        var aVtc:Array = new Array();
        for (j=0;j<(iVer/2+1);j++) { // vertical
            var fRad1:Number = Number(j/iVer);
            var fZ:Number = -fRadius*Math.cos(fRad1*Math.PI);
            var fRds:Number = fRadius*Math.sin(fRad1*Math.PI);
            var aRow:Array = new Array();
            var oVtx:Vertex3D;
            for (i=0;i<iHor;i++) { // horizontal
                var fRad2:Number = Number(2*i/iHor);
                var fX:Number = fRds*Math.sin(fRad2*Math.PI);
                var fY:Number = fRds*Math.cos(fRad2*Math.PI);
                if (!((j==0||j==iVer)&&i>0)) { // top||bottom = 1 vertex
                    oVtx = new Vertex3D(fY,fZ,fX);
                    aVertice.push(oVtx);
                }
                aRow.push(oVtx);
            }
            aVtc.push(aRow);
        }
        var iVerNum:int = aVtc.length;
        for (j=0;j<iVerNum;j++) {
            var iHorNum:int = aVtc[j].length;
            if (j>0) { // &&i>=0
                for (i=0;i<iHorNum;i++) {
                    // select vertices
                    var bEnd:Boolean = i==(iHorNum-1);
                    var aP1:Vertex3D = aVtc[j][bEnd?0:i+1];
                    var aP2:Vertex3D = aVtc[j][(bEnd?iHorNum-1:i)];
                    var aP3:Vertex3D = aVtc[j-1][(bEnd?iHorNum-1:i)];
                    var aP4:Vertex3D = aVtc[j-1][bEnd?0:i+1];

                    var fJ0:Number = j / (iVerNum-1);
                    var fJ1:Number = (j-1) / (iVerNum-1);
                    var fI0:Number = (i+1) / iHorNum;
                    var fI1:Number = i / iHorNum;
                    var aP4uv:NumberUV = new NumberUV(fI0,fJ1);
                    var aP1uv:NumberUV = new NumberUV(fI0,fJ0);
                    var aP2uv:NumberUV = new NumberUV(fI1,fJ0);
                    var aP3uv:NumberUV = new NumberUV(fI1,fJ1);
                    // 2 faces
                    if (j<(aVtc.length-1))  aFace.push( new Triangle3D(this, new Array(aP1,aP2,aP3), material, new Array(aP1uv,aP2uv,aP3uv)) );
                    if (j>1) aFace.push( new Triangle3D(this, new Array(aP1,aP3,aP4), material, new Array(aP1uv,aP3uv,aP4uv)) );
                }
            }
        }
        //半球下部の欠けている部分を作成
        for (i=0;i<iHorNum;i++) {
            var bEnd_2:Boolean = i==(iHorNum-1);
            var aP1_2:Vertex3D = aVtc[iVerNum-1][bEnd_2?0:i+1];
            var aP2_2:Vertex3D = aVtc[iVerNum-1][bEnd_2?iHorNum-1:i];
            var aP3_2:Vertex3D = aVtc[iVerNum-2][bEnd_2?iHorNum-1:i];

            //uvよくわからないのでとりあえず。。。
            var uvA : NumberUV = new NumberUV( 0, 0 );
            var uvC : NumberUV = new NumberUV( 1, 0 );
            var uvB : NumberUV = new NumberUV( 0, 1 );

            aFace.push( new Triangle3D(this, new Array(aP1_2,aP2_2,aP3_2), material, new Array(uvA,uvC,uvB)) );
        }
        for each(var t:Triangle3D in aFace) {
            t.renderCommand.create = createRenderTriangle;
        }
        
        this.geometry.ready = true;
        
        if (Papervision3D.useRIGHTHANDED) this.geometry.flipFaces();
    }
}
