/**
 * Copyright poepoemix ( http://wonderfl.net/user/poepoemix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qucH
 */

package {
    import flash.events.MouseEvent;
    import flash.text.TextFieldType;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class Main extends Sprite {
        public function Main() {
            var ui:UiUtil = new UiUtil(this);
            for(var i:int = 0;i < 7;i ++) {
                var f2:TextField = ui.addTextField({
                    text: "こんにちは",
                    y:(5 + 25 * i),
                    width:100,
                    color:"" + i});
                ui.addButton({
                    text:"hello",
                    x:110,
                    y:(3 + 25*i),
                    width:52,
                    height:24,
                    color: "" + i})
                        .addEventListener(MouseEvent.CLICK, function(event:MouseEvent):void {
                            f2.text = "test";
                        });
            }
            var f:TextField = ui.addTextField({
                x:0,
                y:220,
                width:400,
                height:300});
            f.text = "" + typeof 0x000000;
        }
    }
}
import flash.text.TextField;
import flash.display.Sprite;
import flash.text.TextFormat;
/**
 * UI用
 */
class UiUtil {
    // コンポーネントカラー
    public static const BLUE:String   = "1";
    public static const RED:String    = "2";
    public static const YELLOW:String = "3";
    public static const GREEN:String  = "4";
    public static const AQUA:String   = "5";
    public static const GRAY:String   = "6";
    public static const WHITE:String  = "0";
    
    private var lightGray:Object = 0xF7F7F9;

    // 文字定義
    private var whiteFormat:TextFormat;
    private var format:TextFormat;
    private var blueFormat:TextFormat;

    private var target:Sprite = null;
    public function UiUtil(target:Sprite) {
        this.target = target;
        whiteFormat = new TextFormat();
        whiteFormat.font  = "Arial";
        whiteFormat.color = 0xffffff;
        whiteFormat.size  = 16;
        
        format = new TextFormat();
        format.font  = "Arial";
        format.color = 0x303030;
        format.size  = 16;

        blueFormat = new TextFormat();
        blueFormat.font  = "Arial";
        blueFormat.color = 0x0080C0;
        blueFormat.size  = 14;
    }
    // jsonにした。
    public function addTextField(data:Object):TextField {
        var textField:TextField = new TextField();
        textField.x = (data.x != null ? data.x : 0);
        textField.y = (data.y != null ? data.y : 0);
        textField.background = true;
        textField.width = (data.width != null ? data.width : 100);
        textField.height = (data.height != null ? data.height : 24);
        textField.backgroundColor = (typeof data.color == "number" ? data.color : getColor(data.color));
        textField.defaultTextFormat = (typeof data.color == "number" ? getFormat("0") : getFormat(data.color));
        textField.text = (data.text != null ? data.text : "");
        target.addChild(textField);
        return textField;
    }
    // こっちもjsonにした。
    public function addButton(data:Object):Button {
        var text:String = (data.text != null ? data.text : "");
        var x:int = (data.x != null ? data.x : 0);
        var y:int = (data.y != null ? data.y : 0);
        var width:int = (data.width != null ? data.width : 100);
        var height:int = (data.height != null ? data.height : 24);
        var color:uint = (typeof data.color == "number" ? data.color : getColor(data.color));
        var format:TextFormat = (typeof data.color == "number" ? getFormat("0") : getFormat(data.color));
        var button:Button = new Button(text, x, y, width, height, color, format);
        target.addChild(button);
        return button;
    }
    private function getColor(color:String):uint {
        switch(color) {
            case BLUE:
                return 0x0074CC;
            case RED:
                return 0xDA4F49;
            case YELLOW:
                return 0xFAA732;
            case GREEN:
                return 0x5BB75B;
            case AQUA:
                return 0x49AFCD;
            case GRAY:
                return 0x414141;
            case WHITE:
            default:
                return 0xF0F0F0;
        }
    }
    private function getFormat(color:String):TextFormat {
        switch(color) {
            case BLUE:
            case RED:
            case YELLOW:
            case GREEN:
            case AQUA:
            case GRAY:
                return whiteFormat;
            case WHITE:
            default:
                return format;
        }
    }
}
class Button extends Sprite {
    private var _label:TextField;
    public function get text():String {
        return _label.text;
    }
    public function set text(text:String):void {
        _label.text = text;
    }
    public function Button(text:String, x:int=0, y:int=0, width:int=0, height:int=0, color:uint=0x0074CC, format:TextFormat=null) {
        this._label = new TextField();
        this._label.x = 10;
        this._label.y = 2;
        this._label.defaultTextFormat = format;
        this._label.selectable = false;
        this._label.text = text;

        this.graphics.beginFill(color);
        this.graphics.drawRoundRect(0, 0, width, height, 12);
        this.graphics.endFill();
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
        this.buttonMode = true;
        this.mouseChildren = false
        this.addChild(_label);
    }
}
class Logger {
    public static var level:int;
    public static const FATAL:int = 0;
        public static const ERROR:int = 1;
        public static const WARN:int  = 2;
        public static const INFO:int  = 3;
        public static const DEBUG:int = 4;
        public static const TRACE:int = 5;
        private var name:String;
        public function Logger(name:String) {
            this.name = name;
        }
        public function fatal(data:*):void {
            if(level >= FATAL) {
                write(data, "FATAL");
            }
        }
        public function error(data:*):void {
            if(level >= ERROR) {
                write(data, "ERROR");
            }
        }
        public function warn(data:*):void {
            if(level >= WARN) {
                write(data, "WARN");
            }
        }
        public function info(data:*):void {
            if(level >= INFO) {
                write(data, "INFO");
            }
        }
        public function debug(data:*):void {
            if(level >= DEBUG) {
                write(data, "DEBUG");
            }
        }
        public function trace(data:*):void {
            if(level >= TRACE) {
                write(data, "TRACE");
            }
        }
        private function write(data:*, level:String):void {
            // date
            // dateformatterとobjectUtilはmxのオブジェクトなので使えません。
//            var formatter:DateFormatter = new DateFormatter();
//            formatter.formatString = "YYYY-MM-DD JJ:NN:SS";
var line:String = "";
//            var line:String = formatter.format(new Date()) + ",";
            // level
            line += level + ",";
            // file and position(this is for debug player only, so ignore now...)
            line += name + ",,";
/*            try {
                throw new Error();
            }
            catch(e:Error) {
            }*/
            if(data is String) {
                line += message(data);
            }
            else if(data is Error) {
                line += exception(data);
            }
            else {
                line += dump(data, "    ");
            }
//            LoggerFactory.logdata.push(line);
//            ExternalInterface.call("console.log", line);
        }
        private function dump(data:Object, tab:String):String {
//            var result:Array = new Array();
//            result.push(getQualifiedClassName(data));
            var line:String = "";
//            return ObjectUtil.toString(data);
return "";
        }
        private function message(data:String):String {
            return data;
        }
        private function exception(data:Error):String {
            return data.toString();
        }
    
}
