/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/quZ3
 */

package {
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    
    [SWF(backgroundColor="0x000000")]
    public class FlashTest extends MovieClip
    {
        private var whiteBall:Sprite;
        private var balls:Array;
        private var overed:Boolean = false;
        
        public function FlashTest() {
            // write as3 code here..
            balls = new Array();
            
            whiteBall = makeBall(30, stage.stageHeight / 2, 20, 0xFFFFFF);
            addChild(whiteBall);
            whiteBall.buttonMode = true;
            whiteBall.addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
            whiteBall.addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
            
            for(var i:int = 0;i < 10;i++)
            {
                var colorfulBall:Sprite = makeBall(stage.stageWidth, stage.stageHeight, 20, Math.random() * 0xFFFFFF);
                addChild(colorfulBall);
                balls.push(colorfulBall);
            }
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function makeBall(x:int, y:int, r:int, c:uint):Sprite
        {
            var b:Sprite = new Sprite();
            b.graphics.beginFill(c);
            b.graphics.drawCircle(0, 0, r);
            b.graphics.endFill();
            b.x = x;
            b.y = y;
            
            return b;
            
        }
        
        private function onMouseOver(e:MouseEvent):void
        {
            overed = true;
        }
        
        private function onMouseOut(e:MouseEvent):void
        {
            overed = false;
        }
        
        private function onEnterFrame(e:Event):void
        {
            var destX:Number;
            var destY:Number;
            for(var i:int = 0;i < 10;i++)
            {
                //if(overed)
                //{
                    if(i == 0)
                    {
                        destX = mouseX;
                        destY = mouseY;
                    }
                    else
                    {
                        destX = balls[i - 1].x;
                        destY = balls[i - 1].y;
                    }
                //}
                /*else
                {
                    if(i == 0)
                    {
                        destX = stage.stageWidth;
                        destY = stage.stageHeight;
                    }
                    else
                    {
                        destX = balls[i - 1].x;
                        destY = balls[i - 1].y;
                    }
                }*/
                
                balls[i].x += (destX - balls[i].x) * 0.5;
                balls[i].y += (destY - balls[i].y) * 0.5;
            }

        }

    }
}