/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/quN2
 */

// forked from wellflat's VTR Filter for web camera
package 
{
    import com.bit101.components.HUISlider;
    import com.bit101.components.PushButton;
    import com.bit101.components.VBox;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.NetStatusEvent;
    import flash.media.SoundMixer;
    import flash.media.Video;
    import flash.net.NetConnection;
    import flash.net.NetStream;
    import flash.utils.ByteArray;
    
    /**
     * ...
     * @author gaina
     * sound by AlainMikuni
     */
     
    public class SoundTest12VTRFilter extends Sprite 
    {
        private var w:Number;
        private var h:Number;
        
        private const WIDTH:int = 465;
        private const HEIGHT:int = 465;
        
        private var _path:String = "http://www.takasumi-nagai.com/videofiles/";
        private var _url:String = "20100912.f4v";
        private var _nc:NetConnection;
        private var _ns:NetStream;
        
        private var _bmpd:BitmapData;
        private var _bitmap:Bitmap;
        
        private var _line:VTR;
        private var contrast:HUISlider;
        private var gamma:HUISlider;
        private var ghost:HUISlider;
        private var thick:HUISlider;
        private var bitmapData:BitmapData;
        
        public function SoundTest12VTRFilter():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            var _sound:PlaySound = new PlaySound("http://www.takasumi-nagai.com/soundfiles/sound006.mp3");
            
            w = stage.stageWidth;
            h = stage.stageHeight;
            
            _bmpd = new BitmapData(w, h, false);
            _bitmap = new Bitmap(_bmpd);
            addChild(_bitmap);
            
            _line = new VTR(_bitmap);
            bitmapData = new BitmapData(465, 465);
            bitmapData.perlinNoise(100, 100, 1, 1, false, true, uint(Math.random()*7)+1);
            _line.addChild(new Bitmap(bitmapData));
            _line.setCondition(2, 2, 2, 2.0);
            
            //_nc = new NetConnection();
            //_nc.addEventListener(NetStatusEvent.NET_STATUS, ConnectCheck);
            //_nc.connect(null);
                addEventListener(Event.ENTER_FRAME, loop);
                gui();
        }
        
        private function gui():void 
        {
            var vbox:VBox = new VBox(this, 0, 0);
            vbox.spacing = 0;
            gamma  = new HUISlider(vbox, 0, 0, 'gamma');
            contrast = new HUISlider(vbox, 0, 0, 'contrast');
            ghost  = new HUISlider(vbox, 0, 0, 'ghost');
            thick  = new HUISlider(vbox, 0, 0, 'thick');
            gamma.minimum = 0;
            gamma.maximum = 4;
            contrast.maximum = 3;
            thick.maximum = 3;
            ghost.maximum = 3;
            new PushButton(vbox, 0, 0, 'reset', doReset);
            new PushButton(vbox, 0, 0, 'perlin', doPerlin);
            doReset();
        }
        
        private function doPerlin(e:Event):void 
        {
            bitmapData.perlinNoise(100, 100, 1, 100*Math.random()>>0, false, true, uint(Math.random()*7)+1);
            
        }
        
        private function doReset(e:Event=null):void 
        {
            gamma.value = 2;
            thick.value = 1.5;
            contrast.value = 2;
            ghost.value = 1;
            
        }
        
        private function ConnectCheck(e:NetStatusEvent):void 
        {
            if (e.info.code == "NetConnection.Connect.Success")
            {
                _ns = new NetStream(_nc);
                _ns.client = { };
                //_line.attachNetStream(_ns);
                _ns.checkPolicyFile = true;
                _ns.play(_path + _url);
                _ns.addEventListener(NetStatusEvent.NET_STATUS, onCompleteEvent);
                
                addEventListener(Event.ENTER_FRAME, loop);
            }
        }
        
        private function loop(e:Event):void 
        {
            _bmpd.draw(_line);
            _line.apply();
            
            var _byte:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(_byte, true);
            var p:Number = 0;
            var q:Number = 0;
            for (var i:int = 0; i < 256; i++)
            {
                    var data:Number = _byte.readFloat();
                if (i<144) 
                {
                    
                    p += data;
                    if (p > 4) {
                        _line.setCondition(int(p * contrast.value), int(p * ghost.value), int(p * thick.value) , gamma.value);
                    }else {
                        _line.setCondition(0, 0, 0, 1.0);
                    }
                }
                else
                {
                    q += data;
                }
                
            }
            if (q>2) 
            {
                doPerlin(null);
            }
      }
        
        private function onCompleteEvent(e:NetStatusEvent):void 
        {
            if (e.info.code == "NetStream.Play.Stop")
            {
                _ns.play(_path + _url);
            }
        }
    }
}

import flash.events.Event;
import flash.media.Sound;
import flash.media.SoundLoaderContext;
import flash.media.SoundTransform;
import flash.net.URLRequest;

class PlaySound
{
    private var sound:Sound;

        public function PlaySound(url:String)
        {
            sound = new Sound();
            var _context:SoundLoaderContext = new SoundLoaderContext(1000, true);
            sound.addEventListener(Event.COMPLETE, SoundLoadeComplete);
            sound.load(new URLRequest(url), _context);
        }
        
        private function SoundLoadeComplete(e:Event):void 
        {
            sound.play(0, 10, new SoundTransform(0.3, 0));
        }
}

  import flash.display.Bitmap;
  import flash.display.BitmapData;
  import flash.events.Event;
  import flash.display.Sprite;
  //import flash.media.Video;

  //class VTR extends Video {
  class VTR  extends Sprite{
    private var _contrast:int;
    private var _thick:int;
    private var _ghost:int;
    private var gtbl:Vector.<uint>;
    private var frame:BitmapData;
    
    public function VTR(screen:Bitmap) {
      //super(screen.width, screen.height);
      frame = screen.bitmapData;
      gtbl = new Vector.<uint>(256, true);
    }
    public function setCondition(contrast:int, ghost:int, thick:int,
                              gamma:Number):void {
      _contrast = contrast;
      _ghost = ghost;
      _thick = thick; // require 2^x
      for(var i:int=0; i<256; i++) {  // create table for gamma correction.
        gtbl[i] = Math.pow(i/255.0, gamma)*255.0;
      }
    }
    public function start():void { // start apply effect (onEnterFrame).
      addEventListener(Event.ENTER_FRAME, apply, false, 0, true);
    }
    /** main algorithm
        add scannning lines, ghost and gamma collection. **/
    public function apply():void {
      frame.draw(super);
      frame.lock();
      var data:Vector.<uint> = frame.getVector(frame.rect);
      var w:int = frame.width, h:int = frame.height;
      var r:uint = 0, g:uint = 0, b:uint = 0;
      var i:int = 0, j:int = 0, step:int = w;
      var f:int = 1;
      var len:int = data.length;
      for(var y:int = 0; y < h; y++, step += w) {
        f = (y & _thick - 1) << 1 < _thick ? 1 : 0;
        if(step + _ghost >= len) break;
        for(j = i + _ghost; i < step; i++, j++) {
          r = ((data[i] >> 16) & 0xff) + ((data[j] >> 16) & 0xff) >> 1;
          g = ((data[i] >> 8) & 0xff) + ((data[j] >> 16) & 0xff) >> 1;
          b = (data[i] & 0xff) + (data[j] & 0xff) >> 1;
          if(f && (r = g = b += _contrast) > 0xff) {
            r = g = b = 0xff;
          }
          data[i] = gtbl[r] << 16 | gtbl[g] << 8 | gtbl[b];
        }
      }
      frame.setVector(frame.rect, data);
      frame.unlock();
    }
  }