/**
 * Copyright azuremous ( http://wonderfl.net/user/azuremous )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/quIN
 */

// forked from set0's flash on 2009-6-19
package  
{
	import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import funnel.*;
    [SWF(width=465, height=465, frameRate=60, backgroundColor=0x000000)]
    public class FlashTest15 extends Sprite
	{
		private var spark_list:Array = [];
		private var buffer:BitmapData = new BitmapData(465, 465, false, 0x000000);
		private var screen:Bitmap = new Bitmap(buffer);
		
		private var old_x:Number = 0;
		private var old_y:Number = 0;
                private var movementX:Number;
                private var movementY:Number;
                private var colorChange :uint;
                private var gainer:Gainer;
   
                public var changeValue:int;
		public function FlashTest15()
		{	
                        gainer =new Gainer();
                        var smoother:Convolution = new Convolution(Convolution.MOVING_AVERAGE);
    			var smoother1:Convolution = new Convolution(Convolution.MOVING_AVERAGE);
    	                var smoother2:Convolution = new Convolution(Convolution.MOVING_AVERAGE);
                        var scaler:Scaler = new Scaler(0.25,0.65,0,1.0,Scaler.LINEAR, true);
                        var scaler1:Scaler = new Scaler(0.3,0.7,0,465,Scaler.LINEAR, true);
                        var scaler2:Scaler = new Scaler(0.4,0.7,0,465,Scaler.LINEAR, true);
                        gainer.analogInput(0).filters =[smoother,scaler];
                        gainer.analogInput(1).filters =[smoother1,scaler2];
                        gainer.analogInput(2).filters =[smoother2,scaler1];
			addChild(screen);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(e:Event):void
		{
    
                       var color:Number =gainer.analogInput(0).value; 
                       var movementY:Number =gainer.analogInput(2).value;
                       var movementX:Number =gainer.analogInput(1).value;
        
                       colorChange = Spark.HSBtoRGB(color,1.0,1.0);
       
                       spark_list.push(new Spark(old_x, old_y, movementX, movementY , colorChange));
                       old_x =  movementX;
                       old_y =  movementY;
                       
			
			var max:int = spark_list.length;
			buffer.colorTransform(buffer.rect, new ColorTransform(0, 0, 0, 0, 0, 0, 0, 0));

			for (var i:int = 0; i < max; i++) {
				buffer.copyPixels(spark_list[i].top_bmp, spark_list[i].top_bmp.rect, new Point(spark_list[i].x, spark_list[i].y));
				
				if (spark_list[i].move() === false) {
					spark_list.splice(i, 1);
					i--;
					max--;
				}
			}
			
			buffer.applyFilter(buffer, buffer.rect, new Point(0, 0), new BlurFilter(2, 2));
		}
    }
}

import flash.display.*;
import flash.geom.*;
import flash.filters.*;
import funnel.*;
class Spark
{
    public var top_bmp:BitmapData;
	public var middle_bmp:BitmapData;
	public var bottom_bmp:BitmapData;
	public var x:Number;
	public var y:Number;
	public var life:Number = 20;


 public static function HSBtoRGB(hue:Number, saturation:Number, brightness:Number):uint {
     	
    var r:int = 0;
    var g:int = 0;
    var b:int = 0;
    if (saturation == 0) {
        r = g = b = brightness * 255.0 + 0.5;
    } else {
        var h:Number = (hue - Math.floor(hue)) * 6.0;
        var f:Number = h - Math.floor(h);
        var p:Number = brightness * (1.0 - saturation);
        var q:Number = brightness * (1.0 - saturation * f);
        var t:Number = brightness * (1.0 - (saturation * (1.0 - f)));
        switch (int(h)) {
        case 0:
            r = brightness * 255.0 + 0.5;
            g = t * 255.0 + 0.5;
            b = p * 255.0 + 0.5;
            break;
        case 1:
            r = q * 255.0 + 0.5;
            g = brightness * 255.0 + 0.5;
            b = p * 255.0 + 0.5;
            break;
        case 2:
            r = p * 255.0 + 0.5;
            g = brightness * 255.0 + 0.5;
            b = t * 255.0 + 0.5;
            break;
        case 3:
            r = p * 255.0 + 0.5;
            g = q * 255.0 + 0.5;
            b = brightness * 255.0 + 0.5;
            break;
        case 4:
            r = t * 255.0 + 0.5;
            g = p * 255.0 + 0.5;
            b = brightness * 255.0 + 0.5;
            break;
        case 5:
            r = brightness * 255.0 + 0.5;
            g = p * 255.0 + 0.5;
            b = q * 255.0 + 0.5;
            break;
        }
    }
    return (r << 16) | (g << 8) | (b << 0);
}

    public function Spark(old_x:Number, old_y:Number, x:Number, y:Number, c:uint)
    {
		var default_size:int = int(Math.random() * 30) + 10;
		var width:Number = old_x - x == 0 ?  default_size : Math.abs(old_x - x) + 20;
		var height:Number = old_y - y == 0 ? default_size :Math.abs(old_y - y) + 20;
		
		if (width > height) {
			height = width;
		} else {
			width = height;
		}
		
		var from_x:Number;
		var from_y:Number;
		var to_x:Number;
		var to_y:Number;
		
		this.x = x - (2 * Math.round(Math.random()) - 1) * 40 * Math.random();
		this.y = y - (2 * Math.round(Math.random()) - 1) * 40 * Math.random();
		
        this.top_bmp = new BitmapData(width, height, true, 0xffffff);
		
		from_x = x - this.x;
		from_y = y - this.y;
		to_x = old_x -this.x;
		to_y = old_y -this.y;
		
		var top_shape:Shape = new Shape();
		
		var height_first:Number = height / 2 / Math.sqrt(3);
		var height_second:Number = height - height_first;
		
		top_shape.graphics.lineStyle(1, c);
		top_shape.graphics.beginFill(0xffffff, 0.1);
		top_shape.graphics.moveTo(width / 2, 0);
		top_shape.graphics.lineTo(width - 1, height_first);
		top_shape.graphics.lineTo(width - 1, height_second);
		top_shape.graphics.lineTo(width / 2 , height - 1);
		top_shape.graphics.lineTo(0, height_second);
		top_shape.graphics.lineTo(0, height_first);
		top_shape.graphics.lineTo(width / 2, 0);
		top_shape.filters = [new GlowFilter(c, 0.8, 8, 8, 2)];
		
		this.top_bmp.draw(top_shape);
    }
	
	public function move():Boolean
	{
		life--;
		
		if (life <= 0) {
			return false;
		}
		
		return true;
	}
}
