/**
 * Copyright JohnBrookes ( http://wonderfl.net/user/JohnBrookes )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qtzF
 */

// wireframe edge material  for cubes
package
{
	import flash.events.Event;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.view.BasicView;
	
	public class PVtest extends BasicView
	{
		
		private static var CUBE_DIM:Number = 100;
		private static var CUBE_SIDES:int = 3;
		private static var CUBE_SPACING:Number =  40;
		private var bigCubeMiddlePoint:Number = -(CUBE_SIDES * (CUBE_DIM+CUBE_SPACING))*.5;
		private var bigCube:DisplayObject3D;
		
		public function PVtest():void
		{
			init();
			singleRender();
			addEventListener(Event.ENTER_FRAME, tick);
		}
		
		private function init():void
		{
			scene.addChild(generateCube());
			
		}
		private function createMaterialList( color:uint ):MaterialsList {
            var ml:MaterialsList = new MaterialsList();
            ml.addMaterial( new CubeEdgeWireframeMaterial(color), "front" );
            ml.addMaterial( new CubeEdgeWireframeMaterial(color), "back" );
            ml.addMaterial( new CubeEdgeWireframeMaterial(color), "top" );
            ml.addMaterial( new CubeEdgeWireframeMaterial(color), "bottom" );
            ml.addMaterial( new CubeEdgeWireframeMaterial(color), "right" );
            ml.addMaterial( new CubeEdgeWireframeMaterial(color), "left" );
           
            return ml;
        }
		 private function generateCube():DisplayObject3D {
                  //Current little cube which will be generated in for loop
                  var cube:Cube;
                  //Final cube which will be returned
                  bigCube = new DisplayObject3D();
                  //Material for cube creation
                  var cubeMaterialsList:MaterialsList;
                 var count:int = 0;
                  //Symbol explanation: i -> x, j -> y, k -> z
                  for ( var i:uint = 0; i < CUBE_SIDES; i++ ) {
                      for ( var j:uint = 0; j < CUBE_SIDES; j++ ) {
                          for ( var k:uint = 0; k < CUBE_SIDES; k++ ) {
                              cubeMaterialsList = createMaterialList( Math.random()*0xFFFFFF );
                              cube = new Cube( cubeMaterialsList, CUBE_DIM, CUBE_DIM, CUBE_DIM, 3, 3, 3 );
                              //Put cube in position relative to big cube middle
                              cube.x = bigCubeMiddlePoint + i * ( CUBE_DIM + CUBE_SPACING ) + CUBE_DIM / 2;
                              cube.y = bigCubeMiddlePoint + j * ( CUBE_DIM + CUBE_SPACING ) + CUBE_DIM / 2;
                              cube.z = bigCubeMiddlePoint + k * ( CUBE_DIM + CUBE_SPACING ) + CUBE_DIM / 2;
                              //Set cube name so that later it can be identified
                              cube.name = "x" + ( i + 1) + "y" + ( j + 1) + "z" + ( k + 1);
                              bigCube.addChild( cube );
							  count++;
                          }
                      }
                  }
                 trace(count);
                  return bigCube;
              }
		
		private function tick(e:Event):void 
		{
			bigCube.yaw(1);
			camera.orbit(viewport.mouseY-viewport.viewportHeight/2, viewport.mouseX - viewport.viewportWidth/2)
			singleRender();
		}
	}
}	
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.geom.Matrix;
	
	import org.papervision3d.core.geom.renderables.Triangle3D;
	import org.papervision3d.core.material.TriangleMaterial;
	import org.papervision3d.core.render.command.RenderTriangle;
	import org.papervision3d.core.render.data.RenderSessionData;
	import org.papervision3d.core.render.draw.ITriangleDrawer;
	
	/**
	* The CubeEdgeWireframeMaterial class creates a wireframe material, where only the edges of the cube are drawn.
	* <p/>
	* Materials collects data about how objects appear when rendered.
	*/
	class CubeEdgeWireframeMaterial extends TriangleMaterial implements ITriangleDrawer
	{
		
		/**
		* The CubeEdgeWireframeMaterial class creates a wireframe material, where only the edges of the cube are drawn.
		*
		* @param	asset				A BitmapData object.
		*/
		public function CubeEdgeWireframeMaterial( color:Number=0xFF00FF, alpha:Number=1, thickness:Number = 0 )
		{
			this.lineColor     = color;
			this.lineAlpha     = alpha;
			this.lineThickness = thickness;

			this.doubleSided = false;
		}
		
		/**
		 *  drawTriangle
		 */
		public override function drawTriangle(tri:RenderTriangle, graphics:Graphics, renderSessionData:RenderSessionData, altBitmap:BitmapData=null, altUV:Matrix=null):void{
			var x0:Number = tri.v0.x;
		var y0:Number = tri.v0.y;
		var x1:Number = tri.v1.x;
		var y1:Number = tri.v1.y;
		var x2:Number = tri.v2.x;
		var y2:Number = tri.v2.y;
			
			 if( lineAlpha )
        {
            graphics.lineStyle(lineThickness, lineColor, lineAlpha );
           if (tri.uv0.u == 1 )
			{
				graphics.moveTo( x0, y0 );
				graphics.lineTo( x1, y1 );
			}
			if (tri.uv0.u == 0)
			{
				graphics.moveTo( x0, y0 );
				graphics.lineTo( x2, y2 );
			}
			
			if (tri.uv1.v == 0)
			{
				graphics.moveTo( x0, y0 );
				graphics.lineTo( x1, y1 );
			}
			
			if (tri.uv1.v == 1)
			{
				graphics.moveTo( x2, y2 );
				graphics.lineTo( x1, y1 );
			}
            graphics.lineStyle();
        }
			renderSessionData.renderStatistics.triangles++;				
			
		}
	}