/**
 * Copyright J.J ( http://wonderfl.net/user/J.J )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qtwQ
 */

package  {
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.display.BlendMode;

    import flash.geom.Vector3D;
    import flash.events.Event;
    import flash.display.Sprite;

    public class Test extends Sprite {
        private var ps : PSystem;
        private var isThereMouse:Boolean;
        public function Test() {
            with(this.graphics){
                beginFill(0);
                drawRect(0,0,stage.stageWidth,stage.stageHeight);
                endFill();
                }
            stage.frameRate=60;
            ps=new PSystem(this, 30)
            
            stage.addEventListener(Event.MOUSE_LEAVE, mouseOff);
            stage.addEventListener(MouseEvent.MOUSE_MOVE,mouseOn);
            addEventListener(Event.ENTER_FRAME, loop)
        }
        private function mouseOff(e:Event):void{
            isThereMouse=false;
            }
         private function mouseOn(e:MouseEvent):void{

            isThereMouse=true;

            }
        private function loop(event : Event) : void {
            if(isThereMouse){
            ps.repelLoc.x=mouseX
            ps.repelLoc.y=mouseY
            
            }else{
             ps.repelLoc.x= ps.repelLoc.y=999999
            }
             ps.render()
        }

    }

}
import flash.text.TextField;

    import flash.display.DisplayObjectContainer;
    import flash.geom.Vector3D;

class PSystem{
    public var repelLoc:Vector3D=new Vector3D()
    public var particles:Vector.<Particle>;
    private var NUM:int;
    private var container:DisplayObjectContainer
    private var len:int

public function PSystem (con:DisplayObjectContainer,_num:int):void{
    particles=new Vector.<Particle>()
    NUM=_num;
    container=con;
    var s:Number=456/NUM

    for (var i : int = 1; i < NUM; i++) {
        for (var j : int = 1; j < NUM; j++) {
            var p:Particle=new Particle(i*s, j*s,(i+j)/10*0xffffff);
            container.addChild(p);
            particles.push(p);
            
        }
    }
    len=particles.length

}

public function render():void{

    for (var i : int = 0; i < len; i++) {
        var p:Particle=particles[i]
        p.applyForce(p.spring())
        p.applyForce(p.repell(repelLoc))
        p.applyForce(p.damping())
        p.render()

    }

    }

}



import flash.geom.Vector3D;
import flash.display.Sprite;

class Particle extends Sprite{

    private const K:Number=.5
    private const G:Number=80000
    public var loc:Vector3D,acc:Vector3D,vel:Vector3D,anchor:Vector3D;
    public var spLen:Number=0
    public var mass:Number=10;

    

public function Particle(_x:Number,_y:Number,_c:uint=0):void{
    loc=new Vector3D(_x,_y)
    anchor=loc.clone();
    acc=new  Vector3D()
    vel=new Vector3D()
    this.x=_x,this.y=_y;
    
    with(this.graphics) {
    beginFill(_c);
    drawCircle(0, 0, 7);
    endFill();
    }
   
}

public function applyForce(v:Vector3D):void{
    var f:Vector3D=v.clone();
    f.scaleBy(1/mass);
    acc=acc.add(f);

}

public function render():void{
        vel=vel.add(acc);
        vel=limit(vel, 5);
        loc=loc.add(vel);
        acc.scaleBy(0);
        //set location
        this.x=loc.x;
        this.y=loc.y 

}

public function spring():Vector3D{
    var f:Vector3D=loc.subtract(anchor);
    var d:Number=f.length;
    var X:Number=d-spLen;
    f.normalize();
    f.scaleBy(-1*K*X);
    return f;

}

private function limit(v:Vector3D,lim:Number):Vector3D{
 if(v.length>lim) v.normalize() , v.scaleBy(lim);
 return v;
}

public function damping():Vector3D{
    var f:Vector3D=vel.clone();
    f.scaleBy(-1);
    f.normalize()
    f.scaleBy(1);
    return f;

}

public function repell(repelLoc:Vector3D):Vector3D{
    var f:Vector3D=repelLoc.subtract(loc);
    var r:Number=f.length;
    f.normalize()
    var fs:Number=-1*G/(r*r);
    f.scaleBy(fs)
    return f;
}

}

