/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qtG7
 */

// forked from alexchirila87's forked from: [Away3D Lite] Depth of Field
// forked from clockmaker's [Away3D Lite] Depth of Field
// forked from clockmaker's [PV3D] Depth of Field
/*
   Depth of Field Demo
   with Away3D lite, BetweenAS3, Progression 4

   Papervision3Dで作ったデモをAway3D liteに移植してみた。
 */
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.system.*;
    import flash.utils.*;
    import away3dlite.containers.ObjectContainer3D;
    import away3dlite.core.base.*;
    import away3dlite.materials.*;
    import away3dlite.primitives.*;
    import away3dlite.templates.BasicTemplate;
    import jp.progression.commands.lists.SerialList;
    import jp.progression.commands.net.LoadBitmapData;
    import jp.progression.data.getResourceById;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.core.easing.*;
    import org.libspark.betweenas3.easing.Expo;
    import org.libspark.betweenas3.tweens.ITween;
    
    [SWF(width=465, height=465, frameRate=90)]
    /**
     * Depth of Field Demo
     * @author yasu
     */
    public class Main extends BasicTemplate {
        public static const IMG_URL:String = "http://assets.wonderfl.net/images/related_images/0/05/0577/05777317b05c43a2aa44e3c2e13d71b01d561497";
        
        private static const FOCUS_POSITION:int = 2000;
        private static const MAX_NUM:int = 150;
        private static const SNOW_MAX_DEPTH:int = 24;
        private var _blurs:Vector.<BitmapData>;
        private var _materials:Vector.<BitmapMaterial>;
        private var _particles:Vector.<Object3D>;
        private var _pitch:Number = 0;
        private var _radius:Number = 2500;
        private var _targetVertexs:Vector.<Vector3D>;
        private var _yaw:Number = 0;
        
        override protected function onInit():void {
            stage.quality = StageQuality.LOW;
            stop();
            new SerialList(null,
                new LoadBitmapData(new URLRequest(IMG_URL), { context: new LoaderContext(true)}),
                onInit2).execute();
        }
        
        protected function onInit2():void {
            // bmp
            var bmd:BitmapData = getResourceById(IMG_URL).toBitmapData();
            // create blur field material
            _blurs = new Vector.<BitmapData>(SNOW_MAX_DEPTH, true);
            for (var i:int = 0; i < SNOW_MAX_DEPTH; i++) {
                // create circle graphics
                var sp:Sprite = new Sprite();
                //sp.addChild(new BallImage());
                sp.addChild(new Bitmap(bmd));
                // ぼかしの適用値
                var blurFilter:BlurFilter = new BlurFilter(i, i, 4);
                // add Fileter
                sp.filters = [ blurFilter ];
                // copy bitmapdata
                var bitmapData:BitmapData = new BitmapData(100, 100, true, 0x00000000);
                bitmapData.draw(sp);
                // save
                _blurs[ i ] = bitmapData;
            }
            var vertexts:Array = [];
            // sphere
            vertexts[ 0 ] = [];
            var w:Material = new Material();
            var d:Mesh;
            d = new Cube6(w, 2000, 500, 2000, 4, 4, 4);
            vertexts[ 0 ] = [];
            for (i = 0; i < d.vertices.length / 3; i++)
                vertexts[ 0 ][ i ] = new Vector3D(d.vertices[ i ], d.vertices[ i + 1 ], d.vertices[ i + 2 ]);
            // cube
            d = new Cube6(w, 1000, 1000, 1000, 4, 4, 4);
            vertexts[ 1 ] = [];
            for (i = 0; i < d.vertices.length / 3; i++)
                vertexts[ 1 ][ i ] = new Vector3D(d.vertices[ i ], d.vertices[ i + 1 ], d.vertices[ i + 2 ]);
            // random
            vertexts[ 2 ] = [];
            for (i = 0; i < MAX_NUM; i++)
                vertexts[ 2 ][ i ] = new Vector3D((Math.random() - 0.5) * 3000, (Math.random() - 0.5) * 3000, (Math.random() - 0.5) * 3000);
            // init particle 
            _particles = new Vector.<Object3D>(MAX_NUM, true);
            _materials = new Vector.<BitmapMaterial>(MAX_NUM, true);
            for (i = 0; i < MAX_NUM; i++) {
                // ボール
                var mt:BitmapMaterial = new BitmapMaterial(_blurs[ 0 ]);
                _materials[ i ] = mt;
                var ball:Plane = new Plane(mt, 100, 100);
                ball.bothsides = true;
                // 内包して90度回転させておく (yawできないのでめんどっちー)
                var c:ObjectContainer3D = new ObjectContainer3D();
                c.addChild(ball);
                ball.rotationX = 90;
                scene.addChild(c);
                _particles[ i ] = c;
            }
            // init tween
            _targetVertexs = new Vector.<Vector3D>(MAX_NUM, true);
            var tweenArr:Array = [];
            var ease:IEasing = new CubicEaseIn();
            for (i = 0; i < MAX_NUM; i++) {
                var t1:Vector3D = vertexts[ 0 ][ i ];
                var t2:Vector3D = vertexts[ 1 ][ i ];
                var t3:Vector3D = vertexts[ 2 ][ i ];
                // init
                _targetVertexs[ i ] = t1;
                // cube1
                var tw1:ITween = BetweenAS3.delay(BetweenAS3.tween(_targetVertexs[ i ],
                    { x: t1.x, y: t1.y, z: t1.z },
                    { x: t3.x, y: t3.y, z: t3.z },
                    4, Expo.easeInOut), 1);
                // cube2
                var tw2:ITween = BetweenAS3.delay(BetweenAS3.tween(_targetVertexs[ i ],
                    { x: t2.x, y: t2.y, z: t2.z },
                    { x: t1.x, y: t1.y, z: t1.z },
                    4, Expo.easeInOut), 1);
                // random
                var tw3:ITween = BetweenAS3.delay(BetweenAS3.tween(_targetVertexs[ i ],
                    { x: t3.x, y: t3.y, z: t3.z },
                    { x: t2.x, y: t2.y, z: t2.z },
                    3, Expo.easeInOut), 0.5);
                tweenArr[ i ] = BetweenAS3.delay(BetweenAS3.serial(tw1, tw2, tw3), ease.calculate(i, 0, 0.75, MAX_NUM));
            }
            var masterTw:ITween = BetweenAS3.parallelTweens(tweenArr);
            masterTw.stopOnComplete = false;
            masterTw.play();
            start();
        }
        
        override protected function onPreRender():void {
            // camera
            _pitch += (mouseY / stage.stageHeight - 0.5) * 1;
            _yaw += (mouseX / stage.stageWidth - 0.5) * 4;
            camera.x = Math.sin(_yaw * Math.PI / 180) * _radius;
            camera.z = Math.cos(_yaw * Math.PI / 180) * _radius;
            camera.y = _pitch * _radius * 0.01;
            camera.lookAt(new Vector3D);
            // particle
            for (var i:int = 0; i < MAX_NUM; i++) {
                var p:Object3D = _particles[ i ];
                p.x = _targetVertexs[ i ].x;
                p.y = _targetVertexs[ i ].y;
                p.z = _targetVertexs[ i ].z;
                p.scaleX = p.scaleY = p.scaleZ = Math.sin(getTimer() / 150 + i * 0.04) * 0.5 + 1.1;
                // calc distance
                var f:Number = Math.abs(Vector3D.distance(camera.position, p.position) - FOCUS_POSITION);
                var deg:Number = (f ^ (f >> 31)) - (f >> 31); // Math.abs(f)と同等
                // calc blur val
                var blurVal:int = deg * .01 << 1; //ココの調整が絶妙
                blurVal = blurVal > SNOW_MAX_DEPTH - 1 ? SNOW_MAX_DEPTH - 1 : blurVal;
                _materials[ i ].bitmap = _blurs[ blurVal ];
                // lookat camera
                p.lookAt(camera.position);
            }
        }
    }
}