/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qsMa
 */

// forked from _wonder's base
package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.StageQuality;
    import flash.events.Event;
    
    [SWF(backgroundColor=0x000000)]
    public class Move extends Sprite {
        private var balls:Array;
        private var numBalls:Number = 200;
        private var minDist:Number = 80;
        private var friction:Number = 0.95;
        
        public function Move() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = StageQuality.MEDIUM;
            stage.frameRate = 60;            
            
            balls = new Array();
            for( var i:uint = 0; i < numBalls; i++ ){
                var ball:Ball = new Ball( 5, 0xffffff );
                ball.x = Math.random() * stage.stageWidth;
                ball.y = Math.random() * stage.stageHeight;
                ball.alpha = 0.6;
                addChild( ball );
                balls.push( ball );
            }
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            for( var i:uint = 0; i < numBalls; i++ ){
                var ball:Ball = balls[i];
                move( ball );
            }
            
            graphics.clear();
            for( i = 0; i < numBalls; i++ ){
                var ballA:Ball = balls[i];
                for( var j:uint = i+1; j < numBalls; j++ ){
                    var ballB:Ball = balls[j];
                    line(ballA, ballB);
                }
            }
        }

        private function move(ball:Ball):void {
            var dx:Number = mouseX - ball.x;
            var dy:Number = mouseY - ball.y;
            var dist:Number = Math.sqrt( dx*dx + dy*dy );
            var ax:Number = 0;
            var ay:Number = 0;
            
            if( dist < minDist ){
                ax = minDist / dx;
                ay = minDist / dy;
                ax *= -1;
                ay *= -1;
            }
            
            ball.vx += ax;
            ball.vy += ay;
            ball.vx *= friction;
            ball.vy *= friction;
            ball.x += ball.vx;
            ball.y += ball.vy;
            
            if( ball.x > stage.stageWidth ){
                ball.x = 0;
            } else if( ball.x < 0 ){
                ball.x = stage.stageWidth;
            }
            if( ball.y > stage.stageHeight ){
                ball.y = 0;
            } else if( ball.y < 0 ){
                ball.y = stage.stageHeight;
            }
        }
        
        private function line( ballA:Ball, ballB:Ball ):void {
            var dx:Number = ballB.x - ballA.x;
            var dy:Number = ballB.y - ballA.y;
            var dist:Number = Math.sqrt( dx*dx + dy*dy );
            
            if( dist < minDist ){
                graphics.lineStyle( 0, 0xffffff, 1 - dist/minDist );
                graphics.moveTo( ballA.x, ballA.y );
                graphics.lineTo( ballB.x, ballB.y );
            }
        }
    }
}

import flash.display.Sprite;

class Ball extends Sprite {
    public var radius:Number;
    public var color:uint;
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public function Ball(radius:Number=40, color:uint=0Xff0000){
        this.radius = radius;
        this.color = color;
        init();
    }
    
    public function init():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
}