/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qrZ8
 */

package {
    import flash.utils.Proxy;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.ui.Keyboard;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
       
       
       public var temp:BitmapData;
       public var canvas:BitmapData;
       public var board:BitmapData;
       public var pic:Bitmap;
       public var test:Bitmap;
       
       public var mapwidth:int = 64;
       public var mapheight:int = 48;       
       
        public function FlashTest() 
        {
           
           board = new BitmapData(mapwidth,mapheight,false,0);
           canvas = new BitmapData(mapwidth, mapheight,false,0);
           pic = new Bitmap(canvas);
            addChild(pic);
            pic.scaleX = 3;
            pic.scaleY = 2;
            
            temp = new BitmapData(mapwidth,mapheight,false,0);
            test = new Bitmap(temp);
            addChild(test);
            test.x = 200;
            
            
            cx = mapwidth / 2;
            cy = mapheight - 1;
            
            //border
            board.fillRect(new Rectangle(0,0,board.width,1),0x00FF00);
            board.fillRect(new Rectangle(0,board.height-1,board.width,1),0x00FF00);
            board.fillRect(new Rectangle(0,0,1,board.height),0x00FF00);
            board.fillRect(new Rectangle(board.width-1,0,1,board.height),0x00FF00);
            
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, kdown);
            stage.addEventListener(KeyboardEvent.KEY_UP, kup);
        }//ctor
        

        public var dir:int = 0;
        public var cx:int = 64;
        public var cy:int = 48;
        public var px:int = 64;
        public var py:int = 48;
        public var pdir:int = 0;
        public var move:int = 0;
        
        public var ex:Number = 16;
        public var ey:Number = 32;
        
        public var ex2:Number = 40;
        public var ey2:Number = 30;
        
        public var prev:int = 1;
        public var pm:int = 0;
        
        public function onEnter(e:Event):void
        {
            canvas.lock();
            
                canvas.draw(board);
                canvas.setPixel(cx,cy, 0xFF0000);
            
            canvas.unlock();
            
            if (pm <= 0)
            {
                if ( (pdir != 1) && vecKey[Keyboard.UP]) { cy -= 1; dir = 0; move = 1; }
                else if (( pdir != 0) && vecKey[Keyboard.DOWN]) {cy += 1; dir = 1; move = 1;}
                else if ((pdir != 3) && vecKey[Keyboard.LEFT]) { cx -= 1; dir = 2; move = 1; }
                else if ((pdir != 2) && vecKey[Keyboard.RIGHT]) { cx += 1; dir = 3; move = 1; } 
            }
            else
            {
                if ( vecKey[Keyboard.UP]) { cy -= 1; dir = 0; move = 1; }
                else if ( vecKey[Keyboard.DOWN]) {cy += 1; dir = 1; move = 1;}
                else if (vecKey[Keyboard.LEFT]) { cx -= 1; dir = 2; move = 1; }
                else if (vecKey[Keyboard.RIGHT]) { cx += 1; dir = 3; move = 1; } 
            }//endif
            
            if (cy < 0) { cy = 0;}
            if (cy >= mapheight) { cy = mapheight-1;}
            if (cx < 0) { cx  = 0;}
            if (cx >= mapwidth) { cx = mapwidth-1; }
            
            
            var pc:uint;
            
            pc = board.getPixel(cx,cy);
            
              pm = 0;
              if (pc == 0x00FF00)
              { pm = 1;}
              
            if (move > 0 && pc == 0x0000FF)
            {
                cleanBoard();
                cx = mapwidth / 2;
                cy = mapheight - 1;
                px = cx;
                py = cy;
                move = 0;
                return;
              }
              move = 0;
            
            if (pc != 0x00FF00)
            {
             prev = 0;
             board.setPixel(cx,cy, 0x0000FF);
            // testFill();
            } 
            else
            {
                if (prev == 0)
                {
                prev = 1;
                testFill();
                }
               
             }//endif
            
        
             
            /*
            if (px != cx || py != cy)
            {
              board.setPixel(cx,cy, pdir == dir ? 0x0000FF : 0xFF00FF);
            }//endif
          */
          
           px = cx;
           py = cy;  
           pdir = dir;
           
           canvas.setPixel(ex, ey, 0xFF00FF);
           canvas.setPixel(ex+1, ey, 0xFF00FF);
           canvas.setPixel(ex-1, ey, 0xFF00FF);
           canvas.setPixel(ex, ey+1, 0xFF00FF);
           canvas.setPixel(ex, ey-1, 0xFF00FF);
           
           canvas.setPixel(ex2, ey2, 0xFF00FF);
           canvas.setPixel(ex2+1, ey2, 0xFF00FF);
           canvas.setPixel(ex2-1, ey2, 0xFF00FF);
           canvas.setPixel(ex2, ey2+1, 0xFF00FF);
           canvas.setPixel(ex2, ey2-1, 0xFF00FF);
        }//onenter
        
        public var dp:Point = new Point();
        public function cleanBoard():void
        {
            temp.fillRect(temp.rect, 0);
            temp.copyChannel(board, board.rect, dp,1,1);
            temp.copyChannel(board, board.rect, dp,2,2);
            
            board.fillRect(board.rect, 0);
            board.draw(temp);
        }//clean
        
        public function testFill():void
        {
            temp.fillRect(temp.rect, 0);
            temp.draw(board);
            
            temp.floodFill(ex,ey, 0xFF00FF);
            temp.floodFill(ex2,ey2, 0xFF00FF);
            
            
            
            var k:int;
            var i:int;
            var u:uint;
            
            for (i = 0; i < mapheight;i++)
            {
                for (k = 0; k < mapwidth; k++)
                {
                    u = temp.getPixel(k, i);
                    if (u == 0 || u == 0x0000FF)
                    {
                      board.floodFill(k,i,0x00FF00);  
                    }
                    
                }//nextk  
              }//nexti
            
            /*
            for (i = -1; i<=1;i+=1)
            {
               if (cy + i < 1) { continue;}
               if (cy +i >= mapheight-1) { continue; }
               for (k = -1; k <= 1; k+=1)
               {
                 if (cx+k < 1) {continue;}
                 if (cx+k >= mapwidth-1) {continue;}
                 u = temp.getPixel(cx+k, cy+i);
                 if (u == 0 || u == 0x0000FF)
                 {
                  board.floodFill(cx+k,cy+i,0x0000FF);
                  board.floodFill(cx+k,cy+i,0x00FF00);
                  //return;   
                 } //endif 
                 
               }//nextk  
            }//nexti
            */
            //board.draw(ztemp);
        }//testfill
        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,false);
        
        public function kdown(e:KeyboardEvent):void
        { vecKey[e.keyCode] = true;  }
        
        public function kup(e:KeyboardEvent):void
        { vecKey[e.keyCode] = false; }
        
    }//classend
}