/**
 * Copyright gahaku500 ( http://wonderfl.net/user/gahaku500 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qrQj
 */

// forked from termat's forked from: CBC NET
package
{
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.MovieClip;
    import flash.events.KeyboardEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.events.MouseEvent;
    import flash.system.LoaderContext;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.text.TextFormat;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.net.navigateToURL;
    import org.papervision3d.core.geom.renderables.Triangle3D;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.math.NumberUV;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.core.effects.view.ReflectionView;
    
    [SWF(backgroundColor = "0x000000", fps = "60")]
    public class CBC20101121 extends ReflectionView {
        private var _feed:String = "http://assets.wonderfl.net/static/assets/session5/cbcnet_feed.xml";
        private var list:Vector.<Plate> = new Vector.<Plate>();
        private var map:Array;
        private var mes:Array;
        private var des:Array;
        private var counter:int = 0;
        private var pop:TextField;
        private var pop2:TextField;
        private var bar:Bar;
        private var link:String = null;

        public function CBC20101121():void {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align     = StageAlign.TOP_LEFT;
            stage.quality   = StageQuality.MEDIUM;
            this.viewport.interactive = true;
            bar = new Bar();
            initObj();
            addChild(bar);
        }

        private function initObj():void {
            camera.focus = 500;
            camera.zoom  = 2;
            camera.z     = -1600;
            initFloor()
            addEventListener(Event.ENTER_FRAME, update);
            pop = new TextField();
            pop.restrict = null;
            pop.border = true;
            pop.multiline = true;
            var tx:TextFormat = new TextFormat();
            tx.size = 16;
            tx.bold = true;
            pop.defaultTextFormat = tx;
            pop.background = true;
            pop.backgroundColor = 0xffffff;
            pop.borderColor = 0xcccccc;
            pop.border = true;
            pop.alpha = 0.7;
            pop2 = new TextField();
            pop2.restrict = null;
            pop2.border = true;
            pop2.multiline = true;
            var tx2:TextFormat = new TextFormat();
            tx.size = 12;
            pop2.defaultTextFormat = tx2;
            pop2.background = true;
            pop2.backgroundColor = 0xfafaff;
            pop2.borderColor = 0xcccccc;
            pop2.border = true;
            pop2.alpha = 0.7;
            pop.addEventListener(MouseEvent.CLICK, jump);
            pop2.addEventListener(MouseEvent.CLICK, jump);
            serch();
        }
        
        private function initFloor():void {
            var ldr:Loader = new Loader();
            ldr.contentLoaderInfo.addEventListener(Event.COMPLETE, imageLoadFloorCompleted);
            ldr.load(new URLRequest("http://assets.wonderfl.net/images/related_images/8/81/81d9/81d938b82ecdf3b312a66aa83fec539e37462a9bm"), new LoaderContext(true));
        }

        private function imageLoadFloorCompleted(e:Event):void {
            var loader:Loader = e.target.loader;
            var tmp:BitmapData = new BitmapData(loader.width, loader.height);
            tmp.draw(loader);
            var copyRect:Rectangle=new Rectangle(0,0,tmp.width,tmp.height);
            var copyPt:Point=new Point(0,0);
            var bmp:BitmapData = new BitmapData(loader.width, loader.height,true,0xffffffff);
            bmp.copyPixels(tmp, copyRect, copyPt);
            for (var x:int = 0; x < loader.width; x++) {
                for (var y:int = 0; y < loader.height; y++) {
                    var v:uint = bmp.getPixel32(x, y);
                    v = v - 0x88000000;
                    bmp.setPixel32(x, y, v);
                }
            }
            var bm:BitmapMaterial = new BitmapMaterial(bmp);
            bm.oneSide = false;
            bm.interactive = true;
            var col:ColorMaterial = new ColorMaterial(0xffffff, 0.5);
            var co:CompositeMaterial = new CompositeMaterial();
            co.addMaterial(col);
            co.addMaterial(bm);
            var floor:Plane = new Plane(bm, 5000, 5000, 12, 12);
            scene.addChild(floor);
            floor.pitch( 90);
        }
        
        private function update(e:Event):void {
            camera.x += (mouseX / stage.stageWidth * 600 - 300) - camera.x * 0.07;
            camera.y += (mouseY / stage.stageHeight * 200) - camera.y * 0.07;
            for (var i:int = 0; i < list.length; i++) {
                var p:Plate = list.shift();
                p.update();
                if (p.live) {
                    list.push(p);
                }else {
                    scene.removeChild(p);
                }
            }
            singleRender();    
        }
        
        private function serch():void {
            counter = 0;
            map = new Array();
            mes = new Array();
            des = new Array();
            while (list.length > 0) list.pop();
            var ldr:URLLoader = new URLLoader();
            ldr.addEventListener(Event.COMPLETE, function _load(e:Event):void {
                ldr.removeEventListener(Event.COMPLETE, _load);
                bar.setTitleStr(XML(ldr.data).channel.title);
                var item:XMLList = XML(ldr.data)..item;
                var images:Array = new Array();
                var links:Array = new Array();
                var titles:Array = new Array();
                var descs:Array = new Array();
                for (var i:int = 0; i < item.length(); i++) {
                    images.push(item[i].image.toString());
                    links.push(item[i].link.toString());
                    titles.push(item[i].title.toString());
                    descs.push(item[i].description.toString());
                }
                onImageLoaded(images, links, titles, descs);
            });
            ldr.load(new URLRequest(_feed));
        }
    
        private function onImageLoaded($images:Array, $url:Array, $title:Array,$desc:Array):void {
            var ldr:Loader;
            for (var i:int = 0; i < $images.length; ++i) {
                map[$images[i]] = $url[i];
                mes[$images[i]] = getDispText($title[i], 40);
                des[$images[i]] = getDispText($desc[i],40);
                ldr = new Loader();
                ldr.contentLoaderInfo.addEventListener(Event.COMPLETE, imageLoadPhotoCompleted);
                ldr.load(new URLRequest($images[i]), new LoaderContext(true));
            }
        }
        
        private function getDispText(str:String,ll:int):String {
            var ret:String = "";
            var n:int = 1;
            for (var i:int = 0; i < str.length; i++) {
                if (n % ll == 0) ret = ret + "\n";
                ret = ret + str.charAt(i);
                n++;
            }
            return ret;
        }
        
        private function imageLoadPhotoCompleted(e:Event):void {
            var i:int = counter++;
            var loader:Loader = e.target.loader;
            var bmp:BitmapData = new BitmapData(loader.width, loader.height);
            bmp.draw(loader);
            var bm:BitmapMaterial = new BitmapMaterial(bmp);
            bm.oneSide = false;
            bm.interactive = true;
            var p:Plate = new Plate(bm, 300, 300, 2, 2, map[e.target.url],mes[e.target.url],des[e.target.url]);
            p.bx = (i % 5) * 500-1250;
            p.bz = Math.floor(i / 5) * 500-1000;
            p.by = 200;
            p.x = 10000;
            p.z = 10000;        
            p.roll(0);
            p.addEventListener(InteractiveScene3DEvent.OBJECT_PRESS, onPress);
            p.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, onOver);
            p.addEventListener(InteractiveScene3DEvent.OBJECT_OUT,onOut);
            list.push(p);
            scene.addChild(p);
        }
        private function onPress(e:InteractiveScene3DEvent):void {
            var p:Plate = e.displayObject3D as Plate;
            var u:String = p.url;    
            var url:URLRequest = new URLRequest(u);
            navigateToURL(url,"_blank");
        }
        
        private function onOver(e:InteractiveScene3DEvent):void {
            var p:Plate = e.displayObject3D as Plate;
            pop.text = p.mes;    
            pop.x = mouseX - 50;
            pop.y = mouseY - 25;
            pop.width = pop.textWidth + 10;
            pop.height = pop.textHeight + 5;
            addChild(pop);
            pop2.text = p.des;
            pop2.x = pop.x;
            pop2.y = pop.y + pop.height + 5;
            if (pop2.textWidth + 10 > pop.width) {
                pop2.width = pop2.textWidth + 10;
            }else {
                pop2.width = pop.width;
            }
            addChild(pop2);
            link = p.url;
        }

        private function onOut(e:InteractiveScene3DEvent):void {
            removeChild(pop);
            removeChild(pop2);
            link = null;
        }
        
        private function jump(e:MouseEvent):void {
            if (link != null) {
                var url:URLRequest = new URLRequest(link);
                navigateToURL(url,"_blank");
            }
        }
    }
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.display.MovieClip;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import flash.text.TextField;
import org.papervision3d.core.proto.MaterialObject3D;
import org.papervision3d.objects.primitives.Plane;
import flash.text.TextFormat;

class Plate extends Plane {
    public var bx:Number;
    public var by:Number;
    public var bz:Number;
    private var isRemove:Boolean = false;
    public var live:Boolean = true;
    public var url:String;
    public var mes:String = "";
    public var des:String = "";

    public function Plate(material:MaterialObject3D = null, width:Number = 0, height:Number = 0, segmentsW:Number = 0,
        segmentsH:Number = 0,u:String=null,ms:String=null,ds:String=null) {
        super(material, width, height, segmentsW, segmentsH);
        url = u;
        if (ms != null) mes = ms.replace("&lt;p&gt;", "").replace("&lt;/p&gt;", "");
        if (ds != null) des = ds.replace("&lt;p&gt;", "").replace("&lt;/p&gt;", "");
    }
    
    public function update():void {
        if (Math.abs(bx - x) > 1e-8) x += (bx - x) * 0.1;
        if (Math.abs(by - y) > 1e-8) y += (by - y) * 0.1;
        if (Math.abs(bz - z) > 1e-8) z += (bz - z) * 0.1;
        if (isRemove&&(Math.abs(bx + bz - x - z) < 1)) {
            live = false;
        }
    }
    
    public function remove():void {
        bx = -5000;
        bz = -5000;
        isRemove = true;
    }
}

class Bar extends Sprite {
    public var title:TextField;
    
    public function Bar() {
        var ldr:Loader = new Loader();
        ldr.contentLoaderInfo.addEventListener(Event.COMPLETE, initIcon);
        ldr.load(new URLRequest("http://assets.wonderfl.net/images/related_images/8/81/81d9/81d938b82ecdf3b312a66aa83fec539e37462a9bm"), new LoaderContext(true));
        title = new TextField();
        title.restrict = null;
        title.border = true;
        var tx:TextFormat = new TextFormat();
        tx.size = 24;
        tx.bold = true;
        tx.color = 0xdddddd;
        title.defaultTextFormat = tx;
        title.background = false;
        title.border = false;
        title.alpha = 0.7;
        title.x = 60; title.y = 10;
        addChild(title);
    }
    
    public function setTitleStr(t:String):void {
        title.text = t;
        title.width = title.textWidth + 10;
        title.height = title.textHeight + 5;
    }
    
    public function initIcon(e:Event):void {
        var icon:Sprite = new Sprite();
        var loader:Loader = e.target.loader;
        var bmp:BitmapData = new BitmapData(loader.width, loader.height);
        bmp.draw(loader);
        var bitmap:Bitmap = new Bitmap(bmp);
        bitmap.scaleX = 0.2; bitmap.scaleY = 0.2;
        bitmap.x = 10;bitmap.y = 10;
        addChild(bitmap);
    }
}
