/**
 * Copyright galao_doce ( http://wonderfl.net/user/galao_doce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qqsb
 */

// forked from mizt's ProjectedQuad
package {
    import flash.display.*;  
    import flash.events.*;
    import flash.geom.*; 
    
    [SWF(backgroundColor="0x0")]
    public class Main extends Sprite {
        
        private var _target:*=null;
        private var _graphics:Graphics;
        private var _bitmapData:BitmapData;
        private var _corner:Array = [];
        
        private var _indices:Vector.<int> = new Vector.<int>();
        private var _uvtData:Vector.<Number> = new Vector.<Number>();
        
        private var _xLen:Number; 
        private var _yLen:Number;
        private var _wInv:Number;
        private var _hInv:Number;
        private var _points:Array = [];
        
        public function Main() {
            stage.scaleMode = "noScale";
            stage.align = "TL";
            
            var w:int = stage.stageWidth;
            var h:int = stage.stageHeight;
            
            _graphics = this.graphics;
            
            _bitmapData = new BitmapData(512,512,false,0xCCCCCC);
            _bitmapData.fillRect(new Rectangle(256,0,256,256),0x666666);
            _bitmapData.fillRect(new Rectangle(0,256,256,256),0x666666);
            
            // 00 01 02 03 04
            // 05 06 07 08 09
            // 10 11 12 13 14
            // 15 16 17 18 19
            // 20 21 22 23 24
            
            _xLen=_bitmapData.width/4.;
            _yLen=_bitmapData.height/4.;
            
            _wInv = 1./_bitmapData.width;
            _hInv = 1./_bitmapData.height;
            
            for (var i:int=0;i<5;i++) {
                for (var j:int=0;j<5;j++ ) {
                    var _x:Number=j*_xLen;
                    var _y:Number=i*_yLen;
                    _points.push({x:_x,y:_y,sx:_x,sy:_y});
                }
            }
            
            _indices.push( 0, 1, 6);
            _indices.push( 0, 6, 5);
            _indices.push( 1, 2, 7);
            _indices.push( 1, 7, 6);
            _indices.push( 2, 3, 8);
            _indices.push( 2, 8, 7);
            _indices.push( 3, 4, 9);
            _indices.push( 3, 9, 8);
            
            _indices.push( 5, 6,11);
            _indices.push( 5,11,10);
            _indices.push( 6, 7,12);
            _indices.push( 6,12,11);
            _indices.push( 7, 8,13);
            _indices.push( 7,13,12);
            _indices.push( 8, 9,14);
            _indices.push( 8,14,13);
            
            _indices.push(10,11,16);
            _indices.push(10,16,15);
            _indices.push(11,12,17);
            _indices.push(11,17,16);
            _indices.push(12,13,18);
            _indices.push(12,18,17);
            _indices.push(13,14,19);
            _indices.push(13,19,18);
            
            _indices.push(15,16,21);
            _indices.push(15,21,20);
            _indices.push(16,17,22);
            _indices.push(16,22,21);
            _indices.push(17,18,23);
            _indices.push(17,23,22);
            _indices.push(18,19,24);
            _indices.push(18,24,23);
            
            _uvtData.push(0.00,0.00); _uvtData.push(0.25,0.00); _uvtData.push(0.50,0.00); _uvtData.push(0.75,0.00); _uvtData.push(1.00,0.00);
            _uvtData.push(0.00,0.25); _uvtData.push(0.25,0.25); _uvtData.push(0.50,0.25); _uvtData.push(0.75,0.25); _uvtData.push(1.00,0.25);
            _uvtData.push(0.00,0.50); _uvtData.push(0.25,0.50); _uvtData.push(0.50,0.50); _uvtData.push(0.75,0.50); _uvtData.push(1.00,0.50);
            _uvtData.push(0.00,0.75); _uvtData.push(0.25,0.75); _uvtData.push(0.50,0.75); _uvtData.push(0.75,0.75); _uvtData.push(1.00,0.75);
            _uvtData.push(0.00,1.00); _uvtData.push(0.25,1.00); _uvtData.push(0.50,1.00); _uvtData.push(0.75,1.00); _uvtData.push(1.00,1.00);
            
            for(var k:int=0; k<4; k++) {
                _corner.push(new Sprite());
                addChild(_corner[k]);
                _corner[k].graphics.beginFill(0xFF0099);
                _corner[k].graphics.drawCircle(0,0,6);
                _corner[k].graphics.endFill();
                _corner[k].buttonMode = true;
                _corner[k].addEventListener(MouseEvent.MOUSE_OVER,function(e:MouseEvent):void{e.currentTarget.alpha = 0.7;});
                _corner[k].addEventListener(MouseEvent.MOUSE_OUT,function(e:MouseEvent):void{e.currentTarget.alpha = 0.9;});
                _corner[k].addEventListener(MouseEvent.MOUSE_DOWN,down);
                _corner[k].alpha = 0.9;
            }
            
            _corner[0].x = w*0.1; _corner[0].y = h*0.1;
            _corner[1].x = w*0.9; _corner[1].y = h*0.1;
            _corner[2].x = w*0.9; _corner[2].y = h*0.9;
            _corner[3].x = w*0.1; _corner[3].y = h*0.9;
            
            
            this.addEventListener(Event.ENTER_FRAME,draw);
            
        }
        
        public function render():void {
            
            var len:int=_points.length;
            
            var dx30:Number = _corner[3].x-_corner[0].x;
            var dy30:Number = _corner[3].y-_corner[0].y;
            var dx21:Number = _corner[2].x-_corner[1].x;
            var dy21:Number = _corner[2].y-_corner[1].y;
                
            for(var k:int=0; k<len; k++) { 
                var point:Object = _points[k];
                var gx:Number=(point.x)*_wInv;
                var gy:Number=(point.y)*_hInv;
                var bx:Number=_corner[0].x+gy*(dx30);
                var by:Number=_corner[0].y+gy*(dy30);
                point.sx=bx+gx*((_corner[1].x+gy*(dx21))-bx);
                point.sy=by+gx*((_corner[1].y+gy*(dy21))-by);
            }
        }
        
        private function down(e:MouseEvent):void {
            if(_target) _target.stopDrag();
            _target = e.currentTarget;
            stage.addEventListener(MouseEvent.MOUSE_UP,up);
            _target.startDrag(true);
        }
        
        private function up(e:MouseEvent):void {
            stage.removeEventListener(MouseEvent.MOUSE_UP,up);
            _target.stopDrag();
            _target = null;
        }
        
        private function draw(e:Event):void {
            
            render();
            
            var vertices:Vector.<Number> = new Vector.<Number>();
            var len:int=_points.length;
            for(var k:int=0; k<len; k++) { 
                vertices.push(_points[k].sx,_points[k].sy);
            }

            _graphics.clear();
            _graphics.beginFill(0);
            _graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight)
            _graphics.endFill();
            _graphics.beginBitmapFill(_bitmapData,null,false,true);
            _graphics.drawTriangles(vertices, _indices, _uvtData);
            _graphics.endFill();
        }
    }
};
