/**
 * Copyright HaraMakoto ( http://wonderfl.net/user/HaraMakoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qqMs
 */

package {
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	
	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")]
	public class WheelScroll_rotate extends Sprite
	
	{
		//パーツMC
		private var scrHandle:MovieClip = new MovieClip();
		private var scrBar:MovieClip = new MovieClip();
		private var baseMC:MovieClip = new MovieClip();
		private var targetMC:MovieClip = new MovieClip();
		private var targetScaleMC:MovieClip = new MovieClip();
		
		//スクロールコントローラ
		private var srcCon:ScrollController;
		
		//debug
		private var tft:TextField = new TextField();
		
		//絵の配列
		private var pArray:Array = [ {x:152.76,y:112.106},{x:181.33,y:92.45},{x:203.553,y:60.126},
		{x:204.562,y:29.823},{x:197.492,y:13.662},{x:	229.814,y:16.692},{x:266.901,y:47.624},
		{x:274.26,y:95.48},{x:253.453,y:135.211},{x:222.744,y:156.085},{x:185.37,y:172.248},
		{x:167.085,y:175.322},{x:172.823,y:205.775},{x:	165.168,y:204.571},{x:154.911,y:177.179},
		{x:132.845,y:175.278},{x:106.671,y:176.394},{x:100.98,y:212.462},{x:89.868,y:209.867},
		{x:94.461,y:178.308},{x:78.3,y:168.208},{x:	53.047,y:159.116},{x:38.098,y:192.677},
		{x:28.57,y:186.396},{x:46.279,y:152.97},{x:23.548,y:130.25},{x:0.522,y:81.338},
		{x:9.613,y:33.864},{x:35.875,y:7.601},{x:58.098,y:0.53},{x:	77.517,y:8.128},{x:76.28,y:15.682},
		{x:61.128,y:10.631},{x:40.405,y:21.79},{x:28.805,y:56.086},{x:36.886,y:82.349},{x:48.353,y:99.127},
		{x:67.99,y:111.991},{x:75.941,y:96.996},{x:	85.783,y:102.693},{x:79.31,y:112.651},{x:101.728,y:120.339},
		{x:104.021,y:102.986},{x:115.737,y:104.527},{x:113.77,y:120.131},{x:137.896,y:116.692},{x:137.531,y:98.177},
		{x:	147.633,y:94.64} ];
	
		public function WheelScroll_rotate()
		{
			//パーツ構築
			constructView();
			//コントローラ作成
			srcCon = new ScrollController(scrHandle,scrBar,targetScaleMC,baseMC);
			srcCon.errTxt = tft;
			srcCon.targetScaleMC = targetMC;
			
			addEventListener(Event.ADDED_TO_STAGE, addStageHandler);
		}
		
		private function addStageHandler(e:Event):void
		{
			stage.addEventListener(MouseEvent.MOUSE_WHEEL, wheelHandler);
			
			scrHandle.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			scrHandle.buttonMode = true;
                        // don't take a capture
                        Wonderfl.disable_capture();
                        // take a capture after 2 sec
                        Wonderfl.capture_delay( 2 );
		}
		
		private function mouseDownHandler(e:MouseEvent):void
		{
			addEventListener(MouseEvent.MOUSE_MOVE,mouseMoveHandler);
		}
		private function mouseUpHandler(e:MouseEvent):void
		{
			removeEventListener(MouseEvent.MOUSE_MOVE,mouseMoveHandler);
		}
		private function mouseMoveHandler(e:MouseEvent):void
		{
			srcCon.dragHandle(null);
		}
		
		private function wheelHandler(e:MouseEvent):void
		{
			srcCon.getWheel(e.delta);
			//tft.text = String(e.delta);
		}
		
		//シェイプ作成、配置
		private function constructView():void
		{
			scrHandle.graphics.beginFill(0x333333)
			scrHandle.graphics.drawRect(0,0,50,30); //ハンドル
			scrHandle.graphics.endFill();
			scrBar.graphics.beginFill(0xFFFFFF);
			scrBar.graphics.drawRect(-1,-1,52,200); //バー
			scrBar.graphics.endFill();
			
			//表示領域
			baseMC.graphics.beginFill(0x333333,0);
			baseMC.graphics.drawRect(0,0,300,200);
			baseMC.graphics.endFill();
			
			//ターゲット
			//targetMC.graphics.beginFill(0x66FF66);
			//targetMC.graphics.drawRect(0,0,300,350);
			//targetMC.graphics.endFill();
			var imgMC:Sprite = new Sprite();
			var num:int = pArray.length;
			imgMC.graphics.lineStyle(10,0xFFFFFF);
			imgMC.graphics.beginFill(0x33cc00);
			imgMC.graphics.moveTo(pArray[0].x, pArray[0].y);
			for(var i:int=1; i<num; i++) {
				imgMC.graphics.lineTo(pArray[i].x, pArray[i].y);
			}
			imgMC.graphics.lineTo(pArray[0].x, pArray[0].y);
			imgMC.graphics.endFill();
			//imgMC.rotation = -90;
			imgMC.y = -100;
			imgMC.x = -150;
			targetMC.addChild(imgMC);
			targetMC.x = 220;
			targetMC.y = 220;
			
			
			scrHandle.x = 400; scrHandle.y = 50;
			scrBar.x = 400; scrBar.y = 50;
			baseMC.x = 50; baseMC.y = 50;
			
			addChild(baseMC);
			addChild(targetMC);
			addChild(tft);
			addChild(scrBar);
			addChild(scrHandle);
			
			
			//targetMC.mask = baseMC;
			
			targetScaleMC.graphics.beginFill(0xFCFCFC);
			targetScaleMC.graphics.drawCircle(0,0,100);
			targetScaleMC.graphics.endFill();
			targetScaleMC.x = 200; targetScaleMC.y = 200;
			//addChild(targetScaleMC);
			
			tft.textColor = 0xFFFFFF;
			tft.autoSize = TextFieldAutoSize.LEFT;
		}
		
	}
}
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.display.MovieClip;
	import flash.events.Event;
	import caurina.transitions.Tweener;
	import flash.text.TextField;
	


class ScrollController extends Sprite {
	//param
	private var yMax:Number; //ハンドルのy最大
	private var yMin:Number; //ハンドルのy最小
	private var targetMC:MovieClip; //操作対象
	private var targetBase:MovieClip; //土台
	public var paramY:Number = 0;

	private var minVol:Number = 0.1;
	private var maxVol:Number = 4.5;
	public var targetScaleMC:MovieClip; //スケール操作対象
	
	//コントローラ
	private var _handle:MovieClip;
	private var _bar:MovieClip;
	
	//表示オブジェクト
	private var left:MovieClip;
	private var right:MovieClip;
	
	//param
	private var defW:Number;
	private var defH:Number;
	private var pastChangeVol:Number;
	
	//debug
	public var errTxt:TextField;
	
	public function ScrollController(han:MovieClip,bar:MovieClip, tar:MovieClip, base:MovieClip)
	{
		_handle = han; _bar = bar;
		targetMC = tar; targetBase = base;
		yMin = _bar.y;
		yMax = _bar.y + _bar.height - _handle.height;
		
		left = new MovieClip();
		right = new MovieClip();
		
	}
	

	/**
	 * マウスホイール受け取ってのイベント
	 */
	public function getWheel(de:Number):void
	{
		var targetY:Number;
		var wSpeed:Number = 50;
		paramY = _handle.y; //現在のハンドルy
		targetY = -de * wSpeed + paramY;
		if(targetY >= yMax) targetY = yMax;
		if(targetY <= yMin) targetY = yMin;//debug
		errTxt.text = String(targetY);
		//変化量によって移動時間を調節する
		var seekTime:Number = 1;	
		//移動させる
		if(Tweener.isTweening(_handle))Tweener.removeTweens(_handle);
		if(Tweener.isTweening(targetMC))Tweener.removeTweens(targetMC);
		if(Tweener.isTweening(targetScaleMC))Tweener.removeTweens(targetScaleMC);
		
		Tweener.addTween( _handle, { y:targetY, time:seekTime, transition:"easeOutQuint"/*, onUpdate:_update*/ });
		Tweener.addTween( targetMC, { y:culcBaseY( targetY ), time:seekTime, transition:"easeOutQuint" });
		//スケールさせる
		Tweener.addTween( targetScaleMC, { scaleX:culcVol( targetY ), scaleY:culcVol( targetY ), time:seekTime, transition:"easeOutQuint" });
	}
	
	public function dragHandle(e:MouseEvent):void
	{
		if(mouseY >= yMax) {_handle.y = yMax;}
		else if(mouseY <= yMin) {_handle.y = yMin;}
		else{ _handle.y = mouseY-10;}
		var seekTime:Number = 1;
		
		//移動させる
		if(Tweener.isTweening(_handle))Tweener.removeTweens(_handle);
		if(Tweener.isTweening(targetMC))Tweener.removeTweens(targetMC);
		if(Tweener.isTweening(targetScaleMC))Tweener.removeTweens(targetScaleMC);
		
		Tweener.addTween( targetMC, { y:culcBaseY( _handle.y ), time:seekTime, transition:"easeOutQuint" });
		//スケールさせる
		Tweener.addTween( targetScaleMC, { scaleX:culcVol( _handle.y ), scaleY:culcVol( _handle.y ), time:seekTime, transition:"easeOutQuint" });
	}
	/**
	 * targetYより、ベースの移動先を算出します。
	 */
	private function culcBaseY(tY:Number):Number
	{
		var targetBaseY:Number = targetBase.y - (targetMC.height-targetBase.height) * ( ( tY - yMin ) / (yMax-yMin));
		return targetBaseY;
	}
	/**
	 * targetYより、サイズなど反映させたい場合
	 */
	private function culcVol(tY:Number):Number
	{
		var targetVol:Number = minVol + (maxVol - minVol) * ( ( tY - yMin ) / (yMax-yMin));
		return targetVol;
	}
	
}

