/**
 * Copyright Ctrl ( http://wonderfl.net/user/Ctrl )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qqDg
 */

/*
Noises from Hell
Dynamic Sound Generation
By: Ctrl
2009
*/
package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.media.*;
	import flash.utils.Timer;
	import flash.net.URLRequest;

	[SWF(backgroundColor="#000000",frameRate=30)]

	public class CtrlNoises extends Sprite 
	{
		public var values:Array=["0","-4.654","-1","2.11","2.1","1.65465","-2.3","2.4","-1.654","-1.111","-3.77","5.44"];
		public var sonido:Sound;
		public var ruido:Number=0;
		public var callme1:Number=-0.5999999;
		public var callme2:Number=values[getRandomNumber(0,values.length-5)]/3-0.4;
		public var time:Timer=new Timer(97,0);
		public var time3:Timer=new Timer(317,0);
		public var time4:Timer=new Timer(58,1);
		private var loadPic:Loader = new Loader();
		private var isItOn:String = "yes";

		public function CtrlNoises() 
		{
			createSkull();
			sonido = new Sound();
			startSounds();
			stage.addEventListener(MouseEvent.CLICK, switchSoundOnOff);
		}

		//////////////////////////////////////////////////////////////////////////////////////////////////////////////
		public function getRandomNumber(min:Number, max:Number):Number {
			var randomNumber:uint = Math.round(Math.random() *(max - min) + min);
			return randomNumber;
		}

		//////////////////////////////////////////////////////////////////////////////////////////////////////////////
		public function generadorSonido(e:SampleDataEvent):void {
			for (var i:uint=0; i<8192; i++) {
				ruido += (callme1 * callme2/111)/2.33;
				var n:Number=ruido*Math.PI*2;
				e.data.writeFloat(Math.sin(n));
				e.data.writeFloat(Math.sin(n));
			}
		}

		//////////////////////////////////////////////////////////////////////////////////////////////////////////////
		public function fluctuate(e:TimerEvent):void {
			callme2=values[getRandomNumber(0,values.length-5)]/3-0.4;
		}

		//////////////////////////////////////////////////////////////////////////////////////////////////////////////
		public function fluctuate2(e:TimerEvent):void {
			sonido.removeEventListener(SampleDataEvent.SAMPLE_DATA, generadorSonido);
			time4.start();
		}

		//////////////////////////////////////////////////////////////////////////////////////////////////////////////
		public function fluctuate3(e:TimerEvent):void {
			sonido.addEventListener(SampleDataEvent.SAMPLE_DATA, generadorSonido);
			sonido.play();
		}

		//////////////////////////////////////////////////////////////////////////////////////////////////////////////
		public function killSounds():void
		{
			sonido.removeEventListener(SampleDataEvent.SAMPLE_DATA, generadorSonido);
			time.stop();
			time3.stop();
			time4.stop();
			isItOn = "no";
		}

		//////////////////////////////////////////////////////////////////////////////////////////////////////////////
		public function startSounds():void
		{
			sonido.addEventListener(SampleDataEvent.SAMPLE_DATA, generadorSonido);
			sonido.play();
			time.start();
			time.addEventListener(TimerEvent.TIMER, fluctuate);
			time3.start();
			time3.addEventListener(TimerEvent.TIMER, fluctuate2);
			time4.addEventListener(TimerEvent.TIMER, fluctuate3);
			isItOn = "yes";
		}
		
		private function switchSoundOnOff(e:MouseEvent):void
		{
			if(isItOn == "yes")
			{
				killSounds();
			}
			
			else if(isItOn == "no")
			{
				startSounds();
			}
		}

		private function createSkull():void {
			loadPic.load(new URLRequest("http://poorreds.files.wordpress.com/2009/03/skull.jpg"));
			addChildAt(loadPic, 0);
			loadPic.scaleX=1.3;
			loadPic.scaleY=1.3;
			addEventListener(Event.ENTER_FRAME, loopMe);
		}

		private function loopMe(e:Event):void {
			loadPic.x=callme2*5-15;
			loadPic.y=callme2*20-90;
		}
	}
}