/**
 * Copyright k2syndrome_g ( http://wonderfl.net/user/k2syndrome_g )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qq9i
 */

package {
    import flash.text.TextField;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import org.papervision3d.view.*;
    import org.papervision3d.core.geom.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    public class Viewer extends BasicView {
        private var tf:TextField=new TextField();
        private const ang:Number=Math.pow(10,-10);
        private const rad:Number=Math.PI/180;
        private var md:Md;
        private var sphere:Array;
        private var r:int;
        private var theta:int;
        private var phi:int;
        public function Viewer() {
            //tf.border=true;
            //tf.text="start";
            stage.addChild(tf);
            md=new Md();
            //線を作成
            var L:Number=md.L/ang/2;
            var lineMaterial:LineMaterial=new LineMaterial(0xFF0000);
            var line1:Lines3D=new Lines3D(lineMaterial);
            line1.addNewLine(1,L,L,L,-L,L,L);
            line1.addNewLine(1,-L,-L,L,L,-L,L);
            line1.addNewLine(1,-L,-L,-L,L,-L,-L);
            line1.addNewLine(1,L,L,-L,-L,L,-L);
            scene.addChild(line1);
            //
            lineMaterial=new LineMaterial(0x0000FF);
            var line2:Lines3D=new Lines3D(lineMaterial);
            line2.addNewLine(1,-L,L,L,-L,-L,L);
            line2.addNewLine(1,L,-L,L,L,L,L);
            line2.addNewLine(1,-L,L,-L,-L,-L,-L);
            line2.addNewLine(1,L,-L,-L,L,L,-L);
            scene.addChild(line2);
            //
            lineMaterial=new LineMaterial(0x00FF00);
            var line3:Lines3D=new Lines3D(lineMaterial);
            line3.addNewLine(1,L,L,L,L,L,-L);
            line3.addNewLine(1,L,-L,L,L,-L,-L);
            line3.addNewLine(1,-L,L,L,-L,L,-L);
            line3.addNewLine(1,-L,-L,L,-L,-L,-L);
            scene.addChild(line3);
            //
            var material:ColorMaterial=new ColorMaterial(0xFFFFFF*Math.random());
            var sphere:Sphere=new Sphere(material,0.5);
            scene.addChild(sphere);
            //
            r=10;
            theta=90;
            phi=270;
            position();
            startRendering();
            //
            stage.addEventListener(MouseEvent.MOUSE_WHEEL,mouseW);
            stage.addEventListener(KeyboardEvent.KEY_DOWN,keyD);
            //
        }
        private function position():void{
            var tr:Number=theta*rad;
            var pr:Number=phi*rad;
            camera.x=r*Math.sin(tr)*Math.cos(pr);
            camera.z=r*Math.sin(tr)*Math.sin(pr);
            camera.y=r*Math.cos(tr);
        }
        //
        private function mouseW(e:MouseEvent):void{
            if(e.delta>0){
                r-=1;
            }else{
                r+=1;
            }
            position();
        }
        private function keyD(e:KeyboardEvent):void{
            switch(e.keyCode){
                case 67:
                    r=10;
                    theta=90;
                    phi=270;
                    break;
                case 37:
                    phi-=10;
                    break;
                case 39:
                    phi+=10;
                    break;
                case 38:
                    theta-=10;
                    break;
                case 40:
                    theta+=10;
                    break;
                default:
                    break;
            }
            position();
        }
        //
    }
}
class Md{
    private const ang:Number=Math.pow(10,-10);
    public const N:int=4//粒子数
    public const DELTAT:Number=Math.pow(10,-15)//Δt
    public const EPSILON:Number=0.5*ang;//ε
    public const SIGMA:Number=2.74*ang;//σ
    public const RCUT:Number=3*SIGMA;//ポテンシャルカットの距離
    public const L:Number=3*RCUT;//セル一辺の長さ
    //
    public var mol:Array;//粒子インスタンス
    public function Md(){
        //初期化
        var p0:Array=new Array(3);
        var v0:Array=new Array(3);
        for(var i:int=0;i<N;i++){
            p0=[0,1,1];
            v0=[0.0,0.0,0.0];
            mol[i]=new Mol(p0,v0);
        }
    }
}
class Mol{
    private const ang:Number=Math.pow(10,-10);
    public const DELTAT:Number=Math.pow(10,-15)//Δt
    public const MASS:Number=3.3509*Math.pow(10,-21);//粒子の重さ
    public const DT2M2:Number=0.5*Math.pow(DELTAT,2)/MASS//Δt^2/2MASS
    //
    public var pos0:Array=new Array(3);//tでの粒子の座標
    public var pos1:Array=new Array(3);//t+Δtでの粒子の座標
    public var velo:Array=new Array(3);//tでの粒子の速度
    public var force0:Array=new Array(3);//tでの粒子の受ける力
    public var force1:Array=new Array(3);//t+Δtでの粒子の受ける力
    //
    public function Mol(p:Array,v:Array){
        //初期化
        for(var r:int=0;r<3;r++){
            pos0[r]=p[r];
            velo[r]=v[r];
        }
    }
    public function getPos():void{
        for(var r:int=0;r<3;r++){
            pos1[r]=pos0[r]+velo[r]*DELTAT+force0[r]*DT2M2;
            if(pos1[r]){
            }
        }
    }
}