/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qpd9
 */

// forked from ProjectNya's Alternativa3D [slime]
////////////////////////////////////////////////////////////////////////////////
// Alternativa3D [slime]
//
// [Alt3D] モデル (1)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1756
//
// Colladaデータとテキスチャ
// @itoz師匠 ( http://wonderfl.net/user/romatica ) からいただきました。
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.display.Stage3D;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import alternativa.Alternativa3D;
    import alternativa.engine3d.core.Object3D;
    import alternativa.engine3d.core.Camera3D;
    import alternativa.engine3d.core.View;
    import alternativa.engine3d.core.Resource;
    import alternativa.engine3d.objects.Mesh;
    import alternativa.engine3d.materials.TextureMaterial;
    import alternativa.engine3d.materials.VertexLightTextureMaterial;
    import alternativa.engine3d.resources.BitmapTextureResource;
    import alternativa.engine3d.loaders.ParserCollada;
    import alternativa.engine3d.lights.OmniLight;
    import alternativa.engine3d.lights.AmbientLight;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="60")]

    public class Main extends Sprite {
        private var stage3D:Stage3D;
        private var scene:Object3D;
        private var camera:Camera3D;
        private var light:OmniLight;
        private var loader:URLLoader;
        private var imageloader:Loader;
        private var parser:ParserCollada;
        private var slime:Object3D;
        private static var radius:uint = 500;
        private var angle:Number = 180;
        private var degree:Number = 0;
        private static var depression:uint = 30;
        private static var radian:Number = Math.PI/180;
        private static var center:Object3D = new Object3D();
        private static var basePath:String = "http://www.project-nya.jp/images/wonderfl/";
        private static var colladaPath:String = "slime/slime.dae";
        private static var imagePath:String = "slime/slime.png";
        private var initialized:uint = 0;

        public function Main() {
            Wonderfl.disable_capture();
            //
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
        }

        private function init():void {
            scene = new Object3D();
            camera = new Camera3D(1, 1000);
            scene.addChild(camera);
            //camera.view = new View(465, 465, true, 0x000000, 1, 4);
            camera.view = new View(465, 465, false, 0x000000, 0, 4);
            addChild(camera.view);
            var alight:AmbientLight = new AmbientLight(0x666666);
            scene.addChild(alight);
            light = new OmniLight(0xFFFFFF, 500, 2000);
            scene.addChild(light);
            setup();
            addChild(camera.diagram);
            //
            stage3D = stage.stage3Ds[0];
            stage3D.addEventListener(Event.CONTEXT3D_CREATE, context, false, 0, true);
            stage3D.requestContext3D();
        }
        private function setup():void {
            camera.x = - radius;
            camera.y = 0;
            camera.z = 0;
            TransformUtils.lookAt(center, camera);
            light.x = - 500;
            light.y = 500;
            light.z = 500;
        }
        private function context(evt:Event):void {
            stage3D.removeEventListener(Event.CONTEXT3D_CREATE, context);
            load();
        }
        private function load():void {
            loader = new URLLoader();
            loader.dataFormat = URLLoaderDataFormat.TEXT;
            loader.addEventListener(Event.COMPLETE, loaded, false, 0, true);
            loader.load(new URLRequest(basePath + colladaPath));
            //
            imageloader = new Loader();
            imageloader.contentLoaderInfo.addEventListener(Event.COMPLETE, loaded, false, 0, true);
            imageloader.load(new URLRequest(basePath + imagePath));
        }
        private function loaded(evt:Event):void {
            evt.target.removeEventListener(Event.COMPLETE, loaded);
            //
            initialized ++;
            if (initialized < 2) return;
            parse();
            initialize();
            upload();
        }
        private function parse():void {
            parser = new ParserCollada();
            //parser.parse(XML(new ColladaData()));
            parser.parse(XML(loader.data));
            //
            //var bitmapData:BitmapData = new ImageData().bitmapData;
            var bitmapData:BitmapData = Bitmap(imageloader.content).bitmapData;
            var texture:BitmapTextureResource = new BitmapTextureResource(bitmapData);
            var material:VertexLightTextureMaterial = new VertexLightTextureMaterial(texture);
            for (var n:uint = 0; n < parser.objects.length; n++) {
                trace(parser.objects[n]);
                if (parser.objects[n] is Mesh) {
                    var mesh:Mesh = Mesh(parser.objects[n]);
                    for (var t:uint = 0; t < mesh.numSurfaces; t++) {
                        mesh.getSurface(t).material = material;
                    }
                }
            }
        }
        private function initialize():void {
            slime = parser.hierarchy[0];
            scene.addChild(slime);
            slime.z = - 25;
            slime.rotationZ = 0;
            slime.scaleX = slime.scaleY = 100;
            slime.scaleZ = 60;
        }
        private function upload():void {
            for each (var resource:Resource in scene.getResources(true)) {
                resource.upload(stage3D.context3D);
            }
            addEventListener(Event.ENTER_FRAME, render, false, 0, true);
        }
        private function render(evt:Event):void {
            camera.view.width = stage.stageWidth;
            camera.view.height = stage.stageHeight;
            //
            angle += 0.5;
            degree += 1;
            var dip:Number = depression*Math.sin(degree*radian);
            camera.x = radius*Math.cos(angle*radian)*Math.cos(dip*radian);
            camera.y = radius*Math.sin(angle*radian)*Math.cos(dip*radian);
            camera.z = radius*Math.sin(dip*radian);
            TransformUtils.lookAt(center, camera);
            //
            camera.render(stage3D);
        }
        
    }

}


//////////////////////////////////////////////////
// TransformUtilsクラス
//////////////////////////////////////////////////

import alternativa.engine3d.core.Object3D;
import alternativa.engine3d.core.Camera3D;

class TransformUtils {
    private static var radian:Number = Math.PI/180;

    public function TransformUtils() {
    }

    public static function lookAt(target:Object3D, camera:Camera3D):void {
        var dx:Number = target.x - camera.x;
        var dy:Number = target.y - camera.y;
        var dz:Number = target.z - camera.z;
        camera.rotationX = Math.atan2(dz, Math.sqrt(dx*dx + dy*dy)) - 90*radian;
        camera.rotationY = 0;
        camera.rotationZ = - Math.atan2(dx, dy);
    }

}
