/**
 * Copyright zappa ( http://wonderfl.net/user/zappa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qpbH
 */

// forked from cocoa's PV3D_Spirals
package  
{
	import flash.events.Event;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.view.BasicView;


	[SWF(backgroundColor = "#000000", frameRate = "30")]
	public class PV3DSpiral extends BasicView
	{

		private var angle:Number = 0;
		private var num_spirals:int = 5;

		
		public function PV3DSpiral(viewportWidth:Number=400, viewportHeight:Number=400, scaleToStage:Boolean=true, interactive:Boolean=false, cameraType:String="Target") 
		{
			super(viewportWidth, viewportHeight, scaleToStage, interactive,cameraType);
			init();
			startRendering();
		}
		
		private function init():void
		{	

			var total:int = 50;
			var one_angle:Number = ((Math.PI*2) * num_spirals) / total;

			for (var i:int = 0; i < total; i++)
			{
				var material:WireframeMaterial = new WireframeMaterial(0xFF0000);
				material.doubleSided = true;
				var plane:Plane = new Plane(material, 200, 200, 2, 2);
				scene.addChild(plane);
				plane.x = Math.cos(i * one_angle) *800  ;
				plane.z = Math.sin(i * one_angle) * 800;
				plane.y = 40*i;
				plane.rotationY = (-i*one_angle) * (180/Math.PI) + 270;
			}
		}
		
		override protected function onRenderTick(event:Event = null):void 
		{
			super.onRenderTick(event);
			var distX:Number = (stage.mouseX - stage.stageWidth * 0.5) * 0.0004;
			var distY:Number = (stage.mouseY - stage.stageHeight * 0.5) * -0.2;
			angle += distX;
			camera.x = Math.cos(angle) * 800;
			camera.z = Math.sin(angle) * 800;
		        distY =((camera.y+distY) < -1500)?  0: distY;
                        distY = ((camera.y + distY) > 3500)?  0: distY;
			camera.y += distY;

		}
		
	}
	
}