/**
 * Copyright folbore ( http://wonderfl.net/user/folbore )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qp1G
 */

// forked from umhr's Bitmap.draw()を使ってみる1
/*
Bitmapにstageの絵柄を書き込む。
Spriteが一つしか無いのに、
画面上には二つある。

左側はSpriteを描いて回転させたもの。
右側はstageに描かれている絵柄を
Bitmapに転写したもの。
*/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class Main extends Sprite {
        private var _sp:Sprite;
        private var _bitmap:Bitmap;

        public function Main() {
            
            _sp = new Sprite();
            _sp.graphics.beginFill(0xFF0000,0.5);
            _sp.graphics.drawRect(0,0,100,100);
            _sp.graphics.endFill();
            _sp.x=100;
            _sp.y=200;
            this.addChild(_sp);
            
            //bitmapの表示エリアを作っている。
            var bitmapData:BitmapData=new BitmapData(232,465);
            _bitmap=new Bitmap(bitmapData);
            _bitmap.x=232;
            this.addChild(_bitmap);
            
            this.addEventListener(Event.ENTER_FRAME,onEnter);
        }
        
        private function onEnter(event:Event):void {
            //Spriteを回転
            _sp.rotation++;
            
            //一度、真っ白に戻している。
            _bitmap.bitmapData.fillRect(_bitmap.bitmapData.rect,0xFFFFFF);
            //stageの内容を書き込んでいる。
            _bitmap.bitmapData.draw(stage);
        }
    }
}