/**
 * Copyright takishiki ( http://wonderfl.net/user/takishiki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qot4
 */

/*
 * 
 * HSV画像作成 -> ローカルにPNGファイルとして保存
 * 
 * x方向：Hue(0 -> 360)
 * y方向：Saturation(1.0 -> 0.0)
 * Vは1.0で固定
 * 
 */
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.net.FileReference;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.events.MouseEvent;
    import com.adobe.images.PNGEncoder;
    
    public class Main extends Sprite 
    {
        private var _btn    :Sprite;
        private var _imgSp    :Sprite;
        private var _bmpd    :BitmapData;
        
        // constructor
        public function Main() {
            // ボタンの背景
            _btn = new Sprite();
            var g:Graphics = _btn.graphics;
            g.lineStyle(2, 0x000000, 1.0);
            g.beginFill(0xCCCCCC, 1.0);
            g.drawRoundRect(0, 0, 80, 20, 4, 4);
            g.endFill();
            
            // ボタンのラベル
            var tf:TextField = new TextField();
            tf.autoSize = TextFieldAutoSize.CENTER;
            tf.text = "SAVE";
            tf.selectable = false;
            tf.mouseEnabled = false;
            tf.x = (_btn.width - tf.width) / 2;
            tf.y = (_btn.height - tf.height) / 2;
            _btn.addChild(tf);
            
            // ボタン
            _btn.x = _btn.y = 10;
            _btn.buttonMode = true;
            _btn.addEventListener(MouseEvent.CLICK, btnClick);
            
            this.addChild(_btn);
            
            // 画像作成
            _bmpd = new BitmapData(360, 360, false, 0x000000);
            makeImage();
            
            // 画像を表示
            _imgSp = new Sprite();
            _imgSp.x = _imgSp.y = 40;
            this.addChild(_imgSp);
            _imgSp.addChild(new Bitmap(_bmpd));
        }
        
        // Save Button Click
        private function btnClick(event:MouseEvent):void {
            var fr:FileReference = new FileReference();
            fr.save(PNGEncoder.encode(_bmpd), "image.png");    // PNG画像を保存
        }
        
        // HSVグラデーション画像作成
        private function makeImage():void {
            _bmpd.lock();
            var i:int;
            var j:int;
            for (i = 0; i < 360; i++) {
                for (j = 0; j < 360; j++) {
                    _bmpd.setPixel(i, j, hsv2rgb(i, (359 - j) / 359, 1.0));
                }
            }
            _bmpd.unlock();
        }
        
        // HSV -> RGB(uint)
        private function hsv2rgb(h:Number, s:Number, v:Number):uint {
            var r:Number = 0;
            var g:Number = 0;
            var b:Number = 0;
            
            if (s == 0) {
                r = g = b = v;
            }else {
                var hTemp:Number = (h + 360) % 360;
                hTemp /= 60;
                var i:Number = Math.floor(hTemp);   // 整数部
                var f:Number = hTemp - i;    // 小数部
                
                var p:Number = v * (1.0 - s);
                var q:Number = v * (1.0 - (s * f));
                var t:Number = v * (1.0 - (s * (1.0 - f)));
                
                switch(i) {
                    case 0:
                        r = v;
                        g = t;
                        b = p;
                        break;
                    case 1:
                        r = q;
                        g = v;
                        b = p;
                        break;
                    case 2:
                        r = p;
                        g = v;
                        b = t;
                        break;
                    case 3:
                        r = p;
                        g = q;
                        b = v;
                        break;
                    case 4:
                        r = t;
                        g = p;
                        b = v;
                        break;
                    case 5:
                        r = v;
                        g = p;
                        b = q;
                        break;
                }
            }
            return rgb2hex(r * 255, g * 255, b * 255);
        }
        
        // R, G, B -> hex color value
        private function rgb2hex(r:Number = 0, g:Number = 0, b:Number = 0):uint {
            r = Math.round(r);
            g = Math.round(g);
            b = Math.round(b);
            return 0xff000000 + r * 0x10000 + g * 0x100 + b;
        }
    }
}