/**
 * Copyright yun ( http://wonderfl.net/user/yun )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qoro
 */

// forked from yun's DisplacementMapFilterのエフェクト
// forked from yun's BlurFilterのエフェクト
// forked from yun's BlendModeの指定
// forked from yun's ColorTransformの指定
// forked from yun's Matrixの指定
// forked from yun's BitmapDataへの描画
package {
    
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.BlendMode;
    import flash.display.BitmapDataChannel;
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.DisplacementMapFilter;
    
    [SWF(width = 465, height = 465, backgroundColor = 0, frameRate = 30)]
    public class BitmapDataSample extends Sprite {
            
        private var bmpdata:BitmapData;
        private var sprite:Sprite;
        private var matrix:Matrix;
        private var colortrans:ColorTransform;
        private var bmpcolortrans:ColorTransform;
        // private var filter:BlurFilter;
        private var filter:DisplacementMapFilter;
            
        public function BitmapDataSample() {
            // BitmapDataを作成して表示リストに追加
            bmpdata = new BitmapData(465, 465, false, 0);
            addChild(new Bitmap(bmpdata));
            // グラフィックの作成
            sprite = newFig(0, 0, 40, 0xFFFFFF);
            matrix = new Matrix();
            colortrans = new ColorTransform();
            //bmpcolortrans = new ColorTransform(0.99, 0.99, 0.99);
            //filter = new BlurFilter(2, 2, 1);
            // エフェクトの初期化
            var mapBitmap:BitmapData = new BitmapData(465, 465, false, 0);
            var mapPoint:Point       = mapBitmap.rect.topLeft;
            var componentX:uint      = BitmapDataChannel.RED;
            var componentY:uint      = BitmapDataChannel.GREEN;
            var scaleX:Number        = 8;
            var scaleY:Number        = 8;
            mapBitmap.perlinNoise(240, 240, 2, 0, false, false)
            filter = new DisplacementMapFilter(mapBitmap, mapPoint, componentX, componentY, scaleX, scaleY);
            // イベント
            addEventListener(Event.ENTER_FRAME, enterframe);
            stage.addEventListener(MouseEvent.CLICK, reset);
        }
            
        private function enterframe(e:Event):void {
            // 変形
            matrix.identity();
            var s:Number = Math.random() * 2;
            var shaffleX:Number = Math.random() * 465;
            var shaffleY:Number = Math.random() * 465;
            matrix.scale(s, s);
            matrix.rotate(Math.PI * Math.random());
            matrix.translate(shaffleX, shaffleY);    // ランダムで配置
            //matrix.translate(mouseX, mouseY);    // マウスの位置に配置
            // 色変換
            colortrans.greenMultiplier = mouseX / 465;
            colortrans.blueMultiplier = mouseY / 465;
            colortrans.alphaMultiplier = Math.random();
            //bmpdata.colorTransform(bmpdata.rect, bmpcolortrans);
            bmpdata.applyFilter(bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter);
            // BitmapDataへ描画
            bmpdata.draw(sprite, matrix, colortrans, BlendMode.ADD);
        }
        
        private function reset(e:MouseEvent):void {
            bmpdata.fillRect(bmpdata.rect, 0xFF000000);
        }
        
        private function newFig(cx:Number, cy:Number, size:Number, col:uint):Sprite {
            // 中心(cx,cy), 幅高さsize, 色col　のグラフィックを生成
            var shape:Sprite = new Sprite();
            shape.graphics.lineStyle(0, 0x000000, 0.3);
            shape.graphics.beginFill(col);
            shape.graphics.drawCircle(cx, cy, size * 0.5);
            shape.graphics.drawCircle(cx, cy, size * 0.4);
            var w:Number = size * 0.6;
            var h:Number = size * 0.15;
            shape.graphics.drawRect(cx - w/2, cy - h/2, w, h);
            shape.graphics.endFill();
            return shape;
        }
    }
}