/**
 * Copyright otherone ( http://wonderfl.net/user/otherone )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qoSz
 */

package 
{
    import net.hires.debug.Stats;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import org.papervision3d.materials.BitmapAssetMaterial;
    import org.papervision3d.materials.special.ParticleMaterial;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.special.ParticleField;
    import org.papervision3d.view.BasicView;
    import flash.display.BitmapData;

    import org.papervision3d.materials.*;
    import flash.net.URLRequest;
    import flash.display.Loader;
    import flash.system.LoaderContext;

    [SWF(backgroundColor = 0x000000, frameRate = 50)]
   
    public class Pv3dTest extends MovieClip
    {

        private var loader:Loader;
        private var stgW:uint = stage.stageWidth;
        private var stgH:uint = stage.stageHeight;
        private var isMouseDown:Boolean;
        private var oldX:Number = 0;
        private var targetRot:Number = 0;
        private var oldY:Number = 0;
        private var targetRoty:Number = 0;
        public function Pv3dTest()
        {
            addChild(new Stats());
            var urlReq:URLRequest = new URLRequest(new String("http://images.kaneva.com/filestore9/4523625/6041795/moonmap1k.jpg"));
            //var loader:Loader = new Loader();
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE,set3D);
            loader.load(urlReq, new LoaderContext(true));
        }
        private function set3D(e:Event):void
        {
            var bmdata:BitmapData = new BitmapData(loader.width,loader.height);
            bmdata.draw(loader);

            // 3D表示用のインスタンスを作ります
            var world:BasicView = new BasicView();
            addChild(world);
            world.startRendering();
            /////////////////////////////////////////////////////////
            /////////////////////material/////////////////////////////

            // マテリアルを作成します
            // テクスチャー(＝マテリアル)を作ります
            //var material = new WireframeMaterial(0x0000FF);
            //material.doubleSided = true;

            // フラットシェードマテリアルは引数にライトと16進数の色を指定します
            //var material:FlatShadeMaterial =new FlatShadeMaterial(light, 0x3399FF);

            // ビットマップアセットマテリアルは引数にライブラリの画像を指定します
            var material:BitmapMaterial = new BitmapMaterial(bmdata);
            //var material:BitmapAssetMaterial = new BitmapAssetMaterial(bmdata);
            /////////////////////////////////////////////////////////
            ////////////////// ライトを作成します/////////////////////////
            var light:PointLight3D = new PointLight3D();

            /////////////////////////////////////////////////////////
            ////////////////// オブジェクトに反映して配置/////////////////////////
            var obj:Object = new Sphere(material,300,40,40);
            world.scene.addChild(obj);

            // パーティクルを生成;
            var particleMat:ParticleMaterial = new ParticleMaterial(0xFFFFFF,1);
            var particles:ParticleField = new ParticleField(particleMat,500,4,2000,2000,2000);
            world.scene.addChild( particles );


            /////////////////////////////////////////////////////////
            ////////////////// カメラ位置/////////////////////////
            //初期値
            //XYZ座標 ：x:0 y:0 z: -1000
            //Zoom値：40
            //focus値：8.660254037844387
            //world.camera.x = 200;
            //world.camera.y = 200;
            //world.camera.z = -1000;
            //
            //
            /////////////////////////////////////////////////////////
            ////////////////// ぐるぐる/////////////////////////
            // エンターフレーム時に呼び出す関数を設定します
            // 球面を回転させます
            //addEventListener(Event.ENTER_FRAME, function(e) { obj.rotationY += 1 } )
            // イベントの設定
            stage.addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, upHandler);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, moveHandler);

            // マウスを押されたとき
            function downHandler(e)
            {
                isMouseDown = true;
                oldX = mouseX;
            }

            // マウスを放したとき
            function upHandler(e)
            {
                isMouseDown = false;
            }

            // マウスが動いたとき
            function moveHandler(e)
            {
                if (isMouseDown)
                {
                    var dx:Number = e.stageX - oldX;
                    var dy:Number = e.stageY - oldY;

                    targetRot +=  dx * 0.25;
                    targetRoty +=  dy * 0.25;

                    oldX = e.stageX;
                    oldY = e.stageY;
                }
            }

            // アニメーション
            var rot:Number = 0;// 角度
            var roty:Number = 0;// 角度
            addEventListener(Event.ENTER_FRAME, fnAnime);
            function fnAnime(e:Event):void
            {
                // イージングの公式を用いて滑らかにする
                // 値 += (目標値 - 現在の値) * 減速値
                rot += (targetRot - rot) * 0.05;
                roty+=(targetRoty - roty) * 0.05;
                // 角度に応じてカメラの位置を設定
                world.camera.x = 1000 * Math.sin(rot * Math.PI / 180);
                world.camera.y = 1000 * Math.cos(roty * Math.PI / 180);
                world.camera.z = 1000 * Math.cos(rot * Math.PI / 180);

                // 地球は常に回転させておく
                obj.rotationY -=  0.25;
            }
        }
    }
}
