package  {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.media.Sound;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;

	/**
	* Tribute to cyriak.
	* @author makc
	* @license WTFPLv2
	* @see http://www.youtube.com/watch?v=Ag-_SOihwwg
	*/
	public class PedobearFractal extends Sprite {
		private var head:BitmapData;
		private var screen:BitmapData;
		private var loader:Loader;
		public function PedobearFractal () {
			super ();
			head = new BitmapData (256, 256, true, 0xFFFFFF);
			screen = new BitmapData (465, 465);
			addChild (new Bitmap (screen));
			loader = new Loader;
			loader.contentLoaderInfo.addEventListener (
				Event.COMPLETE,
				function (e:Event):void {
					head.draw (e.target.content);
				}
			);
			loader.load (new URLRequest (
				"http://assets.wonderfl.net/images/related_images/a/ad/ad9e/ad9e9653e38a876f955d614859d9ad3042521b74"),
				new LoaderContext (true)
			);
			addEventListener (Event.ENTER_FRAME, loop);
			// and some cyriak music too...
			var music:Sound = new Sound;
			music.load (new URLRequest (
				"http://s3.amazonaws.com/beatsdigital-previews/3/0/1/301954.mp3"));
			music.play (0, int.MAX_VALUE);
		}
		private var aAt:Array = [ new Point (260, 718), new Point (228, 470) ];
		private var aTo:Array = [ new Point (2.193956404725932, -1.1985638465105075), new Point (1, 0) ];
		private var t:Number = 0;
		private function loop (e:Event):void {
			t += 0.07; if (t > 1.0) t -= 1.0;

			var at:Point = Point.interpolate (aAt [0], aAt [1], t);
			var to:Point = Point.interpolate (aTo [0], aTo [1], t);

			screen.fillRect (screen.rect, 0xFFFFFF);
			drawHead (at, to);

			var m:Matrix = new Matrix; m.rotate (Math.PI); m.translate (465, 465);
			screen.draw (screen, m);

			m.identity (); m.rotate (-Math.PI / 2); m.translate (0, 465);
			screen.draw (screen, m);
		}
		private function drawHead (at:Point, to:Point):void {
			var s:Number = to.length;
			if (s > 0.02) {
				var a:Number = Math.atan2 (to.y, to.x);
				var m:Matrix = new Matrix;
				m.translate (-128, -128);
				m.scale (s, s);
				m.rotate (a);
				m.translate (at.x, at.y);
				// draw head
				screen.draw (head, m, null, null, null, true);
				// repeat for left ear
				m.identity (); m.rotate (+1.1); m.scale (-105, -105);
				var left:Point = m.transformPoint (to).add (at);
				m.identity (); m.rotate (-0.6); m.scale (0.37, 0.37);
				drawHead (left, m.transformPoint (to));
				// repeat for right ear
				m.identity (); m.rotate (-1.2); m.scale (+100, +100);
				var right:Point = m.transformPoint (to).add (at);
				m.identity (); m.rotate (+0.5); m.scale (0.40, 0.40);
				drawHead (right, m.transformPoint (to));
			}
		}
	}
}