/**
 * Copyright mezumona ( http://wonderfl.net/user/mezumona )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qn8S
 */

/**
 * 
 */
package
{
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	public class DictionarySpeedTest extends Sprite
	{
		public static const LOOP_TIME:int = 30000;
		private var textField_:TextField = new TextField();
		private var waiter_:Timer = new Timer(1000);

		public function DictionarySpeedTest()
		{
			textField_.autoSize = TextFieldAutoSize.LEFT;
			textField_.defaultTextFormat = new TextFormat("_typewriter", 12);
			addChild(textField_);
			trace("ハッシュテーブルに使用するクラスを変更し、\n追加・取得・変更・削除の速度を確認します。");
			trace("試行回数:", LOOP_TIME);
			trace("KEY 型:", "String");
			trace("----");
			waiter_.addEventListener(TimerEvent.TIMER, waiterTimerHandler);
			waiter_.start();
		}

		private function trace(...rest):void
		{
			textField_.appendText(rest.join(" ").concat("\n"));
		}

		private var testCases_:Vector.<Class> = Vector.<Class>([
			ObjectAddCase,
			ObjectGetCase,
			ObjectChangeCase,
			ObjectDeleteCase,
			ArrayAddCase,
			ArrayGetCase,
			ArrayChangeCase,
			ArrayDeleteCase,
			DictionaryAddCase,
			DictionaryGetCase,
			DictionaryChangeCase,
			DictionaryDeleteCase
		]);
		private var repeatCount_:int = 0;
		private function waiterTimerHandler(event:TimerEvent):void
		{
			if (repeatCount_ < testCases_.length) {
				var testingCase:ITestCase = ITestCase(new testCases_[repeatCount_]());
				trace(testingCase.name, testingCase.exec(), "ms");
				
				// また 1 秒後
				waiter_.reset();
				waiter_.start();
				++repeatCount_;
			}
			// 終了
			else {
				trace("終了。");
				waiter_.stop();
				waiter_.removeEventListener(TimerEvent.TIMER, waiterTimerHandler);
				waiter_ = null;
			}
		}
	}
}

/**
 * テストを実行する時に簡単にできるようにするためのインターフェイスです.
 */
internal interface ITestCase
{
	function get name():String;
	function exec():int;
}

//		Object
// ------------------------------------------------------------------------------------------------

import flash.utils.getTimer;
/**
 * コンテナに Object を使用し、値を追加する速度を出力します.
 */
internal class ObjectAddCase implements ITestCase
{
	public function get name():String { return "ObjectAddCase         :"; }

	public function exec():int
	{
		var arr:Object = {};
		var i:int;
		var n:int = DictionarySpeedTest.LOOP_TIME;
		var startTime:int = getTimer();
		for (i = 0; i < n; ++i) {
			arr[i.toString().concat("_")] = i;
		}
		return getTimer() - startTime;
	}
}

import flash.utils.getTimer;
/**
 * コンテナに Object を使用し、値を取得する速度を出力します.
 */
internal class ObjectGetCase implements ITestCase
{
	public function get name():String { return "ObjectGetCase         :"; }

	public function exec():int
	{
		var arr:Object = {};
		var i:int;
		var n:int = DictionarySpeedTest.LOOP_TIME;
		for (i = 0; i < n; i += 7) {
			arr[i.toString().concat("_")] = i;
		}

		var startTime:int = getTimer();
		for (i = 0; i < n; ++i) {
			var hoge:int = arr[i.toString().concat("_")];
		}
		return getTimer() - startTime;
	}
}

import flash.utils.getTimer;
/**
 * コンテナに Object を使用し、値を変更する速度を出力します.
 */
internal class ObjectChangeCase implements ITestCase
{
	public function get name():String { return "ObjectChangeCase      :"; }

	public function exec():int
	{
		var arr:Object = {};
		var i:int;
		var n:int = DictionarySpeedTest.LOOP_TIME;
		for (i = 0; i < n; ++i) {
			arr[i.toString().concat("_")] = i;
		}

		var startTime:int = getTimer();
		for (i = 0; i < n; ++i) {
			arr[i.toString().concat("_")] = i << 1;
		}
		return getTimer() - startTime;
	}
}

import flash.utils.getTimer;
/**
 * コンテナに Object を使用し、値を削除する速度を出力します.
 */
internal class ObjectDeleteCase implements ITestCase
{
	public function get name():String { return "ObjectDeleteCase      :"; }

	public function exec():int
	{
		var arr:Object = {};
		var i:int;
		var n:int = DictionarySpeedTest.LOOP_TIME;
		for (i = 0; i < n; ++i) {
			arr[i.toString().concat("_")] = i;
		}

		var startTime:int = getTimer();
		for (i = 0; i < n; ++i) {
			delete arr[i.toString().concat("_")];
		}
		return getTimer() - startTime;
	}
}

//		Array
// ------------------------------------------------------------------------------------------------

import flash.utils.getTimer;
/**
 * コンテナに Array を使用し、値を代入する速度を出力します.
 */
internal class ArrayAddCase implements ITestCase
{
	public function get name():String { return "ArrayAddCase          :"; }

	public function exec():int
	{
		var arr:Array = [];
		var i:int;
		var n:int = DictionarySpeedTest.LOOP_TIME;
		var startTime:int = getTimer();
		for (i = 0; i < n; ++i) {
			arr[i.toString().concat("_")] = i;
		}
		return getTimer() - startTime;
	}
}

import flash.utils.getTimer;
/**
 * コンテナに Array を使用し、値を取得する速度を出力します.
 */
internal class ArrayGetCase implements ITestCase
{
	public function get name():String { return "ArrayGetCase          :"; }

	public function exec():int
	{
		var arr:Array = [];
		var i:int;
		var n:int = DictionarySpeedTest.LOOP_TIME;
		for (i = 0; i < n; i += 7) {
			arr[i.toString().concat("_")] = i;
		}

		var startTime:int = getTimer();
		for (i = 0; i < n; ++i) {
			var hoge:int = arr[i.toString().concat("_")];
		}
		return getTimer() - startTime;
	}
}

import flash.utils.getTimer;
/**
 * コンテナに Array を使用し、値を変更する速度を出力します.
 */
internal class ArrayChangeCase implements ITestCase
{
	public function get name():String { return "ArrayChangeCase       :"; }

	public function exec():int
	{
		var arr:Array = [];
		var i:int;
		var n:int = DictionarySpeedTest.LOOP_TIME;
		for (i = 0; i < n; ++i) {
			arr[i.toString().concat("_")] = i;
		}

		var startTime:int = getTimer();
		for (i = 0; i < n; ++i) {
			arr[i.toString().concat("_")] = i << 1;
		}
		return getTimer() - startTime;
	}
}

import flash.utils.getTimer;
/**
 * コンテナに Array を使用し、値を削除する速度を出力します.
 */
internal class ArrayDeleteCase implements ITestCase
{
	public function get name():String { return "ArrayDeleteCase       :"; }

	public function exec():int
	{
		var arr:Array = [];
		var i:int;
		var n:int = DictionarySpeedTest.LOOP_TIME;
		for (i = 0; i < n; ++i) {
			arr[i.toString().concat("_")] = i;
		}

		var startTime:int = getTimer();
		for (i = 0; i < n; ++i) {
			delete arr[i.toString().concat("_")];
		}
		return getTimer() - startTime;
	}
}

//		Dictionary
// ------------------------------------------------------------------------------------------------

import flash.utils.Dictionary;
import flash.utils.getTimer;
/**
 * コンテナに Dictionary を使用し、値を追加する速度を出力します.
 */
internal class DictionaryAddCase implements ITestCase
{
	public function get name():String { return "DictionaryAddCase     :"; }

	public function exec():int
	{
		var arr:Dictionary = new Dictionary();
		var i:int;
		var n:int = DictionarySpeedTest.LOOP_TIME;
		var startTime:int = getTimer();
		for (i = 0; i < n; ++i) {
			arr[i.toString().concat("_")] = i;
		}
		return getTimer() - startTime;
	}
}

import flash.utils.Dictionary;
import flash.utils.getTimer;
/**
 * コンテナに Dictionary を使用し、値を取得する速度を出力します.
 */
internal class DictionaryGetCase implements ITestCase
{
	public function get name():String { return "DictionaryGetCase     :"; }

	public function exec():int
	{
		var arr:Dictionary = new Dictionary();
		var i:int;
		var n:int = DictionarySpeedTest.LOOP_TIME;
		for (i = 0; i < n; i += 7) {
			arr[i.toString().concat("_")] = i;
		}

		var startTime:int = getTimer();
		for (i = 0; i < n; ++i) {
			var hoge:int = arr[i.toString().concat("_")];
		}
		return getTimer() - startTime;
	}
}

import flash.utils.Dictionary;
import flash.utils.getTimer;
/**
 * コンテナに Dictionary を使用し、値を変更する速度を出力します.
 */
internal class DictionaryChangeCase implements ITestCase
{
	public function get name():String { return "DictionaryChangeCase  :"; }

	public function exec():int
	{
		var arr:Dictionary = new Dictionary();
		var i:int;
		var n:int = DictionarySpeedTest.LOOP_TIME;
		for (i = 0; i < n; ++i) {
			arr[i.toString().concat("_")] = i;
		}

		var startTime:int = getTimer();
		for (i = 0; i < n; ++i) {
			arr[i.toString().concat("_")] = i << 1;
		}
		return getTimer() - startTime;
	}
}

import flash.utils.getTimer;
/**
 * コンテナに Dictionary を使用し、値を削除する速度を出力します.
 */
internal class DictionaryDeleteCase implements ITestCase
{
	public function get name():String { return "DictionaryDeleteCase  :"; }

	public function exec():int
	{
		var arr:Dictionary = new Dictionary();
		var i:int;
		var n:int = DictionarySpeedTest.LOOP_TIME;
		for (i = 0; i < n; ++i) {
			arr[i.toString().concat("_")] = i;
		}

		var startTime:int = getTimer();
		for (i = 0; i < n; ++i) {
			delete arr[i.toString().concat("_")];
		}
		return getTimer() - startTime;
	}
}
