/**
 * Copyright say0 ( http://wonderfl.net/user/say0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qn6O
 */

package {
    import flash.filters.BitmapFilter;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BitmapFilterType;
    import flash.filters.GradientGlowFilter;
    import flash.display.Sprite;

    public class GradientGlowFilterExample extends Sprite {
        private var bgColor:uint = 0xCCCCCC;
        private var size:uint    = 80;
        private var offset:uint  = 50;

        private var distance:Number  = 0;
        private var angleInDegrees:Number = 45;
        private var colors:Array     = [0xFFFFFF, 0xFF0000, 0xFFFF00, 0x00CCFF];
        private var alphas:Array     = [0, 1, 1, 1];
        private var ratios:Array     = [0, 63, 126, 255];
        private var blurX:Number     = 50;
        private var blurY:Number     = 50;
        private var strength:Number  = 2.5;
        private var quality:Number   = BitmapFilterQuality.HIGH;
        private var type:String      = BitmapFilterType.OUTER;
        private var knockout:Boolean = false;

        public function GradientGlowFilterExample() {
            draw();
            var filter:BitmapFilter = getBitmapFilter();
            var myFilters:Array = new Array();
            myFilters.push(filter);
            filters = myFilters;
        }

        private function getBitmapFilter():BitmapFilter {
            return new GradientGlowFilter(distance,
                                          angleInDegrees,
                                          colors,
                                          alphas,
                                          ratios,
                                          blurX,
                                          blurY,
                                          strength,
                                          quality,
                                          type,
                                          knockout);
        }

        private function draw():void {
            graphics.beginFill(bgColor);
            graphics.drawRect(offset, offset, size, size);
            graphics.endFill();
        }
    }
}
