/**
 * Copyright designquest ( http://wonderfl.net/user/designquest )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qmDI
 */

/******************************
*  My Alternativa3D Study Roadmap
*  by Michael Chau (michael@designquest.com.hk)
*  http://www.designquest.com.hk/_experiments/alternativa3d/
*
*  How to create polygonal? 
*  Try to create one piece polygonal to easier understand
*
*  forked from designquest's Create Polygonal Geometry 
*  Original code from : http://docs.alternativaplatform.com/display/TDEN/Building+geometry
*
*******************************/
package {
	import alternativ5.engine3d.controllers.CameraController;
	import alternativ5.engine3d.core.Camera3D;
	import alternativ5.engine3d.core.Object3D;
	import alternativ5.engine3d.core.Scene3D;
	import alternativ5.engine3d.display.View;
	import alternativ5.utils.FPS;
	
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;

	[SWF(backgroundColor="#000000", frameRate="100")]

	public class GeometryTutorial extends Sprite {

		private var scene:Scene3D;
		private var view:View;
		private var camera:Camera3D;
		private var cameraController:CameraController;
		private var square:Object3D;

		public function GeometryTutorial() {
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		public function init(e:Event):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			// Create scene
			scene = new Scene3D();
			scene.root = new Object3D();
			square = new Square(80);
			scene.root.addChild(square);
			
			// Add camera and view
			camera = new Camera3D();
			camera.x = 130;
			camera.y = -90;
			camera.z = 130;
			scene.root.addChild(camera);
			
			view = new View();
			addChild(view);
			view.camera = camera;

			// Add camera controller
			cameraController = new CameraController(stage);
			cameraController.camera = camera;
			cameraController.lookAt(square.coords);
			cameraController.setDefaultBindings();
			cameraController.checkCollisions = true;
			cameraController.collisionRadius = 20;
			cameraController.speed = 200;
			cameraController.controlsEnabled = true;
			
			// FPS counter init
			FPS.init(stage);

			stage.addEventListener(Event.RESIZE, onResize);
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			onResize(null);
		}

		private function onResize(e:Event):void {
			view.width = stage.stageWidth;
			view.height = stage.stageHeight;
		}
		
		private function onEnterFrame(e:Event):void {
                        // Rotation
                        square.rotationZ += 0.01;
			// User input processing
			cameraController.processInput();
			// Scene calculation
			scene.calculate();
		}
	}
}

import alternativ5.engine3d.core.Mesh;
import alternativ5.engine3d.materials.FillMaterial;
import alternativ5.engine3d.materials.WireMaterial;

class Square extends Mesh {
    public function Square(width:Number=50) {
        
        // create vertex
        createVertex(0,0,0,"v1");
        createVertex(width,0,0,"v2");
        createVertex(width,width,0,"v3");
        createVertex(0,width,0,"v4");
        
        // create Face
        var squareFace:Array = new Array();
        squareFace.push(createFace(["v1","v2","v3","v4"])); 
        
        // create Surface
        createSurface(squareFace, "square");
        
        // set Materials
        setMaterialToSurface(new WireMaterial(1, 0xFFFFFF), "square");
    }
}