/**
 * Copyright sekiryou ( http://wonderfl.net/user/sekiryou )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qm7m
 */

/**
* 和傘
* @author Masayuki Komatsu
* http://sekiryou.com/
* http://twitter.com/sekiryou_com
*/
/*
参考
外部画像をビットマップ化する
http://wonderfl.net/c/d8DH

wonderfl api を試す
http://wonderfl.net/c/xA9F

とりあえずWonderfl API を使ってみる
http://wonderfl.net/c/pgO6
*/
package {
    import flash.display.Bitmap;
    import com.adobe.serialization.json.JSON;
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.Graphics;
    import flash.display.Loader;
    import flash.display.Shape;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.filters.BevelFilter;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Matrix3D;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
    import flash.geom.Utils3D;
    import flash.geom.Vector3D;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.text.TextFormat;
    import flash.utils.getTimer;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
    
    public class Umbrella extends Sprite {
        private const KEY:String = loaderInfo.parameters.open_api_key;
        
        private const DEGREE_TO_RADIAN:Number = Math.PI / 180;
        private var projection:PerspectiveProjection;
        private var projectionMatrix3D:Matrix3D;
        private var mtx3D:Matrix3D = new Matrix3D();
        private var projectedVerts:Vector.<Number> = new Vector.<Number>();
        private var vertexList:Vector.<Number> = new Vector.<Number>();
        private var indexList:Vector.<int> = new Vector.<int>();
        private var uvtList:Vector.<Number> = new Vector.<Number>();
        private var polygonList:Vector.<Polygon> = new Vector.<Polygon>();
        private var cloneList:Vector.<Polygon> = new Vector.<Polygon>();
        
        private var screen:Sprite = new Sprite();
        private var texture:BitmapData;
        private var defaultBMD:BitmapData = new BitmapData(150, 150, false, 0xaa5555);
        public function Umbrella() {
            //capture
            var capture:Bitmap = new Bitmap(new BitmapData(465, 465, false, 0x000000));
            addChild(capture);
            
            init();
        }
        private function init():void {
            projection = new PerspectiveProjection();
            projection.fieldOfView = 50;
            projectionMatrix3D = projection.toMatrix3D();
            screen = new Sprite();
            addChild(screen);
            screen.x = 233;
            screen.y = 233;
            
            texture = new BitmapData(800, 800, false, 0x111111);
            lumberTexture();
            
            var tmpBMD:BitmapData = new BitmapData(150, 40, false, 0x000000);
            tmpBMD.setVector(tmpBMD.rect, defaultData);
            var defaultBMD:BitmapData = new BitmapData(150, 150, false, 0xaa5555);
            defaultBMD.draw(tmpBMD, new Matrix(1, 0, 0, 1, 0, 60));
            texture.draw(textureProcess(defaultBMD));
            //
            var obmv:Function = function(obj:Object):void {
                var len:int = obj.vertices.length;
                for (var i:int = 0; i < len; i++ ) {
                    obj.vertices[i] = mtx3D.transformVector(obj.vertices[i]);
                }
            }
            
            mtx3D.identity();
            mtx3D.appendTranslation(0, 0, 0);
            mtx3D.appendRotation(-45, Vector3D.X_AXIS);
            bugfix(mtx3D);
            
            var tmp0:Part00 = new Part00();
            obmv(tmp0);
            extract(tmp0);
            var tmp1:Part01 = new Part01();
            obmv(tmp1);
            extract(tmp1);
            var tmp2:Part02 = new Part02();
            obmv(tmp2);
            extract(tmp2);
            var tmp3:Part03 = new Part03();
            extract(tmp3);
            
            //
            var cap:TextField = new TextField();
            var tf:TextFormat = new TextFormat();
            tf.align = "left";
            cap.defaultTextFormat = tf;
            cap.text = "wonderfl user name";
            cap.width = 108;
            cap.height = 18;
            cap.x = 132;
            cap.y = 440;
            cap.textColor = 0xFFFFFF;
            cap.type = TextFieldType.DYNAMIC;
            addChild(cap);
            //
            var search:TextField = new TextField();
            search.text = "";
            search.width = 90;
            search.height = 18;
            search.x = 240;
            search.y = 440;
            search.border = true;
            search.textColor = 0xFFFFFF;
            search.borderColor = 0x996633;
            search.background = true;
            search.backgroundColor = 0x664422;
            search.type = TextFieldType.INPUT;
            search.addEventListener(KeyboardEvent.KEY_UP, onKeyUpHandler);
            addChild(search);
            //
            var sample:TextField = new TextField();
            tf.align = "center";
            sample.defaultTextFormat = tf;
            sample.text = "sample";
            sample.width = 60;
            sample.height = 18;
            sample.x = 395;
            sample.y = 440;
            sample.border = true;
            sample.textColor = 0xFFFFFF;
            sample.borderColor = 0x996633;
            sample.background = true;
            sample.selectable = false;
            sample.backgroundColor = 0x664422;
            sample.type = TextFieldType.DYNAMIC;
            sample.addEventListener(MouseEvent.CLICK, clickHandler);
            addChild(sample);
            
            addEventListener(Event.ENTER_FRAME, update);
        }
        private var sampleUser:Vector.<String> = Vector.<String>([ "sekiryou", "test"]);
        private function clickHandler(e:MouseEvent):void {
            var len:int = sampleUser.length;
            userName = sampleUser[int(Math.random() * len)];
            iconLoader();
        }
        private var userName:String  = "";
        private function onKeyUpHandler(e:KeyboardEvent):void {
            if (e.keyCode == 13) {
                userName = e.currentTarget.text;
                iconLoader();
            }
        }
        private function iconLoader():void {
            var loader:URLLoader = new URLLoader();
            loader.addEventListener(Event.COMPLETE, onComplete);
            loader.load(new URLRequest("http://api.wonderfl.net/user/" + userName + "?api_key=" + KEY));
        }
        private function onComplete(e:Event):void {
            var user:Object = JSON.decode(e.target.data).user;
            if (user != null) {
                var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.INIT, imgComplete);
                loader.load(new URLRequest(user.icon + "?" + getTimer()), new LoaderContext(false));
            } else {
                var tmpBMD:BitmapData = new BitmapData(150, 40, false, 0x000000);
                tmpBMD.setVector(tmpBMD.rect, defaultData);
                defaultBMD.draw(tmpBMD, new Matrix(1, 0, 0, 1, 0, 60));
                texture.draw(textureProcess(defaultBMD));
            }
        }
        private function imgComplete(e:Event):void {
            var loaderB:Loader = new Loader();
            loaderB.contentLoaderInfo.addEventListener(Event.INIT, trans);
            loaderB.loadBytes(e.currentTarget.loader.contentLoaderInfo.bytes);
        }
        private function trans(e:Event):void {
            var loader:Loader = e.currentTarget.loader;
            var data:BitmapData = new BitmapData(loader.contentLoaderInfo.width, loader.contentLoaderInfo.height, false, 0x000000);
            //var data:BitmapData = new BitmapData(100, 100, false, 0x000000);
            data.draw(loader);
            texture.draw(textureProcess(data));
        }
        private function textureProcess(befor:BitmapData):BitmapData {
            var s:Number = 400;
            var h:Number = s * 0.5;
            var bandWidthRatio:Number = 20 / s;
            var after:BitmapData = new BitmapData(s, s, false, 0x0);
            after.draw(befor, new Matrix(s / befor.width * (1- bandWidthRatio), 0, 0, s / befor.height * (1- bandWidthRatio), befor.width * (bandWidthRatio * 0.5), befor.height * (bandWidthRatio * 0.5)));
            //
            var tmp:Shape = new Shape();
            var g:Graphics = tmp.graphics;
            g.lineStyle(s * (bandWidthRatio), 0x222233);
            tmp.graphics.drawCircle(h, h, h - s * (bandWidthRatio * 0.5));
            after.draw(tmp);
            //
            tmp = new Shape();
            g = tmp.graphics;
            var div:int = Part00.DIV
            g.lineStyle(2, 0x333333);
            for (var i:int = 0; i < div; i ++) {
                var angle0:Number = 360 / div * i  * DEGREE_TO_RADIAN;
                g.moveTo(h, h);
                g.lineTo(Math.cos(angle0) * h + h, Math.sin(angle0) * h + h);
            }
            tmp.filters = [new BevelFilter(5, 45, 0x333333, 0.6, 0x000000, 0.6, 2, 2, 5)];
            after.draw(tmp);
            
            return after;
        }
        
        private function lumberTexture():void {
            //
            var ctf:ColorTransform = new ColorTransform();
            var surface:BitmapData = new BitmapData(400, 400, false, 0x000000);
            var randomSeed:Number = Math.floor(Math.random() * 0x0000FF);
            surface.perlinNoise(200, 4, 4, randomSeed, false, true, 0 | 0 | 0 | 0, true);
            
            surface.applyFilter(surface, surface.rect, new Point(0, 0), new BlurFilter(100, 1, 2));
            
            var bc:int = 0x666666;
            ctf.redOffset = ((bc >> 16) & 0xFF);
            ctf.greenOffset = ((bc >> 8) & 0xFF);
            ctf.blueOffset = (bc & 0xFF);
            surface.draw(surface, null, ctf, "normal", null, false);
            
            ctf.redOffset = -((bc >> 16) & 0xFF);
            ctf.greenOffset = -((bc >> 8) & 0xFF);
            ctf.blueOffset = -(bc & 0xFF);
            surface.draw(surface, null, ctf, "normal", null, false);
            
            bc = 0x114477;
            ctf.redOffset = -((bc >> 16) & 0xFF);
            ctf.greenOffset = -((bc >> 8) & 0xFF);
            ctf.blueOffset = -(bc & 0xFF);
            surface.draw(surface, null, ctf, "screen", null, false);
            
            surface.applyFilter(surface, surface.rect, new Point(0, 0), new BlurFilter(16, 16, 2));
            //lighting
            var width:Number = 400;
            var tmpShape:Shape = new Shape();
            var matr:Matrix = new Matrix();
            matr.createGradientBox(width, width, 0, 0, 0);
            var spreadMethod:String = SpreadMethod.PAD;
            tmpShape.graphics.beginGradientFill(GradientType.RADIAL, [0xCC6600, 0xCC6600, 0x000000], [0.2, 0.2, 1], [0x00, 0x00, 0xFF], matr);
            tmpShape.graphics.drawRect(0, 0, width, width);
            
            surface.draw(tmpShape, null, null, "normal");
            
            texture.draw(surface, new Matrix(0.2, 0, 0, 0.2, 400, 400));
        }
        
        private function extract(obj:Object):void {
            var i:int;
            var len:int;
            //
            len = obj.indices.length;
            var vl:int = vertexList.length / 3;
            for (i = 0; i < len; i++) {
                indexList.push(obj.indices[i] + vl);
            }
            //
            len = obj.vertices.length;
            for (i = 0; i < len; i++) {
                vertexList.push(obj.vertices[i].x);
                vertexList.push(obj.vertices[i].y);
                vertexList.push(obj.vertices[i].z);
            }
            //
            len = obj.uvts.length;
            for (i = 0; i < len; i++) {
                uvtList.push(obj.uvts[i]);
            }
            //
            len = indexList.length;
            for (i = 0; i < len; i += 3) {
                var tmp:Polygon = new Polygon(
                    indexList[i], indexList[i + 1 >> 0], indexList[i + 2 >> 0],
                    uvtList[i * 3 + 0 >> 0], uvtList[i * 3 + 1 >> 0],
                    uvtList[i * 3 + 3 >> 0], uvtList[i * 3 + 4 >> 0],
                    uvtList[i * 3 + 6 >> 0], uvtList[i * 3 + 7 >> 0]
                );
                polygonList.push(tmp);
            }
        }
        private var tmpVertices:Vector.<Number> = new Vector.<Number>();
        private var sortedVertices:Vector.<Number> = new Vector.<Number>();
        private var tmpIndices:Vector.<int> = new Vector.<int>();
        private var tmpUvts:Vector.<Number> = new Vector.<Number>();
        private var offsetX:Number = 0;
        private var offsetY:Number = -30;
        private var offsetZ:Number = 360;
        private var cnt:Number = 0;
        private function update(e:Event = null):void {
            var i:int
            var len:int;
            
            var mx:Number = (mouseX / 465 - 0.5) * 4.0;
            cnt += mx;
            //
            mtx3D.identity();
            mtx3D.appendRotation(cnt, Vector3D.Y_AXIS);
            mtx3D.appendTranslation(offsetX, offsetY, offsetZ);
            bugfix(mtx3D);
            mtx3D.transformVectors(vertexList, tmpVertices);
            //
            len = polygonList.length;
            for (i = 0; i < len; i++) {
                //polygonList[i].c = (tmpVertices[polygonList[i].i0 * 3 + 2 >> 0] + tmpVertices[polygonList[i].i1 * 3 + 2 >> 0] + tmpVertices[polygonList[i].i2 * 3 + 2 >> 0]) * .33333333333;
                
                /*
                var tmpX:Number = (tmpVertices[polygonList[i].i0 * 3 + 0 >> 0] + tmpVertices[polygonList[i].i1 * 3 + 0 >> 0] + tmpVertices[polygonList[i].i2 * 3 + 0 >> 0]) * .33333333333;
                var tmpY:Number = (tmpVertices[polygonList[i].i0 * 3 + 1 >> 0] + tmpVertices[polygonList[i].i1 * 3 + 1 >> 0] + tmpVertices[polygonList[i].i2 * 3 + 1 >> 0]) * .33333333333;
                var tmpZ:Number = (tmpVertices[polygonList[i].i0 * 3 + 2 >> 0] + tmpVertices[polygonList[i].i1 * 3 + 2 >> 0] + tmpVertices[polygonList[i].i2 * 3 + 2 >> 0]) * .33333333333;
                polygonList[i].c = tmpX * tmpX + tmpY * tmpY + tmpZ * tmpZ;    //polygonList[i].c = Math.sqrt(tmpX * tmpX + tmpY * tmpY + tmpZ * tmpZ);
                */
                
                var i0x:Number = tmpVertices[polygonList[i].i0 * 3 + 0 >> 0];
                var i0y:Number = tmpVertices[polygonList[i].i0 * 3 + 1 >> 0];
                var i0z:Number = tmpVertices[polygonList[i].i0 * 3 + 2 >> 0];
                var i1x:Number = tmpVertices[polygonList[i].i1 * 3 + 0 >> 0];
                var i1y:Number = tmpVertices[polygonList[i].i1 * 3 + 1 >> 0];
                var i1z:Number = tmpVertices[polygonList[i].i1 * 3 + 2 >> 0];
                var i2x:Number = tmpVertices[polygonList[i].i2 * 3 + 0 >> 0];
                var i2y:Number = tmpVertices[polygonList[i].i2 * 3 + 1 >> 0];
                var i2z:Number = tmpVertices[polygonList[i].i2 * 3 + 2 >> 0];
                
                polygonList[i].c = i0x * i0x + i0y * i0y + i0z * i0z;
                var tmp:Number = i1x * i1x + i1y * i1y + i1z * i1z;
                if (polygonList[i].c < tmp) {
                    polygonList[i].c = tmp;
                }
                tmp = i2x * i2x + i2y * i2y + i2z * i2z;
                if (polygonList[i].c < tmp) {
                    polygonList[i].c = tmp;
                }
                
            }
            //
            cloneList = polygonList.concat();
            cloneList.sort(
                function(p1:Polygon, p2:Polygon):Number {
                    if (p1.c > p2.c) {
                        return -1;
                    } else if (p1.c < p2.c) {
                        return 1;
                    } else {
                        return 0;
                    }
                }
            );
            //
            tmpIndices.length = 0;
            tmpUvts.length = 0;
            sortedVertices.length = 0;
            len = cloneList.length;
            for (i = 0; i < len; i++) {
                //index
                tmpIndices.push(
                    cloneList[i].i0,
                    cloneList[i].i1,
                    cloneList[i].i2
                );
                //uvt
                tmpUvts.push(
                    cloneList[i].u0,
                    cloneList[i].v0,
                    null,
                    cloneList[i].u1,
                    cloneList[i].v1,
                    null,
                    cloneList[i].u2,
                    cloneList[i].v2,
                    null
                );
                //vertex//*
                sortedVertices.push(
                    tmpVertices[cloneList[i].i0 * 3 + 0 >> 0],
                    tmpVertices[cloneList[i].i0 * 3 + 1 >> 0],
                    tmpVertices[cloneList[i].i0 * 3 + 2 >> 0],
                    tmpVertices[cloneList[i].i1 * 3 + 0 >> 0],
                    tmpVertices[cloneList[i].i1 * 3 + 1 >> 0],
                    tmpVertices[cloneList[i].i1 * 3 + 2 >> 0],
                    tmpVertices[cloneList[i].i2 * 3 + 0 >> 0],
                    tmpVertices[cloneList[i].i2 * 3 + 1 >> 0],
                    tmpVertices[cloneList[i].i2 * 3 + 2 >> 0]
                );
            }
            //
            mtx3D.identity();
            mtx3D.append(projectionMatrix3D);
            bugfix(mtx3D);
            //Utils3D.projectVectors(mtx3D, tmpVertices, projectedVerts, tmpUvts);        //*
            Utils3D.projectVectors(mtx3D, sortedVertices, projectedVerts, tmpUvts);
            //
            var g:Graphics = screen.graphics;
            g.clear();
            g.beginBitmapFill(texture);
            g.drawTriangles(projectedVerts, null, tmpUvts, "negative");
            //g.drawTriangles(projectedVerts, tmpIndices, tmpUvts);            //*
            g.endFill();
        }
        private function bugfix(matrix:Matrix3D):void {
            var m1:Matrix3D = new Matrix3D(Vector.<Number>([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0]));
            var m2:Matrix3D = new Matrix3D(Vector.<Number>([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0]));
            m1.append( m2 );
            if (m1.rawData[15] == 20) {
                var rawData:Vector.<Number> = matrix.rawData;
                rawData[15] /= 20;
                matrix.rawData = rawData;
            }
        }
        private var defaultData:Vector.<uint> = Vector.<uint>([
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5055, 0xffaa0924, 0xffaa0107, 0xffaa0414, 0xffaa0414, 0xffaa1920, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa1b22,
            0xffaa0102, 0xffaa0924, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff121212, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa1b22, 0xffaa0100, 0xffaa0102, 0xffaa0308, 0xffaa0d04, 0xffaa0100, 0xffaa0000, 0xffaa0906, 0xffaa5555, 0xffaa5555, 0xffaa0308,
            0xffaa0102, 0xffaa0308, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa0700, 0xffaa0100, 0xffaa0e0f, 0xffaa4646, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa4646, 0xffaa131f, 0xffaa5555, 0xffaa5555, 0xffaa040d,
            0xffaa0102, 0xffaa0102, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa3e4d, 0xffaa0102, 0xffaa0100, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa000f,
            0xffaa0d04, 0xffaa0107, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff040404, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa0415, 0xffaa0102, 0xffaa0f13, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa0308,
            0xffaa0001, 0xffaa000f, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff040404, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa0414, 0xffaa0102, 0xffa1090d, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa0102,
            0xffaa0700, 0xffaa040d, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff825555, 0xff825555, 0xff755555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff8d5555, 0xff8b5555, 0xff825555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xff9a5555, 0xff855555, 0xff7d5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff7d5555,
            0xff855555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff7d5555, 0xff855555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff040404, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff9a5555, 0xff885555, 0xff9d5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff7d5555, 0xff825555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffa25555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa020a, 0xffaa0d0d, 0xffa1090d, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa0400,
            0xffaa050c, 0xffaa020a, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff121212, 0xff000000, 0xff0d0d0d, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff040404, 0xff000000, 0xff925555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xff0d0d0d, 0xff000000, 0xff000000, 0xff9a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff635555, 0xff040404, 0xff000000, 0xff040404, 0xff080808,
            0xff000000, 0xff040404, 0xff040404, 0xff222222, 0xff7a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff121212, 0xff000000, 0xff313131, 0xffaa5555,
            0xffaa5555, 0xff975555, 0xff464646, 0xff0d0d0d, 0xff000000, 0xff000000, 0xff040404, 0xff222222, 0xff7a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff5e5555, 0xff0d0d0d, 0xff040404, 0xff040404, 0xff000000, 0xff000000, 0xff000000, 0xff080808, 0xff222222, 0xff000000, 0xff080808, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff464646, 0xff040404, 0xff000000, 0xff000000, 0xff040404, 0xff000000, 0xff040404, 0xff000000, 0xff755555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xffa15555, 0xffaa5555, 0xff222222, 0xff040404, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa070d, 0xffaa0001, 0xffaa0001, 0xffaa070d, 0xffaa0103, 0xffaa0103, 0xffaa0f13, 0xff980d17, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa0400,
            0xffaa070d, 0xffaa020a, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff4d4d4d, 0xff040404, 0xff000000, 0xff6e5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff8b5555, 0xff040404, 0xff000000, 0xff040404, 0xff373737, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xff000000, 0xff000000, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff121212, 0xff000000, 0xff040404, 0xff040404, 0xff080808, 0xff000000,
            0xff080808, 0xff000000, 0xff040404, 0xff000000, 0xff040404, 0xff313131, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff080808, 0xff925555,
            0xff121212, 0xff000000, 0xff000000, 0xff000000, 0xff0d0d0d, 0xff040404, 0xff000000, 0xff000000, 0xff080808, 0xff373737, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xff121212, 0xff040404, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff040404, 0xff000000, 0xff000000, 0xff000000, 0xff040404, 0xff040404, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff655555, 0xff080808, 0xff000000, 0xff040404, 0xff040404, 0xff040404, 0xff000000, 0xff040404, 0xff000000, 0xff040404, 0xff000000,
            0xff313131, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff313131, 0xff000000, 0xff040404, 0xff000000, 0xff0d0d0d, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffa5060b, 0xffaa0400, 0xffaa0001, 0xffa81417, 0xffaa020a, 0xffaa020a, 0xffa81417, 0xff8c0f14, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa0103,
            0xffa5060b, 0xffa5060b, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff925555, 0xff000000, 0xff040404, 0xff2b2b2b,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff313131, 0xff040404, 0xff040404, 0xff000000, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff885555, 0xff040404, 0xff000000, 0xff222222, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff121212, 0xff040404, 0xff000000, 0xff000000, 0xff605555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff414141, 0xff000000, 0xff000000, 0xff040404, 0xff5e5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff080808, 0xff040404, 0xff000000, 0xff000000,
            0xff080808, 0xff000000, 0xff313131, 0xff6e5555, 0xff7d5555, 0xff605555, 0xff121212, 0xff000000, 0xff000000, 0xff000000, 0xff975555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff222222, 0xff000000, 0xff040404, 0xff0d0d0d, 0xff313131, 0xff805555, 0xffaa5555, 0xffaa5555, 0xff805555, 0xff605555, 0xff0d0d0d, 0xff000000, 0xff000000, 0xff040404, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff0d0d0d, 0xff414141, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff414141, 0xff000000, 0xff000000,
            0xff040404, 0xff805555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff040404, 0xff000000, 0xff121212, 0xff875555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffa1090d, 0xff940507, 0xff980d17, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffa20300,
            0xffa1090d, 0xff940507, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff040404, 0xff040404,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff080808, 0xff000000, 0xff000000, 0xff000000, 0xff040404, 0xff755555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff4d4d4d, 0xff040404, 0xff000000, 0xff5e5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6c5555, 0xff000000, 0xff000000, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xff040404, 0xff000000, 0xff080808, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff000000, 0xff040404,
            0xff313131, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff313131, 0xff000000, 0xff080808, 0xff222222, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff905555,
            0xff000000, 0xff040404, 0xff000000, 0xffa15555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff080808, 0xff000000, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff2b2b2b, 0xff000000, 0xff040404, 0xff635555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff565555, 0xff000000,
            0xff000000, 0xff2b2b2b, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff0d0d0d, 0xff000000, 0xff373737, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff940507, 0xff980d17, 0xff7b0b17, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff940507,
            0xff940507, 0xff940507, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff222222, 0xff000000, 0xff000000,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff925555, 0xff000000, 0xff000000, 0xff3f3f3f, 0xff000000, 0xff000000, 0xff222222, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff1a1a1a, 0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff1a1a1a, 0xff080808, 0xff000000, 0xff735555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff222222, 0xff080808, 0xff040404, 0xff735555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff080808, 0xff000000, 0xff805555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff0d0d0d, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff313131,
            0xff040404, 0xff000000, 0xff635555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff080808, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff222222, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000,
            0xff040404, 0xff080808, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff870806, 0xff8c0f14, 0xff7b0b17, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff940507,
            0xff870806, 0xff8c0f14, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff605555, 0xff000000, 0xff040404,
            0xff6e5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff313131, 0xff000000, 0xff080808, 0xffaa5555, 0xff1a1a1a, 0xff040404, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff040404, 0xff000000, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff040404, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff755555, 0xff000000, 0xff000000, 0xff414141, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff040404, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000,
            0xff000000, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff040404, 0xff040404, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff7d5555, 0xff040404, 0xff0d0d0d, 0xff313131, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000,
            0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff0d0d0d, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff870806, 0xff7b090b, 0xff7b0b17, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff870806,
            0xff7b090b, 0xff7b090b, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff9a5555, 0xff000000, 0xff000000,
            0xff373737, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff080808, 0xff2b2b2b, 0xffaa5555, 0xff605555, 0xff000000, 0xff080808, 0xff5e5555, 0xffaa5555, 0xffaa5555, 0xffa15555,
            0xff000000, 0xff000000, 0xff313131, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff040404, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff9a5555, 0xff080808, 0xff040404, 0xff1a1a1a, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff040404, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff040404, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404,
            0xff040404, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff080808, 0xff000000, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff805555, 0xff040404, 0xff000000, 0xff0d0d0d, 0xff000000, 0xff080808, 0xff000000, 0xff040404, 0xff000000, 0xff040404, 0xff000000, 0xff040404, 0xff040404,
            0xff000000, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff870806, 0xff870806, 0xff7b090b, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff870806,
            0xff7b090b, 0xff7b090b, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000,
            0xff000000, 0xffaa5555, 0xffaa5555, 0xff905555, 0xff000000, 0xff000000, 0xff905555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff040404, 0xff0d0d0d, 0xffaa5555, 0xffaa5555, 0xff735555,
            0xff000000, 0xff000000, 0xff855555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff080808, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff040404, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff040404, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000,
            0xff040404, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff805555, 0xff000000, 0xff040404, 0xff000000, 0xff040404, 0xff000000, 0xff040404, 0xff000000, 0xff000000, 0xff040404, 0xff000000, 0xff040404, 0xff000000,
            0xff000000, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff5e1013, 0xff6a0e07, 0xff5e1013, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff640f0e,
            0xff6a0e07, 0xff640f0e, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff222222, 0xff000000,
            0xff000000, 0xffaa5555, 0xffaa5555, 0xff313131, 0xff000000, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff2b2b2b, 0xff040404, 0xff000000, 0xffaa5555, 0xffaa5555, 0xff313131,
            0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff080808, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404,
            0xff040404, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff040404, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff825555, 0xff000000, 0xff040404, 0xff2b2b2b, 0xff3f3f3f, 0xff464646, 0xff3f3f3f, 0xff3f3f3f, 0xff3f3f3f, 0xff464646, 0xff414141, 0xff414141, 0xff373737,
            0xff3f3f3f, 0xff414141, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff5e1013, 0xff6a0e07, 0xff551013, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff640f0e,
            0xff6a0e07, 0xff640f0e, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff665555, 0xff080808,
            0xff040404, 0xff6e5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff373737, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff885555, 0xff000000, 0xff040404, 0xff4d4d4d, 0xffaa5555, 0xff080808,
            0xff000000, 0xff1a1a1a, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff080808, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff855555, 0xff040404, 0xff080808, 0xff2b2b2b, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff040404, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404,
            0xff080808, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff040404, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff7a5555, 0xff040404, 0xff040404, 0xff4d4d4d, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff551013, 0xff640f0e, 0xff551013, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff5e1013,
            0xff640f0e, 0xff55110a, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404,
            0xff040404, 0xff2b2b2b, 0xff925555, 0xff040404, 0xff000000, 0xffa65555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff080808, 0xffa65555, 0xff000000,
            0xff040404, 0xff4d4d4d, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff1a1a1a, 0xff000000, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff414141, 0xff080808, 0xff000000, 0xff565555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff040404, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff222222,
            0xff000000, 0xff0d0d0d, 0xff735555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff0d0d0d, 0xff080808, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff040404, 0xff121212, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff551013, 0xff55110a, 0xff47130b, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff551013,
            0xff55110a, 0xff55110a, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404,
            0xff000000, 0xff040404, 0xff313131, 0xff000000, 0xff080808, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff4d4d4d, 0xff000000, 0xff000000, 0xff2b2b2b, 0xff000000,
            0xff040404, 0xff8d5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff5e5555, 0xff040404, 0xff000000, 0xff313131, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff0d0d0d, 0xff000000, 0xff000000, 0xffa15555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff040404, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff635555,
            0xff040404, 0xff000000, 0xff1a1a1a, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff040404, 0xff825555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff551013, 0xff47130b, 0xff461115, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff551013,
            0xff47130b, 0xff47130b, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff2b2b2b,
            0xff000000, 0xff040404, 0xff000000, 0xff000000, 0xff4d4d4d, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff040404, 0xff000000, 0xff040404,
            0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff080808, 0xff040404, 0xff000000, 0xff665555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff1a1a1a, 0xff000000, 0xff080808, 0xff222222, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff040404, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff000000, 0xff040404, 0xff000000, 0xff3f3f3f, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff0d0d0d, 0xff000000, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6e5555, 0xff040404, 0xff000000, 0xff000000, 0xff755555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff461115, 0xff47130b, 0xff371614, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff461115,
            0xff461115, 0xff3b140c, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff755555,
            0xff000000, 0xff040404, 0xff000000, 0xff040404, 0xffa65555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff121212, 0xff000000, 0xff040404, 0xff040404,
            0xff222222, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff735555, 0xff000000, 0xff000000, 0xff040404, 0xff121212, 0xff4d4d4d, 0xff805555,
            0xff755555, 0xff2b2b2b, 0xff080808, 0xff000000, 0xff080808, 0xff000000, 0xffa65555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff6e5555, 0xff000000, 0xff040404, 0xff000000, 0xff000000, 0xff313131, 0xff6c5555, 0xff565555, 0xff414141, 0xff2b2b2b, 0xff0d0d0d, 0xff000000, 0xff040404, 0xff080808, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff373737, 0xff000000, 0xff040404, 0xff000000, 0xff040404, 0xff313131, 0xff565555, 0xff7a5555, 0xff825555, 0xff6e5555, 0xff414141,
            0xff313131, 0xff735555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff47130b, 0xff3b140c, 0xff371614, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff461115,
            0xff3b140c, 0xff371614, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff000000, 0xff000000, 0xff000000, 0xff121212, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff5e5555, 0xff040404, 0xff040404, 0xff000000,
            0xff5e5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff805555, 0xff000000, 0xff040404, 0xff000000, 0xff000000, 0xff040404,
            0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff0d0d0d, 0xffa15555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff040404, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff040404, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xff605555, 0xff000000, 0xff040404, 0xff040404, 0xff000000, 0xff000000, 0xff040404, 0xff000000, 0xff040404, 0xff000000, 0xff000000, 0xff040404, 0xff000000, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff414141, 0xff000000, 0xff080808, 0xff000000, 0xff000000, 0xff040404, 0xff040404, 0xff000000, 0xff000000, 0xff000000,
            0xff080808, 0xff805555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff040404, 0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff3b140c, 0xff3b140c, 0xff371614, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff461115,
            0xff371614, 0xff371614, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff000000, 0xff000000, 0xff000000, 0xff635555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff000000,
            0xff9d5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff755555, 0xff3f3f3f, 0xff000000, 0xff000000,
            0xff040404, 0xff121212, 0xff414141, 0xff925555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff040404, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff5e5555, 0xff222222, 0xff000000, 0xff040404, 0xff000000, 0xff000000, 0xff121212, 0xff3f3f3f, 0xff565555, 0xff7d5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff645555, 0xff2b2b2b, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff313131,
            0xff414141, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff000000, 0xff000000, 0xff000000, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff231a1b, 0xff231a1b, 0xff231a1b, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff231a1b,
            0xff231a1b, 0xff231a1b, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff9a5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff925555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff975555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff9a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff715555, 0xff605555, 0xff695555, 0xff635555, 0xff695555, 0xff605555, 0xffaa5555, 0xffaa5555, 0xff9a5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff9a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff9a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff9a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff635555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff695555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff665555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff675555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff605555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff655555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6e5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff6e5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff645555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff665555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff565555,
            0xff6e5555, 0xff6a5555, 0xff635555, 0xff755555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff735555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff735555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff715555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6c5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff665555, 0xff655555, 0xff695555, 0xff675555,
            0xff635555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff675555, 0xff665555, 0xff655555, 0xff565555, 0xff855555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff605555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xff6e5555, 0xff5e5555, 0xff715555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff735555, 0xff645555, 0xff655555,
            0xff645555, 0xff905555, 0xffaa5555, 0xffaa5555, 0xff6a5555, 0xff805555, 0xff635555, 0xff635555, 0xff6a5555, 0xff9d5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff9a5555, 0xff605555, 0xff635555, 0xff665555, 0xff885555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff7a5555, 0xff755555, 0xff635555,
            0xff695555, 0xff7a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff655555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff735555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff7a5555,
            0xff7a5555, 0xff645555, 0xff655555, 0xff645555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff8b5555, 0xff645555, 0xff6a5555, 0xff605555, 0xff8b5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6a5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff8d5555, 0xff695555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff675555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff645555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff605555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff665555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff675555, 0xffa65555, 0xffaa5555, 0xffaa5555, 0xff9d5555,
            0xff635555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff645555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff975555, 0xff695555, 0xffaa5555, 0xffaa5555, 0xff8b5555, 0xff8d5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff675555, 0xff805555, 0xffaa5555, 0xffaa5555, 0xffa15555, 0xff6a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6e5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6c5555, 0xff885555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff645555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xff7d5555, 0xff9d5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff635555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff675555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff635555,
            0xff9d5555, 0xffaa5555, 0xffaa5555, 0xff855555, 0xff885555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6c5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff645555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff675555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff715555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff635555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff645555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff655555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff655555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff8d5555, 0xff665555, 0xffaa5555, 0xffaa5555, 0xff905555, 0xff805555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff655555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff655555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff8b5555, 0xff805555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff665555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xff885555, 0xff855555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6e5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6e5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffa15555, 0xff6a5555, 0xffaa5555, 0xffaa5555, 0xff905555, 0xff825555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff605555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff645555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff635555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff635555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff635555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff645555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff645555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff635555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff635555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff675555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff885555, 0xff605555, 0xff8b5555, 0xff885555, 0xff695555, 0xff715555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6e5555, 0xff6a5555, 0xff605555,
            0xff695555, 0xff975555, 0xffaa5555, 0xffaa5555, 0xff665555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff885555, 0xff885555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff5e5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff645555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xff925555, 0xff925555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff635555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff635555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff715555, 0xffaa5555, 0xffaa5555, 0xff8b5555, 0xff665555, 0xff6e5555, 0xff5e5555, 0xff6c5555, 0xff655555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff665555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff715555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff5e5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff665555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff605555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff675555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff655555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff675555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff925555, 0xff735555, 0xffaa5555, 0xffaa5555, 0xff655555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff655555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff9d5555, 0xff805555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6e5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff645555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xff925555, 0xff8b5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6c5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff655555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff635555, 0xffaa5555, 0xffaa5555, 0xff975555, 0xff805555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff655555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff7a5555, 0xff715555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xffa15555, 0xffaa5555, 0xffaa5555, 0xff735555, 0xff635555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff6a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff655555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xff855555, 0xffaa5555, 0xffaa5555, 0xff925555,
            0xff665555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff675555, 0xff9a5555, 0xffaa5555, 0xffaa5555, 0xff925555, 0xff605555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xff8d5555, 0xff645555, 0xffaa5555, 0xffaa5555, 0xff675555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xff9a5555, 0xffaa5555, 0xffaa5555, 0xff715555, 0xff805555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6a5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xff8d5555, 0xff8b5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff645555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff675555, 0xff975555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6e5555,
            0xff675555, 0xff675555, 0xff655555, 0xff7d5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff665555, 0xff675555, 0xff735555, 0xff925555, 0xff695555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xff6a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6a5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff755555, 0xff665555, 0xff655555, 0xff695555,
            0xff805555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff655555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff655555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff665555, 0xff655555, 0xff6a5555, 0xff7d5555, 0xff675555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff695555, 0xff655555, 0xff675555,
            0xff715555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff665555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff635555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff715555, 0xff675555, 0xff655555, 0xff8d5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff665555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xff905555, 0xff8b5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff655555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff635555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff665555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff675555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xff6c5555, 0xff695555, 0xff645555, 0xff675555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555,
            0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555, 0xffaa5555
        ]);
    }
}

import flash.geom.Vector3D;
class Part00 {
    public static const DIV:int = 32;
    private const RADIUS:Number = 100;
    private const DEGREE_TO_RADIAN:Number = Math.PI / 180;
    public var vertices:Vector.<Vector3D> = new Vector.<Vector3D>();
    public var indices:Vector.<int> = new Vector.<int>();
    public var uvts:Vector.<Number> = new Vector.<Number>();
    public function Part00() {
        vertices.push(new Vector3D(0, 0, 0));
        for (var i:int = 0; i < DIV; i ++) {
            var angle0:Number = 360 / DIV * i  * DEGREE_TO_RADIAN;
            vertices.push(new Vector3D(Math.cos(angle0) * RADIUS, Math.sin(angle0) * RADIUS, 40));
            if ( i == DIV - 1) {
                indices.push(0, i + 1, 1);
            } else {
                indices.push(0, i + 1, i + 2);
            }
            var angle1:Number = 360 / DIV * (i + 1)  * DEGREE_TO_RADIAN;
            uvts.push(
                0.25, 0.25, null,
                Math.cos(angle0) * 0.25 + 0.25, Math.sin(angle0) * 0.25 + 0.25, null,
                Math.cos(angle1) * 0.25 + 0.25, Math.sin(angle1) * 0.25 + 0.25, null
            );
            //
            if ( i == DIV - 1) {
                indices.push(0, 1, i + 1);
            } else {
                indices.push(0, i + 2, i + 1);
            }
            uvts.push(
                0.25, 0.25, null,
                Math.cos(angle1) * 0.25 + 0.25, Math.sin(angle1) * 0.25 + 0.25, null,
                Math.cos(angle0) * 0.25 + 0.25, Math.sin(angle0) * 0.25 + 0.25, null
            );
        }
    }
}

class Part01 {
    private const DEGREE_TO_RADIAN:Number = Math.PI / 180;
    public var vertices:Vector.<Vector3D> = new Vector.<Vector3D>();
    public var indices:Vector.<int> = new Vector.<int>();
    public var uvts:Vector.<Number> = new Vector.<Number>();
    public function Part01() {
        const DIV:int = 4;
        const RADIUS:Number = 2;
        const LENGTH:Number = 140;
        
        for (var i:int = 0; i < DIV; i ++) {
            var angle0:Number = 360 / DIV * i  * DEGREE_TO_RADIAN;
            
            vertices.push(new Vector3D(Math.cos(angle0) * RADIUS, Math.sin(angle0) * RADIUS, -4));
            vertices.push(new Vector3D(Math.cos(angle0) * RADIUS, Math.sin(angle0) * RADIUS, LENGTH));
            
            if ( i == DIV - 1) {
                indices.push(i * 2 + 0, i * 2 + 1, 0);
                indices.push(i * 2 + 1, 1, 0);
            } else {
                indices.push(i * 2 + 0, i * 2 + 1, i * 2 + 2);
                indices.push(i * 2 + 1, i * 2 + 3, i * 2 + 2);
            }
            uvts.push(
                0.9, 0.0, null,
                0.9, 0.5, null,
                0.8, 0.5, null,
                0.9, 0.5, null,
                0.8, 0.5, null,
                0.8, 0.0, null
            );
        }
        for (i = 1; i < DIV - 1; i ++) {
            indices.push(0, i * 2, i * 2 + 2);
            indices.push(1, i * 2 + 1, i * 2 + 3);
            
            uvts.push(
                0.90, 0.00, null,
                0.85, 0.10, null,
                0.80, 0.10, null,
                0.90, 0.00, null,
                0.85, 0.10, null,
                0.80, 0.10, null
            );
        }
    }
}

class Part02 {
    private const DEGREE_TO_RADIAN:Number = Math.PI / 180;
    public var vertices:Vector.<Vector3D> = new Vector.<Vector3D>();
    public var indices:Vector.<int> = new Vector.<int>();
    public var uvts:Vector.<Number> = new Vector.<Number>();
    public function Part02() {
        const DIV:int = 5;
        const RADIUS:Number = 3.5;
        const LENGTH:Number = -8;
        
        for (var i:int = 0; i < DIV; i ++) {
            var angle0:Number = 360 / DIV * i  * DEGREE_TO_RADIAN;
            vertices.push(new Vector3D(Math.cos(angle0) * RADIUS, Math.sin(angle0) * RADIUS, 4));
            vertices.push(new Vector3D(Math.cos(angle0) * RADIUS, Math.sin(angle0) * RADIUS, LENGTH));
            
            if ( i == DIV - 1) {
                indices.push(i * 2 + 0, i * 2 + 1, 0);
                indices.push(i * 2 + 1, 1, 0);
            } else {
                indices.push(i * 2 + 0, i * 2 + 1, i * 2 + 2);
                indices.push(i * 2 + 1, i * 2 + 3, i * 2 + 2);
            }
            uvts.push(
                0.9, 0.0, null,
                0.9, 0.5, null,
                0.8, 0.5, null,
                0.9, 0.5, null,
                0.8, 0.5, null,
                0.8, 0.0, null
            );
        }
        for (i = 1; i < DIV - 1; i ++) {
            //indices.push(0, i * 2, i * 2 + 2);
            indices.push(1, i * 2 + 1, i * 2 + 3);
            
            uvts.push(
                0.90, 0.00, null,
                0.85, 0.10, null,
                0.80, 0.10, null
            );
        }
        //合布
        var ai:int = vertices.length;
        const RADIUS2:Number = -20;
        const dAngle:Number = 40;
        vertices.push(new Vector3D(0, 0, -1));
        for (i = 0; i < 4; i ++) {
            angle0 = 360 / 4 * i  * DEGREE_TO_RADIAN;
            var angle1:Number = dAngle  * DEGREE_TO_RADIAN;
            vertices.push(new Vector3D(Math.cos(angle0 - angle1) * RADIUS2 * 0.5, Math.sin(angle0 - angle1) * RADIUS2 * 0.5, 1));
            vertices.push(new Vector3D(Math.cos(angle0) * RADIUS2, Math.sin(angle0) * RADIUS2, 3));
            vertices.push(new Vector3D(Math.cos(angle0 + angle1) * RADIUS2 * 0.5, Math.sin(angle0 + angle1) * RADIUS2 * 0.5, 1));
            
            indices.push(ai, ai + i * 3 + 1, ai + i * 3 + 2);
            indices.push(ai, ai + i * 3 + 2, ai + i * 3 + 3);
            
            uvts.push(
                0.00, 0.60, null,
                0.10, 0.50, null,
                0.20, 0.60, null,
                0.00, 0.60, null,
                0.20, 0.60, null,
                0.10, 0.70, null
            );
        }
        
    }
}

class Part03 {
    public var vertices:Vector.<Vector3D> = new Vector.<Vector3D>();
    public var indices:Vector.<int> = new Vector.<int>();
    public var uvts:Vector.<Number> = new Vector.<Number>();
    public function Part03() {
        const size:Number = 240;
        const hight:Number = 100;
        vertices.push(new Vector3D(-size, hight, size));
        vertices.push(new Vector3D(size, hight, size));
        vertices.push(new Vector3D(-size, hight, -size));
        vertices.push(new Vector3D(size, hight, -size));
        
        indices.push(0, 1, 3);
        indices.push(0, 3, 2);
            
        uvts.push(
            0.5, 0.5, null,
            0.6, 0.5, null,
            0.6, 0.6, null,
            0.5, 0.5, null,
            0.6, 0.6, null,
            0.5, 0.6, null
        );
    }
}
class Polygon {
    public var c:Number = 0;
    public var x:Number = 0;
    public var y:Number = 0;
    public var z:Number = 0;
    public var i0:int = 0;
    public var i1:int = 0;
    public var i2:int = 0;
    public var u0:Number = 0;
    public var u1:Number = 0;
    public var u2:Number = 0;
    public var v0:Number = 0;
    public var v1:Number = 0;
    public var v2:Number = 0;
    public function Polygon(i0:int, i1:int, i2:int, u0:Number, v0:Number, u1:Number, v1:Number, u2:Number, v2:Number) {
        this.i0 = i0;
        this.i1 = i1;
        this.i2 = i2;
        this.u0 = u0;
        this.v0 = v0;
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
    }
}