/**
 * Copyright kechol28 ( http://wonderfl.net/user/kechol28 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qkef
 */

package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    /**
     * ...
     * 
     * 何の変哲もないシンプルなアナログクロック。
     * 
     * 今回は針をdrawRectで描いたが、原点中心でずれなく回転させるのに手間取った。
     * 授業で説明してもらったようにlineToので描いたほうが簡単だな、と思った。
     */
    //[SWF(width="320",height="320",backgroundColor="#ffffff",frameRate="30")]
    public class SimpleClock extends Sprite
    {
        private var date:Date;
        private var cx:Number;
        private var cy:Number;
        private var h:Number;
        private var m:Number;
        private var s:Number;
        private var hhand:Sprite;
        private var mhand:Sprite;
        private var shand:Sprite;
        private var time:TextField;
        
        public function SimpleClock() 
        {
            init();
        }
        
        private function init():void
        {
            //時間を左上に表示。デバッグ用に。
            time = new TextField();
            addChild(time);
            
            //中心はよく使うので変数に記憶。
            cx = stage.stageWidth / 2;
            cy = stage.stageHeight / 2;
            
            var radius:Number = stage.stageWidth / 2 - 10;
            
            //時計の枠の描画。
            graphics.beginFill(0x000000);
            graphics.drawCircle(cx, cy, radius + 10);
            graphics.beginFill(0xffffff);
            graphics.drawCircle(cx, cy, radius);
            graphics.endFill();
            graphics.endFill();    
            
            //時針の描画
            hhand = new Sprite();
            drawHand(hhand, 0x333333, radius * 0.5, 5);
            
            //分針の描画
            mhand = new Sprite();
            drawHand(mhand, 0x666666, radius * 0.7, 3);
            
            //秒針の描画
            shand = new Sprite();
            drawHand(shand, 0xaaaaaa, radius * 0.9, 1);
            
            //中心の針の留め具の描画
            var center:Sprite = new Sprite();
            center.graphics.beginFill(0xff000000);
            center.graphics.drawCircle(cx, cy, 6);
            center.graphics.endFill();
            addChild(center);
            
            //時間の数字の描画
            var format:TextFormat = new TextFormat();
            format.size = 20;
            var i:int;
            for (i = 1; i < 13; i++)
            {
                var numField:TextField = new TextField();
                numField.autoSize = TextFieldAutoSize.LEFT;
                numField.defaultTextFormat = format;
                numField.text = String(i);
                //中心からの角度を計算した後、綺麗に並ぶように自分のwidth, heightの半分を引いて調整。
                numField.x = (radius * 0.8) * Math.sin(i / 6 * Math.PI) + cx - numField.width / 2;
                numField.y = -1 * (radius * 0.8) * Math.cos(i / 6 * Math.PI) + cy - numField.height / 2;
                addChild(numField);
            }
            
            //イベントリスナの登録
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        //フレームごとの処理。時間を更新して針を回転させる。
        private function onEnterFrame(event:Event):void 
        {
            date = new Date();
            h = date.getHours();
            hhand.rotation = h * 30 - 90;
            m = date.getMinutes();
            mhand.rotation = m * 6 - 90;
            s = date.getSeconds();
            shand.rotation = s * 6 - 90;
            
            time.text = h + ":" + m + ":" + s;
        }
        
        //針を描画するための関数。
        private function drawHand(hand:Sprite, color:uint, length:Number, width:Number):void
        {
            hand.graphics.beginFill(color);
            hand.graphics.drawRect(-width / 2, -width / 2, length, width);
            hand.graphics.endFill();
            
            hand.x = cx;
            hand.y = cy;
            addChild(hand);
        }
    }
    
}