/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qk0G
 */

// forked from WinField95's SoundVisualizer
/*
 * 曲名：Robot Warrior　http://www.ektoplazm.com/free-music/tsabeat-warp-speed-ep/
 * okoiさんの作品　http://wonderfl.net/c/hwGa　のURLから拝借。
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.filters.GlowFilter;
    import flash.display.LineScaleMode;
    import flash.display.CapsStyle;
    import flash.display.JointStyle;
    import flash.media.SoundChannel
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFieldAutoSize;    
    import flash.media.SoundLoaderContext;       

    public class Main extends Sprite
    {
        private var sound:Sound;
        private var soundCh:SoundChannel;
        private var ba:ByteArray = new ByteArray();
        private var line:Sprite = new Sprite();
        private var tf:TextField = new TextField();        
        private const WIDTH:Number = 400;
        private const HEIGHT:Number = 232.5;    
        private static const    SOUND_FILE:String= "http://kouetu.skura.ne.jp/MP3_ujic3/zigeunerweisen.mp3";            

        public function Main()
        {            
            graphics.beginFill(0x0);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();            

            sound = new Sound();
            sound.load(new URLRequest(SOUND_FILE), new SoundLoaderContext(10, true));
            soundCh = sound.play();
            soundCh.addEventListener(Event.SOUND_COMPLETE, SoundChannelCompleteHandler);            

            var tf:TextField = new TextField();
            tf.defaultTextFormat = new TextFormat("_typeWriter", 20, 0xFFFFFF, true);
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.text = "♪ Robot Warrior";
            tf.x = 30;
            tf.y = 430;
            tf.filters = [new GlowFilter(0x0000FF)];
            addChild(tf);            
            addChild(line);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }         
        
        public function SoundChannelCompleteHandler(event:Event):void {
            soundCh.removeEventListener(Event.SOUND_COMPLETE,SoundChannelCompleteHandler);
            soundCh = null;
            // 最初から再生
            soundCh = sound.play(0, 1);
            soundCh.addEventListener(Event.SOUND_COMPLETE,SoundChannelCompleteHandler);
        }
        
        private function onEnterFrame(event:Event):void 
        {
            SoundMixer.computeSpectrum(ba, true, 0); 
            line.graphics.clear();            
            line.graphics.lineStyle(1, 0xFFFFFF, 1, false, LineScaleMode.NORMAL, CapsStyle.NONE, JointStyle.MITER, 1);
            line.filters = [new GlowFilter(0x00FF00)];            
            line.graphics.moveTo(0, HEIGHT);
            line.graphics.lineTo(33,HEIGHT);

                       
            for (var i:int = 0; i < 256; i++){
                var value:Number = ba.readFloat();
                if(value == 0)line.graphics.lineTo(33 + WIDTH / 256 * i, HEIGHT);
                else line.graphics.lineTo(33 + WIDTH / 256 * i, HEIGHT - HEIGHT * value + HEIGHT/4.0);
            }            
            line.graphics.lineTo(WIDTH + 33,HEIGHT);
            line.graphics.lineTo(WIDTH + 66,HEIGHT);            
        }
    }
}

