/**
 * Copyright andyshang ( http://wonderfl.net/user/andyshang )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qisb
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TextEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;

    [SWF(width="540", height="300")]
    public class NumberToString extends Sprite
    {
        private var dot:String = "点";
        private var zero:String = "零"
        private var labelBig:String = "拾佰仟万亿";
        private var labelLittle:String = "十百千万亿";
        private var numLittleLabel:Array = "一二三四五六七八九十".split("");
        private var numBigLabel:Array = "壹贰叁肆伍陆柒捌玖".split("");

        private var TenThousand:int = 10000;
        private var YI:int = 10000 * 10000;
        private var value:Number;

        private var checkZero:Boolean = false;

        public function NumberToString()
        {
            graphics.beginFill(0xABCDEF,1);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);

            var inputField:TextField = new TextField();

            var textFormat:TextFormat = new TextFormat("Courier New", 17, 0x0, false,false,false,null,null,TextFormatAlign.RIGHT);
            inputField.width = 520;
            inputField.height = 25;
            inputField.defaultTextFormat = textFormat
            inputField.x = 10;
            inputField.y = 15;
            inputField.maxChars = 15;
            inputField.type = "input";
            inputField.restrict = "0-9.\\-";
            inputField.addEventListener(TextEvent.TEXT_INPUT, function(event:TextEvent):void
            {
                if((inputField.length == 0  || inputField.text=="-")&& event.text == ".")
                {
                    inputField.text += "0.";
                    event.preventDefault();
                    event.stopPropagation();
                    inputField.setSelection(inputField.length, inputField.length);
                    return;
                }
                if(inputField.text.indexOf(".") > -1 && event.text == ".")
                {
                    event.preventDefault();
                    event.stopPropagation();
                    inputField.setSelection(inputField.length, inputField.length);
                    return;
                }
                if(inputField.length != 0 && event.text == "-")
                {
                    event.preventDefault();
                    event.stopPropagation();
                    return;
                }
                if((inputField.text == "0" || inputField.text == "-0") && event.text != ".")
                {
                    event.preventDefault();
                    event.stopPropagation();
                    return;
                }
            });
            inputField.addEventListener(Event.CHANGE, function(event:Event):void
            {
                outputFieldLittle.text = convert(Number(inputField.text));
                outputFieldBig.text = convert(Number(inputField.text), true);
            });

            var outputFieldLittle:TextField = new TextField();
            var outputFieldBig:TextField = new TextField();

            inputField.border = true;

            outputFieldLittle.width = 520;
            outputFieldLittle.height = 25;
            outputFieldLittle.x = 10;
            outputFieldLittle.y = 65;
            outputFieldLittle.defaultTextFormat = textFormat;

            outputFieldBig.width = 520;
            outputFieldBig.height = 25;
            outputFieldBig.x = 10;
            outputFieldBig.y = 95;
            outputFieldBig.defaultTextFormat = textFormat;

            addChild(inputField);
            addChild(outputFieldLittle);
            addChild(outputFieldBig);
        }

        public function convert(value:Number, big:Boolean=false):String
        {
            this.value = value;
            var res:String = (Math.abs(value) < 1? "零":doConvertInteger(Math.abs(value), big)) +
                             doConvertDecimal(value, big);
            if(value < 0)
            {
                res = "负"+res;
            }
            return res;
        }

        private function doConvertDecimal(value:Number, big:Boolean):String
        {
            var res:String = "";
            var str:String = String(value);
            var dotIndex:int = str.indexOf(".");
            if(dotIndex == -1)
            {
                return "";
            }
            else
            {
                str = str.substring(dotIndex+1);
            }
            if(str.length > 0)
            {
                res += "点";
            }
            for(var i:int=0;i<str.length;i++)
            {
                if(str.charAt(i) == "0")
                {
                    res += "零";
                }
                else
                {
                    res += (big?numBigLabel:numLittleLabel)[Number(str.charAt(i))-1];
                }
            }
            return res;
        }

        private function doConvertInteger(value:Number, big:Boolean):String
        {
            var res:String = "";
            if(value >= YI)
            {
                res += doConvertInteger(int(value / YI), big) + "亿";
            }
            res += parseTenThousand(value % YI, big);
            checkZero = false;
            return res;
        }

        private function parseTenThousand(value:int, big:Boolean):String
        {
            var res:String = "";
            if(value >= TenThousand)
            {
                res += parseThousand(value / TenThousand, big) + "万";
                checkZero = true;
            }
            res += parseThousand(value % TenThousand, big);
            return res;
        }

        private function parseThousand(value:int, big:Boolean):String
        {
            var res:String = "";
            var t:int = int(value / 1000);
            var h:int = int(value / 100) % 10;
            var d:int = int(value / 10) % 10;
            var n:int = value % 10
            if(t > 0)
            {
                res += (big?numBigLabel:numLittleLabel)[t-1] + (big?"仟":"千");
                checkZero = false;;
            }
            if(h > 0)
            {
                addZero();
                res += (big?numBigLabel:numLittleLabel)[h-1] + (big?"佰":"百");
            }
            else if(t > 0)
            {
                checkZero = true;
            }
            if(d>0)
            {
                if(this.value >= 20 || checkZero)
                {
                    addZero();
                    res += (big?numBigLabel:numLittleLabel)[d-1] + (big?"拾":"十");
                }
                else
                {
                    res += big?"拾":"十"
                }
            }
            else if(h > 0)
            {
                checkZero = true;
            }
            if(n>0)
            {
                addZero();
                res += (big?numBigLabel:numLittleLabel)[n-1];
            }

            function addZero():void
            {
                if(checkZero)
                {
                    res += "零"
                    checkZero = false;
                }
            }
            return res;
        }
    }
}