/**
 * Copyright mmlemon_ ( http://wonderfl.net/user/mmlemon_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qiep
 */

package {
    import flash.display.Sprite;
	 import flash.events.Event;
	
	/**
	 * 円周上に等間隔に配置し、それぞれの向きを考慮させるサンプル。
	 */
	[SWF(backgroundColor=0x0,frameRate=60,width=800,height=600)]
	public class RotateSample extends Sprite
	{
		// カード数
		private static const ITEMS_NUM:uint = 10;
		// カードを保持するためのVector
		private var m_items:Vector.<Sprite>;
		// 回転させるための変数です。
		private var frame:int = 0;
		// 円半径
		private var radius:Number = 200;
		
		// アニメーションさせます。
		private function onRender(event:Event):void
		{
			for(var i:uint=0; i < ITEMS_NUM; i++)
			{
				// 基本的には、等間隔配置の計算＋アニメーションさせるための値（frameが関わるやつ）
				// を行っています。
				var item:Sprite = m_items[i];
				// 角度を算出
				// 360°上に等間隔に配置する
				var radian:Number = (Math.PI * 2) / ITEMS_NUM * i + (frame*Math.PI/180);
				// 円周上の配置に半径を掛ける。中心はステージ中央。
				item.x = Math.cos(radian) * radius + stage.stageWidth/2;
				item.y = Math.sin(radian) * radius + stage.stageHeight/2;
				// カードの向きを調整する。
				item.rotation = 360/ITEMS_NUM*i+90 + frame;
			}
			// 回転させたいのでインクリメント
			frame++;
		}
		// 取りあえずカードを生成します。
		private function genItems():void
		{
			m_items = new Vector.<Sprite>();
			for(var i:uint = 0; i < ITEMS_NUM; i++)
			{
				var item:Sprite = new Sprite();
				item.graphics.beginFill(0xff00ff, 1);
				item.graphics.drawRect(-25, -12.5, 50, 25);
				item.graphics.endFill();
				addChild(item);
				m_items.push(item);
			}
		}
		
		private function init():void
		{
			genItems();
			addEventListener(Event.ENTER_FRAME, onRender, false, 0, false);
		}
		public function RotateSample()
		{
			init();
		}
	}
}