/**
 * Copyright JLChnToZ ( http://wonderfl.net/user/JLChnToZ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qicA
 */

// forked from JLChnToZ's MP3 XY Oscilloscope
// forked from JLChnToZ's Spectrum MP3 Player
package {
	import flash.display.*;
	import flash.media.*;
	import flash.geom.*;
	import flash.net.*;
	import flash.events.*;
	import flash.utils.*;
	import flash.ui.*;

	public class FlashTest extends Sprite {
		var s:Sound;

		var ba:ByteArray = new ByteArray();
		var a:Array = new Array(512);
		var trot:Number = Math.pow(2, 1/12);
		var fr:FileReference = new FileReference();
		var colors:Array = new Array(3);
		var sc:SoundChannel;
		var lastUpdateTime:Number;
		var canvas:Shape;
		var bd:BitmapData;
		var bm:Bitmap;
		var lastX:Number;
		
		function clamp(value:Number, min:Number, max:Number):Number {
			return Math.min(Math.max(value, min), max);
		}
		
		function lerp(start:Number, end:Number, amount:Number):Number {
			if(!start) start = 0;
			if(!end) end = 0;
			return start + (end - start) * amount;
		}
		
		function getColor(c:uint):Number {
			return (((c >> 16) & 0xFF) + ((c >> 8) & 0xFF) + (c & 0xFF)) / 255 / 3;	
		}
		
		function setColor(c:Number):uint {
			c = clamp(c * 255, 0, 255);
			return ((c << 16) | (c << 8) | c);
		}
		
		function readSpectrum(e:Event) {
			var i:Number, j:Number, m:Number = getTimer();
			var w:Number = stage.stageWidth, h:Number = stage.stageHeight;
			var maxL:Number = 0, maxR:Number = 0;
			var currentX:Number = 0;
			var f:Number = (m - lastUpdateTime) / 25;
			SoundMixer.computeSpectrum(ba, false, 0);
			for(i = 0; i < 512; i++)
				a[i] = ba.readFloat();

			bd.lock();
			// bd.colorTransform(new Rectangle(0, 0, bd.width, bd.height), new ColorTransform(0.8, 0.8, 0.8, 1));
			bd.scroll(0, -4);
			canvas.graphics.clear();
			canvas.graphics.moveTo((lastX + 0.5) * bd.width, bd.height - 7);
			for(j = 0; j < 4; j++) {
				for(i = 0; i < 64; i++) {
					maxL = Math.max(maxL, Math.abs(a[j * 64 + i]));
					maxR = Math.max(maxR, Math.abs(a[j * 64 + i + 256]));
				}
				canvas.graphics.lineStyle(1, setColor((maxL + maxR) / 2), 1);
				currentX = (-maxL + maxR) / 2;
				canvas.graphics.lineTo((currentX + 0.5) * bd.width, bd.height - 8 + j);
				lastX = currentX;
			}
			bd.draw(canvas);
			bd.unlock();
			bm.width = w;
			bm.height = h;
			lastUpdateTime = m;
		}
		
		function updatePixel(x:int, y:int, amount:Number) {
			var c:Number = getColor(bd.getPixel(x, y));
			bd.setPixel(x, y, setColor(c + amount));
		}
		
		function onLoadButtonClick(e:ContextMenuEvent) {
			fr.browse([new FileFilter("MP3 Files (*.mp3)","*.mp3")]);
		}
		
		function onReplayClick(e:ContextMenuEvent) {
			sc.stop();
			if(s) sc = s.play(0);
		}
		
		function onStopClick(e:ContextMenuEvent) {
			sc.stop();
		}
		
		function onFileSelected(e:Event) {
			fr.load();
		}
		
		function onFileLoad(e:Event) {
			var f:FileReference = e.target as FileReference;
			var data:ByteArray = f.data;
			
			s = new Sound();
			s.loadCompressedDataFromByteArray(data, data.length);
			sc.stop();
			sc = s.play();
		}

		public function FlashTest() {
			stage.scaleMode = "noScale";
			stage.align = "TL";
			sc = new SoundChannel();
			
			bd = new BitmapData(512, 512, false, 0x00000000);
			bm = new Bitmap(bd);
			bm.x = 0;
			bm.y = 0;
			addChild(bm);
			
			canvas = new Shape();
			
			var my_menu = new ContextMenu();
			my_menu.hideBuiltInItems();
			var loadFileMenuItem = new ContextMenuItem("Load File...");
			loadFileMenuItem.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, onLoadButtonClick);
			my_menu.customItems.push(loadFileMenuItem);
			
			var replayMenuItem = new ContextMenuItem("Replay");
			replayMenuItem.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, onReplayClick);
			my_menu.customItems.push(replayMenuItem);
		
			var stopMenuItem = new ContextMenuItem("Stop");
			stopMenuItem.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, onStopClick);
			my_menu.customItems.push(stopMenuItem);
			lastUpdateTime = getTimer();
			this.addEventListener(Event.ENTER_FRAME, readSpectrum);
			fr.addEventListener(Event.SELECT, onFileSelected);
			fr.addEventListener(Event.COMPLETE, onFileLoad);
			contextMenu = my_menu;		  
		}
	}
}
