/**
 * Copyright mirrorboy ( http://wonderfl.net/user/mirrorboy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qi2t
 */

package
{
    import flash.system.LoaderContext;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;

    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    
    
    public class PixelDissolveTest extends Sprite
    {
        private var bitmapData:BitmapData;
        private var filterWidth:Number  = 100;
        private var point:Point = new Point(0,0);
        
        protected var _loadedBitmap:Bitmap;

      
        public function PixelDissolveTest()
        {
            loadImage("http://assets.wonderfl.net/images/related_images/4/48/4825/4825be74cce1c3cf7f9c34fef5f2ae21be742bac");
        }
        
        protected function runPostImageLoad():void{
            bitmapData = _loadedBitmap.bitmapData;
        
            addChild(_loadedBitmap);
            stage.addEventListener(Event.ENTER_FRAME,onEnterFrame);
            _loadedBitmap.filters[getSaturationFilter()];
        }
        
        /*
        private function onMouseMove(event:MouseEvent):void{
            
            
                        
        }*/
        
        private function onEnterFrame(event:Event):void
        {
            point.x -= (point.x - mouseX)/8;
            point.y -= (point.y - mouseY)/8;
                        
            var numPixels:uint = (bitmapData.width * bitmapData.height)/300;
            bitmapData.pixelDissolve(bitmapData,new Rectangle(point.x - filterWidth/2,0,filterWidth,bitmapData.width),new Point(),1000*Math.random(),numPixels,bitmapData.getPixel32(mouseX,mouseY));            
        }
        
        private function getSaturationFilter():ColorMatrixFilter{
            var r:Number = 0.3;
            var g:Number = 0.59;
            var b:Number = 0.11;
            
            var amount:Number = 2.2;
            var inverse:Number = 1 - amount;
            var matrix:Array= [ 
                
                inverse*r + amount , inverse * g , inverse * b , 0,0,
                inverse*r,             inverse * g + amount , inverse * b,0,0,
                inverse*r,             inverse * g , inverse*b + amount,0,0,
                0,                     0,               0,                  1,0
            ];
            
            return new ColorMatrixFilter(matrix);
        }
        
        private function loadImage(imagePath:String):void{
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE,onImageLoaded);
            loader.load(new URLRequest(imagePath),new LoaderContext(true));
        }
        
        private function onImageLoaded(event:Event):void{
            var loaderInfo:LoaderInfo = event.target as LoaderInfo;
            _loadedBitmap = loaderInfo.content as Bitmap;
            runPostImageLoad();
        }
        
    }
    
}

