/**
 * Copyright mt373 ( http://wonderfl.net/user/mt373 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qhQn
 */

// forked from faseer's drag and rotate
package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    public class FlashTest extends Sprite {
            private var drList:Array;
        public function FlashTest() {
            
                stage.align = StageAlign.TOP_LEFT;
                stage.scaleMode = StageScaleMode.NO_SCALE;
                stage.stageFocusRect = false;
            
                drList = [];
                
            for(var i:int=0; i<15; ++i)
            {
                    drList[drList.length] = new DragRotater(
                        addChild(new Card(
                            Math.random()*400,
                            Math.random()*400,
                            100 + Math.random()*100,
                            100 + Math.random()*100,
                            Math.random()*360)
                        ) as Sprite
                    );
            }
        }
    }
}

import flash.display.Sprite;
class Card extends Sprite
{
    public function Card(x:Number, y:Number, w:Number, h:Number, r:Number)
    {
        graphics.beginFill(Math.random() * 0xFFFFFF);
        graphics.drawRoundRect(-w*.5, -h*.5, w,h, 16, 16);
        graphics.endFill();
        this.x = x;
        this.y = y;
        rotation = r;
    }
}

import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.events.Event;
class DragRotater
{
    protected var x:Number;
    protected var y:Number;
    protected var r:Number;
    protected var vx:Number = .0;
    protected var vy:Number = .0;
    protected var vr:Number = .0;
    protected var aax:Number = .0;
    protected var aay:Number = .0;
    protected var mass:Number = 1.0;
    protected var damp:Number = .9;
    protected var mx0:Number;
    protected var my0:Number;
    protected var free:Boolean = true;
    protected var _skin:Sprite;
    
    public function DragRotater(skin:Sprite = null)
    {
        this.skin = skin;
    }
    
    public function get skin():Sprite{ return _skin; }
    public function set skin(v:Sprite):void
    {
        if(skin) uninit(null);
        _skin = v;
        if(skin){
            if(skin.stage) init(null);
            else skin.addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
        }
    }
    
    protected function init(e:Event):void
    {
        skin.addEventListener(Event.REMOVED_FROM_STAGE, uninit);
        skin.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        skin.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        skin.stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        
        x = skin.x;
        y = skin.y;
        r = skin.rotation;
    }
    protected function uninit(e:Event):void
    {
        skin.removeEventListener(Event.REMOVED_FROM_STAGE, uninit);
        skin.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
        skin.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        skin.stage.removeEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    }
    
    protected function onMouseUp(e:MouseEvent):void
    {
        vx += aax;
        vy += aay;
        aax = aay = 0;
        free = true;
    }
    
    protected function onMouseDown(e:MouseEvent):void
    {
        mx0 = skin.parent.mouseX;
        my0 = skin.parent.mouseY;
        free = false;
    }
    
    protected function onEnterFrame(e:Event):void
    {
        if(free)
        {
            x += vx;
            y += vy;
        }
        else
        {
            var mx:Number = skin.parent.mouseX;
            var my:Number = skin.parent.mouseY;
            var dmx:Number = mx - mx0;
            var dmy:Number = my - my0;
            mx0 = mx;
            my0 = my;
            
            var fx:Number = (dmx - vx) * mass;
            var fy:Number = (dmy - vy) * mass;
            var ax:Number = mx - x;
            var ay:Number = my - y;
            var t:Number = fx * ay - fy * ax;
            
            vx = dmx;
            vy = dmy;
            vr += t * .005;
            
            x += vx;
            y += vy;
            
            var dx:Number = mx - x;
            var dy:Number = my - y;
            var cos:Number = Math.cos(vr * Math.PI / 180);
            var sin:Number = Math.sin(vr * Math.PI / 180);
            aax = dx - (cos * dx + sin * dy);
            aay = dy - (cos * dy - sin * dx);
            
            x += aax;
            y += aay;
        }
        
        r -= vr;
        
        vx *= damp;
        vy *= damp;
        vr *= damp;
        
        skin.x = x;
        skin.y = y;
        skin.rotation = r;
    }
}