/**
 * Copyright littlepad ( http://wonderfl.net/user/littlepad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qgpA
 */

package {
    import flash.display.InterpolationMethod;
    import flash.geom.Matrix;
    import flash.display.SpreadMethod;
    import flash.display.GradientType;
    import flash.utils.Timer;
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.events.TimerEvent;
    
    [SWF(width="465", height="465", frameRate="30")]
    
    public class Main extends Sprite {
        private var _timer:Timer;
        
        public function Main() {
            init();
        }
        
        private function init():void {
            // 背景
            var matrix:Matrix = new Matrix();
            matrix.rotate(Math.PI/2);
            matrix.translate(1638.4/2, 1638.4/2);
            matrix.scale(465/1638.4, 465/1638.4);
            this.graphics.beginGradientFill(
                GradientType.LINEAR,
                [0xfef1e0, 0xcbb29c, 0x9a8477],
                [1, 1, 1],
                [0, 170, 255],
                matrix,
                SpreadMethod.PAD,
                InterpolationMethod.RGB,
                0.0
            );
            this.graphics.drawRect(0, 0, 465, 465);
            this.graphics.endFill();
            
            _timer = new Timer(20);
            _timer.addEventListener(TimerEvent.TIMER, onTimer);
            _timer.start();
        }
        
        private function onTimer(e:TimerEvent):void {
            var bubble:Bubble = new Bubble();
            addChild(bubble);
        }

    }
}
import flash.display.AVM1Movie;

import flash.display.Sprite;
import flash.events.Event;
import flash.filters.BlurFilter;
internal class Bubble extends Sprite {
    private var _angle:Number = 0;
    private var _rangeX:Number = 8;
    private var _speedX:Number = 0.08;
    private var _speedY:Number = 5;
    private var _alpha:Number = 0.8;
    private var _blurX:Number = 0;
    private var _blurY:Number = 0;
    private var _defaultX:Number;

    public function Bubble() {
        init();
    }
    
    private function init():void {
        var radius:Number;
        radius = int(Math.random() * 5) + 1;
        
        if(radius == 5) {
            alpha = _alpha;
        } else if(radius == 4) {
            _speedY -= 0.5;
            _rangeX -= 2;
            _blurX = _blurY = 1;
            alpha = _alpha - 0.1;
        } else if(radius == 3) {
            _speedY -= 1;
            _rangeX -= 4;
            _blurX = _blurY = 2;
            alpha = _alpha - 0.2;
        } else if(radius == 2) {
            _speedY -= 1.5;
            _rangeX -= 6;
            _blurX = _blurY = 3;
            alpha = _alpha - 0.3;
        } else if(radius == 1) {
            _speedY -= 2;
            _rangeX -= 8;
            //_blurX = _blurY = 4;
            alpha = _alpha - 0.3;
        }
        
        // 気泡描画
        this.graphics.beginFill(0xffffff);
        this.graphics.drawCircle(0, 0, radius);
        this.graphics.beginFill(0xfef1e0);
        this.graphics.drawCircle(0, 0, radius * 4/5);
        this.graphics.endFill();
        this.filters = [new BlurFilter(_blurX, _blurY)];
        
        this.x = _defaultX = int(Math.random() * 205) + 130;
        this.y = 465;
        
        var rNum:int;
        rNum = int(Math.random() * 2) - 1;
        if(rNum){
            _speedX *= -1;
        }

        this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    private function onEnterFrame(e:Event):void {
        x = _defaultX + Math.sin(_angle) * _rangeX;
        _angle += _speedX;
        y -= _speedY;
        if(y < 0){
            this.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
            parent.removeChild(this);
        }
    }

}
