/**
 * Copyright chimanaco ( http://wonderfl.net/user/chimanaco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qgIU
 */

/**
 * [study] circular motion
 * 
 * See a very good sample for circular motion!
 * サイン・コサインを使った円運動
 * http://wonderfl.net/c/yKQl
 *
 * 
 * 360° = 2 * Math.PI * radians;
 * 
 * radians = degrees * Math.PI / 180;
 * degrees = radians * 180 / Math.PI;
 * 
 * x position use cos 0°(1),90°(0),180°(-1),270°(0),360°(1)
 * y position use sin 0°(0),90°(1),180°(0),270°(-1),360°(0)
 * 
 * 
 */
package 
{
    import com.bit101.components.*;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.text.TextField;
    import flash.events.MouseEvent;
    import flash.text.TextFieldAutoSize;
    
    // 360° = 2 * Math.PI * radians;
     
    // radians = degrees * Math.PI / 180;
    // degrees = radians * 180 / Math.PI;
    
    // x position use cos 0°(1),90°(0),180°(-1),270°(0),360°(1)
    // y position use sin 0°(0),90°(1),180°(0),270°(-1),360°(0)
    
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "000000")]
    public class CircularMotion extends Sprite
    {
        private var eye:Eye;
        private var angle:Number = 0;
        private var stageW:Number;
        private var stageH:Number;
        private var centerX:Number;
        private var centerY:Number;
        private var radiusX:Number = 200;
        private var radiusY:Number = 200;
        private var speed:Number = 1;

        private var button:PushButton;
        private var inputs:Array = [];
        private var tfValue:TextField;
        
        private var canvas:BitmapData;
        private var ctf:ColorTransform = new ColorTransform(0.9, 0.95, 0.95, 1, 0, 0, 0, 0);
        
        /**
         * Constructor
         *
         */
        public function CircularMotion() {
            init();
        }
        
        /**
         * init
         *
         */
        private function init():void {
            stageW = stage.stageWidth;
            stageH = stage.stageHeight;
            
            centerX = stageW / 2;
            centerY = stageH / 2;
           
            // bitmap for after image effect
            canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            var bmp:Bitmap = new Bitmap(canvas);
            addChild(bmp);
            
            // eyeball
            eye = new Eye();
            addChild(eye);
            
            /* setup */
            // create center point
            createBase(centerX, centerY);
            
            // display of numbers
            createText();
            
            // changer
            createChanger("radiusX", 110, 155, radiusX);
            createChanger("radiusY", 190, 235, radiusY);
            createChanger("speed", 270, 305, speed);
            
            // button
            createButton();
            
            // 
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
        }
        
        /**
         * create Center Point and 0 degree
         *
         */
        private function createBase(centerX:Number, centerY:Number):void 
        {
            var dx:int = 5, dy:int = 5;
            var r:int = 30;
            var sh:Shape = new Shape();

            sh.graphics.lineStyle(3, 0xFFFFFF);
            sh.graphics.moveTo(centerX, centerY);
            sh.graphics.lineTo(stageW, centerY);
            
            sh.graphics.lineStyle(3, 0xFFFFFF);
            sh.graphics.moveTo(centerX + r , centerY);
            sh.graphics.curveTo(centerX + r , centerY + r, centerX, centerY + r);
            
            sh.graphics.moveTo(centerX, centerY + r);
            sh.graphics.lineTo(centerX + dx, centerY + r + dy);
            sh.graphics.moveTo(centerX, centerY + r);
            sh.graphics.lineTo(centerX + dx, centerY + r - dy);
            
            sh.graphics.lineStyle(3, 0xFF0000);
            sh.graphics.moveTo(centerX - dx, centerY - dy);
            sh.graphics.lineTo(centerX + dx, centerY + dy);
            sh.graphics.moveTo(centerX - dx, centerY + dy);
            sh.graphics.lineTo(centerX + dx, centerY - dy);
            
            addChild(sh);
            
            var tf:TextField = new TextField(); 
            tf.text = "( x = 0 , y = 0 )";
            tf.textColor = 0xFFFFFF;
            tf.autoSize = TextFieldAutoSize.CENTER;
            tf.x = centerX - tf.width / 2;
            tf.y = centerY - 30;
            addChild(tf);
            
        }
        
        /**
         * create display value
         *
         */
        private function createText():void 
        {
            tfValue = new TextField(); 
            tfValue.textColor = 0xFFFFFF;
            tfValue.x = 10;
            tfValue.y = 10;
            addChild(tfValue);
        }
        
        /**
         * 　create number changer
         *
         */
        private function createChanger(str:String, txtX:Number, inputX:Number, def:Number):void
        {
            var tf_Y:int = 360;
            var tf_H:int = 15;
            var input_W:int = 30;
            
            var tf:TextField = new TextField(); 
            tf.text = str;
            tf.textColor = 0xFFFFFF;
            tf.x = txtX;
            addChild(tf);
            
            var ti:InputText = new InputText(this, 20, 110);
            ti.x = inputX;
            ti.width = input_W;
            //ti.text = def.toString();
            ti.text = def.toString();
            //ti.text = "aaaa";
            //addChild(ti);
            
            tf.y = ti.y = tf_Y;
            tf.height = tf_H;
            
            // push Array
            inputs.push(ti);
        }
        
        /**
         * 　the change button
         *
         */
        private function createButton():void 
        {
            var button_Y:int = 400;
            
            button = new PushButton(this, 10, 20,"change!", onClick); 
            button.x = stage.stageWidth / 2 - button.width / 2;
            button.y = button_Y;
            addChild(button);
        }
        
        /**
         * 　when the change button is clicked
         *
         */
        private function onClick(e:MouseEvent):void 
        {    
            // change property
            radiusX = inputs[0].text;
            radiusY = inputs[1].text;
            speed = inputs[2].text;
            
            canvas.fillRect(canvas.rect, 0x000000);
        }
        
        /**
         * 　onEnterFrameHandler
         *
         */
        private function onEnterFrame(e:Event):void 
        {
            // convert degrees into radians (add 90 degrees for adjusting position of 0 degree position)
            var radian:Number = (angle) * Math.PI / 180;
            
            // update positions
            eye.x = centerX + Math.cos(radian) * radiusX;
            eye.y = centerY + Math.sin(radian) * radiusY;
            
            // display value
            tfValue.text = "x: " + Math.round((eye.x - centerX) * 10) / 10 + "\n"
                + "y: " + Math.round((eye.y - centerY) * 10) / 10 + " \n"
                + "degrees: " + angle;
            
            // add angles
            angle += speed;
            angle = angle % 360;
            
            // after image effect
            var mat:Matrix = new Matrix();
            mat.translate(eye.x, eye.y);
            canvas.lock();
            canvas.draw(eye, mat);
            canvas.colorTransform(canvas.rect, ctf);
            canvas.unlock();
        }
    }
}

import flash.geom.Point;
import flash.display.Sprite;

internal class Eye extends Sprite
{
   private var r:int = 10;
   
   /**
    * Constructor
    * 
    */
    public function Eye() {
        // eyeball
        graphics.beginFill(0xFF0000);
        graphics.drawCircle(0, 0, 15);
        graphics.endFill();
        
        // white
        graphics.beginFill(0xFFFFFF);
        graphics.drawCircle(0, 0, r);
        graphics.endFill();
        
        // black
        graphics.lineStyle(0);
        graphics.beginFill(0x000000);
        graphics.drawCircle(0, 0, 6);
        graphics.endFill();
        
        // 
        createPie(r, 280, 340, 0xFFFFFF);
    }
    
    private function createPie(radius:Number, startDeg:Number , endDeg:Number, fillColor:uint):void
    {    
        var pt:Point;
        var deg:int;
        
        var offset:Number = -90;
        graphics.lineStyle();
        graphics.beginFill(fillColor);
        graphics.moveTo(0, 0);
        for (deg = startDeg; deg <= endDeg; deg++) {
            var radian:Number = (deg + offset) * Math.PI / 180;
            pt = Point.polar(radius, radian);
            graphics.lineTo(pt.x, pt.y);
        }
        graphics.lineTo(0, 0);
        graphics.endFill();
    }
}
