/**
 * Copyright Fumio ( http://wonderfl.net/user/Fumio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qeqjA
 */

// coded by Ivan Dembicki
// http://www.mail-archive.com/flashcoders@chattyfig.figleaf.com/msg55675.html
package {
  import flash.display.Sprite;
  import flash.events.Event;

  public class PyramyDepth extends Sprite {

    private var holder : Sprite = new Sprite();

    public function PyramyDepth() {
      super();
      initInstance();
    }

    private function initInstance() : void {
      y = 50;
      x = 300;
      addChild(holder);
      drawVisibleArea();
      addPhotos(100);

      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    private function onEnterFrame(event : Event) : void {
      holder.x -= mouseX / 100;
      dispatchEvent(new Event(Event.CHANGE));
    }

    private function addPhotos(num : Number) : void {
      var previous : AnyPhoto;
      for (var i : int = 0;i < num; i++) {
        var anyPhoto : AnyPhoto = new AnyPhoto(this, previous);
        holder.addChild(anyPhoto);
        previous = anyPhoto;
      }
      holder.x = -holder.width / 2;
      dispatchEvent(new Event(Event.CHANGE));
    }

    private function drawVisibleArea() : void {
      graphics.lineStyle(0, 0);
      graphics.drawRect(-200, 0, 400, 60);

      graphics.moveTo(0, -100);
      graphics.lineTo(0, 100);
    }
  }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;

class AnyPhoto extends Sprite {

  private static var topPhoto : AnyPhoto;

  private var previous : AnyPhoto;
  private var next : AnyPhoto;
  private var point : Point = new Point();
  private var pyramyDepth : PyramyDepth;

  public function AnyPhoto(pyramyDepth : PyramyDepth, prev : AnyPhoto) {
    super();
    initInstance(pyramyDepth, prev);
  }

  private function initInstance(pyramyDepth : PyramyDepth, prev :
AnyPhoto) : void {
    this.pyramyDepth = pyramyDepth;
    pyramyDepth.addEventListener(Event.CHANGE, onChange);

    graphics.lineStyle(0, 0);
    graphics.beginFill(0xFFFFFF * Math.random());
    graphics.drawRect(-50, -40, 100, 60);
    y = 30;

    previous = prev;
    if (previous) {
      previous.next = this;
      setPosition();
    }
  }

  private function setPosition() : void {
    x = previous.x + previous.width / 2;
  }

  private function onChange(event : Event) : void {
    point.x = 0;
    point = localToGlobal(point);
    point = pyramyDepth.globalToLocal(point);

    var distance : Number = Math.abs(point.x);
    visible = distance < (200 + 50);

    if (!visible) {
      return;
    }

    var scale : Number = 1 - distance / 500;
    scaleX = scaleY = scale;


    if (distance < 25) {
      resort();
    }
  }

  private function resort() : void {
    if (topPhoto == this) {
      return;
    }
    topPhoto = this;
    parent.setChildIndex(this, parent.numChildren - 1);

    if (next) {
      next.setNextIndex(parent.numChildren - 2);
    }
    if (previous) {
      previous.setPreviousIndex(parent.numChildren - 3);
    }
  }

  private function setNextIndex(depth : int) : void {
    parent.setChildIndex(this, depth);
    if (next) {
      next.setNextIndex(depth - 1);
    }
  }

  private function setPreviousIndex(depth : int) : void {
    parent.setChildIndex(this, depth);
    if (previous) {
      previous.setPreviousIndex(depth - 1);
    }
  }
}