/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qeaw
 */

// forked from shaktool's flash on 2014-2-4
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.filters.*;
	import flash.text.*;
	[ SWF( width=465, height=465, backgroundColor=0, framerate=30 ) ]
	public class Distributor extends Sprite
	{
		private var size: Number = 465;
		private var turbulence: BitmapData = new BitmapData( NOISE_LENGTH, NOISE_LENGTH, false, 0 );
		private var canvas: Graphics;
		private var label: TextField;
		
		public function Distributor()
		{
			turbulence.perlinNoise( 32, 32, 4, Math.random()*int.MAX_VALUE, true, true, 3, false );
			
			
			var sprite: Sprite = new Sprite();
			addChild( sprite );
			canvas = sprite.graphics;
			
			//addChild(new Bitmap(turbulence));
			
			var format: TextFormat = new TextFormat();
			format.align = TextFormatAlign.LEFT;
			format.bold = true;
			format.font = "Arial";
			format.size = 20;
			
			label = new TextField();
			label.width = 400;
			label.x = 20;
			label.height = 100;
			label.y = 20;
			label.wordWrap = false;
			label.type = TextFieldType.DYNAMIC;
			label.textColor = 0x000000;
			label.selectable = false;
			label.mouseEnabled = false;
			label.defaultTextFormat = format;
			label.text = "";
			addChild( label );
			
			stage.addEventListener( MouseEvent.MOUSE_MOVE, reset );
			//stage.addEventListener( MouseEvent.CLICK, reset );
			//addEventListener( Event.ENTER_FRAME, reset );
			reset();
		}
		
		private function reset( event: Event = null ): void
		{
			canvas.clear();
			canvas.beginFill( 0xffffff );
			canvas.drawRect( 0, 0, size, size );
			canvas.endFill();
			
			var concentration: Number = 0.5;
			var offset: int = 18;//100 * ( mouseX / size );
			var offset2: int = 1000 * ( mouseY / size );
			
			for ( var i: int = 0; i < 32; i++ )
			{
				//var cx: Number = ( ( i * 0.61803398875 ) % 1.0 );
				//var cx: Number = ( ( i * 0.55523501234 ) % 1.0 );
				
				//x = permute( i );
				//var cx: Number = 
				//var cx: Number = x / 4294967296.0;
				var cx: Number = halton2( i + offset );
				var cy: Number = halton3( i + offset + offset2 );
				
				for ( var j: int = 0; j < 1; j++ )
				{
					var fx: Number = cx;
					var fy: Number = cy;
					canvas.beginFill( 0x000000 );
					canvas.drawCircle( cx * size, cy * size, 2 );
					canvas.endFill();
				}
			}
			
			label.text = offset+" "+offset2;
		}
	}
}

const WIDTH: int = 465;
const HEIGHT: int = 465;
const NOISE_LENGTH: int = 256;

function permute( x: uint ): uint
{
	x = ( x * x ) ^ 0x5bf03635;
	x = ( x * x ) % 4294967291;
	return x;
}
function halton3( x: uint ): Number
{
	var result: Number = 0.0;
	var f: Number = 1.0 / 3.0;
	var g: Number = f;
	while ( x > 0 )
	{
		var divisions: uint = x / 3;
		result += ( x - divisions * 3 ) * g;
		x = divisions;
		g *= f;
	}
	
	return result;
}
function halton2( x: uint ): Number
{
	x = ((x & 0xaaaaaaaa) >> 1) | ((x & 0x55555555) << 1);
	x = ((x & 0xcccccccc) >> 2) | ((x & 0x33333333) << 2);
	x = ((x & 0xf0f0f0f0) >> 4) | ((x & 0x0f0f0f0f) << 4);
	x = ((x & 0xff00ff00) >> 8) | ((x & 0x00ff00ff) << 8);
	return uint((x >> 16) | (x << 16)) / 4294967296.0;
}
