/**
 * Copyright itou_hiroki ( http://wonderfl.net/user/itou_hiroki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qeZ9
 */

// forked from 9re's 円を動かす
package {
	import flash.geom.PerspectiveProjection;
    import flash.display.*;
    import flash.events.Event;
    import flash.geom.Point;
 
    [SWF(frameRate="60", width="265", height="265")]
    public class MyFirstAnimation extends Sprite {
        //stage
        private var stg:Point = new Point(265,265);
        //移動距離
        public var vec:Point = new Point(1,1.5);
        private var _circle:Circle;
 
        public function MyFirstAnimation() {
            // クラスCircleのインスタンスを作る
            _circle = new Circle(
            20, //半径
            stg, //ステージ
            vec //移動距離
            );
            
            // 表示リストに追加
            addChild(_circle);
 
            // 1フレーム毎に実行する処理にenterFrameHandlerを追加する
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
 
        // フレーム毎に行われる処理 [25行目で登録される]
        private function enterFrameHandler(e:Event):void {
            // 1フレーム分動かす
            _circle.move();
        }
    }
}
 
import flash.display.Sprite;
import flash.geom.Point;

class Circle extends Sprite {
    private var radius:Number;
    private var vec:Point = new Point(); //移動距離
    private var stg:Point = new Point();
    private var direction:Point = new Point(1,1); //方向

    // コンストラクタ
    public function Circle(_radius:Number, _stage:Point, _vec:Point, _fillColor:uint = 0x000000) {
        // 塗り_fillColor, 半径_radiusの円
        graphics.beginFill(_fillColor);
        graphics.drawCircle(0, 0, _radius);
        graphics.endFill();
        // 最初の位置をセット
        x = _stage.x - _stage.x / 3;
        y = _stage.y / 3;
        // 半径の大きさをパブリックな変数に保存しておく
        radius = _radius;
        stg = _stage;
        vec = _vec;
    }
    // 1フレーム分の動き
    public function move():void {
        x += vec.x * direction.x;
        if(x<0 || x>stg.x){ direction.x *= -1; }
        
        y += vec.y * direction.y;
        if(y<0 || y>stg.y){ direction.y *= -1; }

        // 半透明(不透明度25%=0.25)
        alpha = (stg.y - y + 1) / stg.y;
    }
}