/**
 * Copyright milkmidi ( http://wonderfl.net/user/milkmidi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qeNV
 */

/**
 * PV3D Pivot example
 * http://milkmidi.blogspot.com
 */
package  {		
	import flash.events.Event;
	import org.papervision3d.cameras.CameraType;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.view.BasicView;	
	public class PivotExample2 extends BasicView {					
		private var _cube:Cube;
		public function PivotExample2()  {			
			super(0, 0, true, true, CameraType.TARGET);			
			camera.x = 200;
			camera.y = 200;
			init3DObject();
			startRendering();			
		}		
		
		private function init3DObject():void {							
			var _ml:MaterialsList = new MaterialsList( { all:new ColorMaterial(0x222222, .5) } )			
			_cube = new Cube(_ml, 300, 300, 300);			
			_cube.x = 300;
			scene.addChild(_cube);
			
			var _pivotOffset:int = 500;
			for each (var v:Vertex3D in _cube.geometry.vertices) {				
				v.x += _pivotOffset;
				v.y += _pivotOffset;
				v.z += _pivotOffset;
			}
			scene.addChild( new Axes3D());
		}
		override protected function onRenderTick(event:Event = null):void {
			_cube.localRotationY++;
			super.onRenderTick(event);
		}
	}	
}

    import org.papervision3d.core.geom.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.objects.*;
    class Axes3D extends DisplayObject3D {
        public function Axes3D() {
            var _lines3D:Lines3D = new Lines3D();
            var _red	:LineMaterial = new LineMaterial(0xff0000);
            var _green	:LineMaterial = new LineMaterial(0x00ff00);
            var _blue	:LineMaterial = new LineMaterial(0x0000ff);
            var _length	:uint = 120;
            var _lineX	:Line3D = new Line3D(_lines3D, _red, 2, new Vertex3D(-_length, 0, 0), new Vertex3D(_length, 0, 0));
            var _lineY	:Line3D = new Line3D(_lines3D, _green, 2, new Vertex3D(0, -_length, 0), new Vertex3D(0, _length, 0));
            var _lineZ	:Line3D = new Line3D(_lines3D, _blue, 2, new Vertex3D(0, 0, -_length), new Vertex3D(0, 0, _length));
            _lines3D.addLine(_lineX);
            _lines3D.addLine(_lineY);
            _lines3D.addLine(_lineZ);
            addChild(_lines3D);            
        }
    }