/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qdVy
 */

package {
    import flash.display.Sprite;
    [SWF(frameRate=60,width=456,height=456)]
    public class FakeStage extends Sprite {
        public function FakeStage() {
            // write as3 code here..
            
            Vars.W = stage.stageWidth;
            Vars.H = stage.stageHeight;
            
            graphics.beginFill(0);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            graphics.endFill();      
            
            addChild(new Main());
            
            
        }
    }
}
import flash.display.Graphics;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;
import flash.display.DisplayObjectContainer;
import flash.display.DisplayObject;
import flash.events.Event;
import flash.display.Sprite;
import com.bit101.components.*;



///Change style
Style.BACKGROUND = 0x444444;
Style.BUTTON_FACE = 0x666666;
Style.INPUT_TEXT = 0xBBBBBB;
Style.LABEL_TEXT = 0xCCCCCC;
Style.PANEL = 0x666666;
Style.PROGRESS_BAR = 0x666666;

class Vars 
{
    ///Two PI
    public static var PI2:Number = 6.283;
    
    
    ///**
    ///UI
    ///    User interface default num of points.
    public static var UIPN:uint = 4;
    ///    User Interface max num of points.
    public static var UIPM:uint = 20;
    ///    User interface default value of radius.
    public static var UIRD:uint = 80;
    ///    User Interface radius max.
    public static var UIRMx:Number = 140;
    ///    User Interface radius min.
    public static var UIRMn:Number = 20;
    ///    User Interface Points Visible
    public static var UIPV:Boolean = false;
    
    ///*****
    ///STAGE
    ///    Stage Width
    public static var W:Number = 0;
    ///    Stage Height
    public static var H:Number = 0;
    
    ///**********
    ///Draw Style
    ///
    ///    Draw Line Thikness
    public static var DLT:Number = 8;
    ///    Draw Line Color.
    public static var DLC:uint = 0xFFAA00;
    ///    Draw Cirlce Radius
    public static var DCR:int = 8;
    ///    Draw invert
    public static var DI:Boolean = true;
    
    
    ///**********************
    ///Moving circle defaults
    ///    Random moving radius (Moving Circle Random Dist)
    ///        Value
    public static var MCRD:Number = 20;
    ///        Default
    public static var MCRDD:Number = 20;
    ///        Max
    public static var MCRDMx:Number = 50;
    ///        Min
    public static var MCRDMn:Number = 5;
    ///    Circle animation frequency (Moving Circle Animation Frequency)
    ///        Value
    public static var MCAF:Number = 0.15;
    ///        Default
    public static var MCAFD:Number = 0.15;
    ///        Min
    public static var MCAFMn:Number = 0.01;
    ///        Max
    public static var MCAFMx:Number = .6;
}


class Main extends Sprite
{
    private var m:UIMenu;
    
    public function Main()
    {
        m = new UIMenu();
        addChild(m);
    }
    
    
    /*
    private function init(e:Event):void
    {
        removeEventListener(Event.ADDED_TO_STAGE,init);
        addEventListener(Event.ENTER_FRAME,loop);
    }
    private function get b():Body
    {
        return m.b as Body;
    }
    private function loop(e:Event):void
    {
        b.y = Math.min( 
           Math.max( mouseY , b.radius * 1.5 + m.height),
           Vars.H - b.radius * 1.5
        );
        b.x = Math.min(
            Math.max(mouseX,b.radius * 1.5),
            Vars.W - b.radius * 1.5
        ); 
    }*/
}

class UIMenu extends Sprite
{
    public var b:Body;
    
    private var sliderPoints:HUISlider;
    private var sliderRadius:HUISlider;
    private var btnDefault:PushButton;
    private var cbPointsVisible:CheckBox;
    private var sliderAnimationFrequency:HUISlider;
    private var sliderMoveRadius:HUISlider;
    private var cbMode:CheckBox;
    
    public function UIMenu():void
    {
        //Style.setStyle(Style.DARK);   
        
        addEventListener(Event.ADDED_TO_STAGE,init);
    }
    private function init(e:Event):void
    {
        removeEventListener(Event.ADDED_TO_STAGE,init);
        
        //Set up menus 
        initUI();
        
        //Load body of points.
        initBody();
    }
    private function initUI():void
    {
        //Num of points slider.
        sliderPoints = new HUISlider(this,5,5,"Points:", initBody);
        sliderPoints.value = Vars.UIPN;
        sliderPoints.tick = 1;
        sliderPoints.maximum = Vars.UIPM;
        sliderPoints.minimum = 3;
        
        //Radius Slider
        sliderRadius = new HUISlider(this,5,sliderPoints.height + 10,"Radius:", initBody);
        sliderRadius.value = Vars.UIRD;
        sliderRadius.tick = 1;
        sliderRadius.maximum = Vars.UIRMx;
        sliderRadius.minimum = Vars.UIRMn;
        
        //Reset all settings to default
        btnDefault = new PushButton(this,sliderPoints.width + 10,5,"Reset",onDefault);
        
        //Make points visible / invisible
        cbPointsVisible = new CheckBox(this,sliderPoints.width + 10,btnDefault.height + 10,"Points Visible",initBody);
        cbPointsVisible.selected = Vars.UIPV;
        
        //Animation frequency
        sliderAnimationFrequency = new HUISlider(this,5,sliderRadius.y + sliderRadius.height + 5,"Frequency", cngFreq);
        sliderAnimationFrequency.tick = 0.01;
        sliderAnimationFrequency.value = Vars.MCAFD;
        sliderAnimationFrequency.minimum = Vars.MCAFMn;
        sliderAnimationFrequency.maximum = Vars.MCAFMx;
        sliderAnimationFrequency.width /= 1.2;
        sliderAnimationFrequency.labelPrecision = 2;
        
        sliderMoveRadius = new HUISlider(
            this,
            sliderAnimationFrequency.width,
            sliderRadius.y + sliderRadius.height + 5,
            "Points Radius",
            cngPRad
         );
         
        sliderMoveRadius.tick = 1;
        sliderMoveRadius.value = Vars.MCRDD;
        sliderMoveRadius.minimum = Vars.MCRDMn;
        sliderMoveRadius.maximum = Vars.MCRDMx;
        
        //Mode toogle
        cbMode = new CheckBox(
            this,
            5,
            sliderAnimationFrequency.y + sliderAnimationFrequency.height + 10,
            "Complex?",
            toogleMode
        );
        cbMode.selected = !Vars.DI;
        
        ///MCRDD
        
        this.scaleY = this.scaleX = 1.3;
        
    }

    public function initBody(e:Event = null):void
    {
        newBody(sliderPoints.value,sliderRadius.value,cbPointsVisible.selected);
    }
    
    private function onDefault(e:Event):void
    {   
        Vars.MCRD = sliderMoveRadius.value = Vars.MCRDD;
     
        Vars.MCAF = sliderAnimationFrequency.value = Vars.MCAFD;
        
        Vars.DI = false;
        cbMode.selected = true;
        
        sliderPoints.value = Vars.UIPN;
        sliderRadius.value = Vars.UIRD;
        newBody(Vars.UIPN,Vars.UIRD,false);
    }

    
    private function newBody(points:uint,radius:Number,visible:Boolean = true):void
    {
        
        if(b) parent.removeChild(b);
        b = new Body(points,radius,visible);
        parent.addChild(b);
    }
    
    private function cngFreq(e:Event):void
    {
        Vars.MCAF = sliderAnimationFrequency.value;
    }
    
    private function cngPRad(e:Event):void
    {
        Vars.MCRD = sliderMoveRadius.value;
        
        initBody();
    }
    
    private function toogleMode(e:Event):void
    {
        Vars.DI = !Vars.DI;
    }





}


class Body extends Sprite
{
    //debug
    private var pa:Label;
    private var pb:Label;
    private var pc:Label;
    private var pd:Label;
    private function initDebug():void
    {
        pa = newP("A");
        pb = newP("B");
        pc = newP("C");
        pd = newP("D");
    }
    private function newP(l:String):Label
    {
        var lbl:Label = new Label(this,-1000,-1000,l);
        lbl.graphics.beginFill(0xFF0000,.4);
        lbl.graphics.drawCircle(5,8,10);
        lbl.graphics.endFill();
        return lbl;
    }


    
    
    
    private var ccls:Vector.<MvCcl>;  
    private var v:Boolean;
    
    
    public var radius:Number;
    
    public function Body(value:uint,radius:Number,visible:Boolean)
    {
        //Temp
        initDebug();

        
        ccls = new Vector.<MvCcl>(value,true);
        
        v = visible;
        this.radius = radius;
        
        var xPos:Number, yPos:Number, a:Number;
        var alpha:Number = Vars.PI2 / ccls.length;
        
        for(var i:int = ccls.length - 1; i >= 0; i--)
        {
            a = alpha * i;
            
            xPos = radius * Math.cos(a);
            yPos = radius * Math.sin(a);
            
            ccls[i] = v ? addChild(new MvCcl(xPos,yPos)) as MvCcl : new MvCcl(xPos,yPos);
            ccls[i].beta = a;
            ccls[i].char = i.toString();
        }
        
        this.x = Vars.W / 2;
        this.y = radius > 100 ? Vars.H - radius * 1.3 : Vars.H / 2
        
        addEventListener(Event.ENTER_FRAME,loop);
    }
    public function loop(e:Event):void
    {
        var r:Number = Vars.DI ? radius * 5 / 6 : radius * 6 / 5;
        var a:Number;
        var g:Graphics = graphics;
        g.clear();   
        g.lineStyle(radius / 12,Vars.DLC);
        
        g.beginFill(Vars.DLC,.5);
        a = ccls[1].beta - ccls[0].beta;
         
        for(var i:int = 0; i < ccls.length; i++)
        {
            if(Vars.DI)
            {
                if( i == 0 )
                {
                    g.moveTo(  Math.cos(a / 2) * r,
                               Math.sin(a / 2) * r);
                } else if ( i == ccls.length - 1) 
                {
                    g.curveTo(
                        ccls[i].x,
                        ccls[i].y,
                        Math.cos(a * i + a / 2) * r,
                        Math.sin(a * i + a / 2) * r
                        
                    );

                    g.curveTo(
                        ccls[0].x,
                        ccls[0].y,
                        Math.cos(a / 2) * r,
                        Math.sin(a / 2) * r
                    );
                } else {
                    g.curveTo(
                        ccls[i].x,
                        ccls[i].y,
                        Math.cos(a * i + a / 2) * r,
                        Math.sin(a * i + a / 2) * r 
                    );
                }
            } 
            else 
            {   
                if(i == ccls.length - 1) 
                {             
                    g.curveTo(
                        Math.cos(a * i - a / 2) * r,
                        Math.sin(a * i - a / 2) * r,
                        ccls[i].x,
                        ccls[i].y
                    );
                    g.curveTo(
                        Math.cos(a * i + a / 2) * r,
                        Math.sin(a * i + a / 2) * r,
                        ccls[0].x,
                        ccls[0].y
                    );
                } else if(i == 0)
                {
                    g.moveTo(ccls[i].x,ccls[i].y);   
                } else {                    
                    g.curveTo(
                        Math.cos(a * i - a / 2) * r,
                        Math.sin(a * i - a / 2) * r,
                        ccls[i].x,
                        ccls[i].y
                    );                
                }
            }
        }
        
        g.endFill();
    }


}



class Ccl extends Sprite
{
    private var l:Label;
    
    public function Ccl()
    {
        l = new Label(this,-4.5,-9,"1");
        this.graphics.beginFill(0xFF0000,.7);
        //this.graphics.lineStyle(Vars.DLT,0xFFFFFF);
        this.graphics.drawCircle(0,0,Vars.DCR);
        this.graphics.endFill();
    }
    
    public function set char(value:String):void
    {
        l.text = String(value).toUpperCase();
    }

}

class MvCcl extends Ccl
{
    
    
    //Theta
    private var th:Number;
    
    //Animation circle bounds 
    private var w:Number;
    private var h:Number;
    
    //Control point.
    private var cX:Number;
    private var cY:Number;
    
    //Super position
    private var x2:Number;
    private var y2:Number;
    public var beta:Number;
    
    
    //The distance from control point.
    public function MvCcl(x:Number,y:Number)
    {
        cX = x;
        cY = y;    
        
        x2 = 0;
        y2 = 0;
        
        w = Vars.MCRD * Math.random();
        h = Vars.MCRD * Math.random();
        
        th = Math.random() * Vars.PI2;
        
        //filters = [new GlowFilter(Vars.DLC,.8,6,6,4)];
        
        addEventListener(Event.ENTER_FRAME,loop);
    }
    public function loop(e:Event):void
    {
        th += Vars.MCAF;
        super.x = Math.cos(th) * w + cX + x2;
        super.y = Math.sin(th) * h + cY + y2;
    }
    override public function set x(value:Number):void
    {x2 = value;}    
    override public function set y(value:Number):void
    {y2 = value;}
}