/**
 * Copyright Fricks ( http://wonderfl.net/user/Fricks )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qcu4
 */

package {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.Graphics;
    import flash.geom.Point;
    import flash.events.Event;
    public class FlashTest extends Sprite {
        
        private var sw:Number = stage.stageWidth;
        private var sh:Number = stage.stageHeight;
        private var cx:Number = sw/2;
        private var cy:Number = sh/2;
        private var shape:Shape;
        private var g:Graphics;
        private var ary:Array;
        private var cn:Number = Math.floor(Math.random()*9)+3;
        private var cDeg:Number = 360/cn;
        private var degree:Number = 0.;
        private var ragian:Number = 0.;
        
        public function FlashTest() {
            // write as3 code here..
            init();
        }
        
        private function init(){
            ary = new Array();
            var fpx = Math.random()*cx;
            var fpy = Math.random()*cy;
            var r =  Math.pow(Math.pow(fpx-cx,2)+Math.pow(fpy-cy,2),0.5);
            var fDeg = Math.atan2(fpy-cy,fpx-cx)*180/Math.PI;
            for (var i=0;i<cn;i++){
                var pRag = (fDeg+cDeg*i)/180*Math.PI;
                var px = r*Math.cos(pRag)+cx;
                var py = r*Math.sin(pRag)+cy;
                var p:Point = new Point(px,py);
                ary.push(p);
            }
            shape = new Shape();
            addChild(shape);
            g = shape.graphics;
            addEventListener(Event.ENTER_FRAME,upDate);
        }
        
        private function upDate(e:Event){
            g.clear();
            g.lineStyle(1,0xFF0000);
            g.beginFill(0x0000FF);
            ragian = (degree/180)*Math.PI;
            
            var opx = 0;
            var opy = 0;
            for(var i=0;i<cn;i++){
                var px = ((ary[i].x-cx)*Math.cos(ragian)-(ary[i].y-cy)*Math.sin(ragian))+cx;
                var py = ((ary[i].x-cx)*Math.sin(ragian)+(ary[i].y-cy)*Math.cos(ragian))+cy;
                //ary[i].x = px;
                //ary[i].y = py;
                if(i == 0){
                    g.moveTo(px,py);
                    opx = px;
                    opy = py;
                }else if(i != cn-1){
                    g.lineTo(px,py);
                }else{
                    g.lineTo(px,py);
                    g.lineTo(opx,opy);
                }
            }
            degree+=0.1;
            if(degree > 360){
                degree = 0;
            }
        }
    }
}