/**
 * Copyright tamac124 ( http://wonderfl.net/user/tamac124 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qcLm
 */

// forked from nappingjellyfish's Lightning
package {
	/***********************
	* 雷っぽい物
	************************/
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;
	import flash.filters.GlowFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.utils.Timer;
    import flash.display.Sprite;
	/**
	 * ...
	 * @author Njf
	 */
    [SWF (backgroundColor = "0x404040", frameRate = "30", width = "465", height = "465")]
	public class ThunderMain extends MovieClip
	{

		private static const STAGE_Y:int = 465;
		private static const STAGE_X:int = 465;
		private var branchArray:Array = new Array();
		private var frameCnt:int = 0;
		private var zanzouBmpData:BitmapData = new BitmapData(STAGE_X, STAGE_Y, true, 0x00000000);
		private var zanzouBmp:Bitmap = new Bitmap(zanzouBmpData);
		private var zanzouCt:ColorTransform = new ColorTransform(1, 1, 1, 0.8);
		private var zanzouRect:Rectangle = new Rectangle(0, 0, STAGE_X, STAGE_Y);
		
		
		/****************
		 * コンストラクタ
		 * **************/
		public function ThunderMain() 
		{
			super();
			addEventListener(Event.ENTER_FRAME, onEnterFrameHaneler);
			parent.addChild(zanzouBmp);
			var bf:BlurFilter = new BlurFilter(2, 2);
			var gf:GlowFilter = new GlowFilter(0x2222FF, 0.7, 30, 30, 3, 1);
			filters = [bf,gf,gf];
		}
		/****************
		  * On enter Frame
		  * **************/
		 private function onEnterFrameHaneler(e:Event):void 
		 {
			 zanzou();
			 var interval:int = 20;
			 if (frameCnt % interval == 0) {
				 thunderReWrite();
			 }else if(frameCnt%interval==1)
			 {
				graphics.clear();
			 }
			 frameCnt++;
		 }
		
		/****************
		 * 残像
		 * **************/
		private function zanzou():void 
		{
			zanzouBmpData.draw(this);
			zanzouBmpData.colorTransform(zanzouRect, zanzouCt);
		}

		/****************
		 * 雷描画
		 * **************/
		private function thunderReWrite():void 
		{
			graphics.clear();
			var startPoint:branchData = new branchData();
			startPoint.endPt.x = mouseX;
			startPoint.endPt.y = mouseY;
			startPoint.lineWidth = 13;
			startPoint.startPt.x = 0;
			startPoint.startPt.y = 0;
			branchArray.push(startPoint);
			
			while (branchArray.length > 0) 
			{
				var tmp:branchData = branchArray.pop();
				thunder(this,tmp.lineWidth,tmp.startPt,tmp.endPt);
			}
			
		}
		
		/****************
		 * メイン
		 * **************/
		private function thunder(drawMc:MovieClip,lw:int,startPt:Point,distPt:Point):void 
		{
			var gr:Graphics = drawMc.graphics;
			var dPt:Point = new Point();
			var pitch:int = 20;
			gr.moveTo(startPt.x, startPt.y);
			//trace(startPt);
			var len:Number = distPt.length;
			var directPt:Point = distPt.clone();
			var drawTimes:int = len / pitch;
			var branchPitch:Number = lw/drawTimes;
			var lineWidth:int = lw;
			var nowPt:Point = startPt.clone();
			
			for (var i:int = 0; i < drawTimes; i++) 
			{
				gr.lineStyle(lineWidth, 0xFFFFFF,1,false,"normal","square");
				var r:Number = (0.5 - Math.random()) * 2;
				dPt.x = directPt.y * r;
				dPt.y = -directPt.x * r;
				dPt = dPt.add(directPt);
				var ptR:Number = Math.random()*2;
				dPt.normalize(pitch * ptR );

				if (Math.random() <= branchPitch*2) {
					var branchWidth:Number = Math.random() * lineWidth;
					lineWidth -= branchWidth/20;
					var bd:branchData = new branchData();
					bd.startPt.x = nowPt.x;
					bd.startPt.y = nowPt.y;
					var bdMulti:Number = 6;
					bd.endPt.x = dPt.x * branchWidth * bdMulti;
					bd.endPt.y = dPt.y * branchWidth * bdMulti;
					bd.lineWidth = branchWidth;
					branchArray.push(bd);
					if (lineWidth < 0) lineWidth = 0;
				}
				
				
				nowPt=nowPt.add(dPt);
				gr.lineTo(nowPt.x,nowPt.y );
			}
		}
		 
		 
	}
}
import flash.geom.Point;
class branchData {
	public var startPt:Point = new Point();
	public var endPt:Point = new Point();
	public var lineWidth:int = 0;
	
	
}
