/**
 * Copyright yotsu42keisuke ( http://wonderfl.net/user/yotsu42keisuke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qb58
 */

// forked from zonnbe's music chaser
package
{
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    import flash.display.Sprite;
    import flash.net.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.ui.*;
    import flash.media.*;
    import flash.utils.*;
    import flash.system.*;
    import frocessing.color.ColorHSV;
    import net.hires.debug.Stats;
    
    [SWF(width=465,height=465,backgroundColor=0x333333,frameRate=60)]
    public class musicChaser2D extends Sprite
    {
        private var bmpd                :BitmapData     = new BitmapData(stage.stageWidth, stage.stageHeight);
        private var cbmpd               :BitmapData     = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x0);
        private var bmp                 :Bitmap         = new Bitmap(bmpd);
        
        private var m_blts              :Array          = new Array();
        private var m_bltCount          :int            = 256;
        private var m_maxbltRotateSpeed :Number         = 100;
        private var m_bltRotateSpeed    :Number         = 10;
        private var m_bltMoveSpeed      :Number         = 10;
        private var m_fcount            :int            = 1;
        private var m_counter           :int            = 0;
        private var m_mode              :int            = 0;
        private var m_modeTotal         :int            = 4;
        
        private var target              :Dot            = new Dot(stage.stageWidth/2, stage.stageHeight/2);
        private var newloc              :Dot            = new Dot(stage.stageWidth/2, stage.stageHeight/2);
        
        private var snd                 :Sound;
        private var FFTswitch           :Boolean        = false;
        private var byteArray           :ByteArray      = new ByteArray();
        private var detectSound         :int            = 512;
        private var byteTotal           :Number         = 0;
        
        private var vcolor              :ColorHSV       = new ColorHSV(0,0.6,1,0.7);
        private var ct                  :ColorTransform = new ColorTransform(1,1,1,0.999);
        private var ct2                 :ColorTransform = new ColorTransform(1,1,1,0.9);
        private var fill_rect           :Rectangle      = new Rectangle(0,0,5,5);
        
        public function musicChaser2D()
        {
            addChild(new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x333333)));
            addChild(bmp);
            addChild(new Bitmap(cbmpd));
            addChild(new Stats());
            var i:int = 0;
            
            for(i = 0; i < m_bltCount; i++)
            {
                m_blts.push(new Dot(0, 0));
            }
            init();
            playSound("http://our-work.com.my/livetesting/sound003.mp3");
            stage.addEventListener(Event.ENTER_FRAME, processing);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onmouseDown);
        }
        
        private function playSound(sndUrl:String):void
        {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(10,true);
            var req:URLRequest = new URLRequest(sndUrl);
            var sndChannel:SoundChannel=new SoundChannel();
            snd.load(req, context);
            sndChannel = snd.play(0, 9999);
        }
        
        public function onmouseDown(e:MouseEvent):void
        {
            if(++m_mode>=m_modeTotal)
                        m_mode = 0;
        }
        
        public function init():void
        {
            var i:int = 0;
            for(i = 0; i < m_bltCount; i++)
            {
                m_blts[i].lx = stage.stageWidth/2;
                m_blts[i].ly = 400;
                m_blts[i].vx = -Math.cos(Math.PI/(m_bltCount-1)*i);
                m_blts[i].vy = -Math.sin(Math.PI/(m_bltCount-1)*i);
                m_blts[i].x = stage.stageWidth/2;
                m_blts[i].y = 400;
            }
        }
        
        public function update():void
        {
            SoundMixer.computeSpectrum(byteArray, FFTswitch, 0);            
            var i:int = 0;
            var tvx:Number = 0;
            var tvy:Number = 0;
            var tatan2:Number = 0;
            var bvx:Number = 0;
            var bvy:Number = 0;
            var batan2:Number = 0;
            var targetrad:Number = 0;
            var bltrad:Number = 0;
            var radDist:Number = 0;
            
            for(i = 0; i < detectSound; i++)
            {
                byteTotal += byteArray.readFloat();
            }
            byteTotal/=512;
            m_bltMoveSpeed = 3 + m_maxbltRotateSpeed * Math.abs(byteTotal);
            
            if(Math.abs(byteTotal)>0.1 && Math.random() * Math.random() > 0.5)
            {
                m_mode = Math.random() * 4;
            }
            if(Math.abs(byteTotal)>0.1)
            {
                newloc.x = 100 + Math.random() * 265;
                newloc.y = 100 + Math.random() * 265;
            }
            target.x -= (target.x - newloc.x) * 0.33;
            target.y -= (target.y - newloc.y) * 0.33;
            
            for(i = 0; i < m_bltCount; i++)
            {
                tvx = m_blts[i].x - target.x;
                tvy = m_blts[i].y - target.y;
                targetrad = Math.atan2(tvy, tvx);
                bltrad = Math.atan2(m_blts[i].vy, m_blts[i].vx);
                radDist = targetrad-bltrad;
                
                if(radDist>Math.PI)
                {
                    radDist-=Math.PI*2;
                }
                if(radDist<-Math.PI)
                {
                    radDist+=Math.PI*2;
                }
                if(radDist>0)
                {
                    if(m_mode == 1)
                        bltrad += m_bltRotateSpeed * Math.PI / 180; //// mode 1
                }
                if(radDist<0)
                {
                    if(m_mode == 1)
                        bltrad -= m_bltRotateSpeed * Math.PI / 180; //// mode 1
                }
                
                if(m_mode == 0)
                    bltrad -= -radDist * 0.133; //// mode 0
                if(m_mode == 2)
                    bltrad -= radDist * 0.133; //// mode 2
                if(m_mode == 3)
                    bltrad -= radDist * 0.333;
                m_blts[i].lx = m_blts[i].x;
                m_blts[i].ly = m_blts[i].y;
                
                m_blts[i].vx = Math.cos(bltrad);
                m_blts[i].vy = Math.sin(bltrad);
                
                if(m_mode == 0 || m_mode == 1)
                    m_blts[i].add_p_(-m_blts[i].vx*m_bltMoveSpeed, -m_blts[i].vy*m_bltMoveSpeed);//// mode 0, 1
                if(m_mode == 2 || m_mode == 3)
                    m_blts[i].add_p_(m_blts[i].vx*m_bltMoveSpeed, m_blts[i].vy*m_bltMoveSpeed);//// mode 2
            }
        }
        
        public function paint():void
        {
            bmpd.colorTransform(bmpd.rect, ct);
            var i:int = 0;
            
            for(i = 0; i < m_bltCount; i++)
            {
                vcolor.h = getTimer()/10;
                lineFast(bmpd, m_blts[i].lx, m_blts[i].ly, m_blts[i].x, m_blts[i].y, vcolor.value32);
            }
            
            var color:uint = 0x0;
            cbmpd.colorTransform(cbmpd.rect, ct2);
            dp(cbmpd, target.x, target.y, 0xFFFF5511);
            for(i = 0; i < 4; i++)
            {
                color = (i==m_mode)?0xFFFFFFFF:0xFFAAAAAA;
                fill_rect.x = stage.stageHeight - 14 +    (i%2) * 7;
                fill_rect.y = stage.stageHeight - 14 + int(i/2) * 7;
                cbmpd.fillRect(fill_rect, color);
            }
        }
        
        public function processing(e:Event):void
        {
            if(m_counter++==m_fcount)
            {
                update();
                m_counter=0;
            }
            paint();
        }
        
        public function dp(target:BitmapData, px:int, py:int, color:uint):void
        {
            lineFast(target, px-3, py-3, px+3, py+3, color);
            lineFast(target, px-3, py+3, px+3, py-3, color);
        }
        
        public function lineFast(target:BitmapData, x0:int, y0:int, x1:int, y1:int, color:uint):void
        {    
            var pix      :uint = color;
            var dy       :int = y1 - y0;
            var dx       :int = x1 - x0;
            var stepx    :int;
            var stepy    :int;
            var fraction :int;
            
            if (dy < 0) { dy = -dy;  stepy = -1; } else { stepy = 1; }
            if (dx < 0) { dx = -dx;  stepx = -1; } else { stepx = 1; }
            dy <<= 1;
            dx <<= 1;
            target.setPixel32(x0, y0, pix);
            if (dx > dy)
            {
                fraction = dy - (dx >> 1);
                while (x0 != x1)
                {
                    if (fraction >= 0)
                    {
                        y0 += stepy;
                        fraction -= dx;
                    }
                    x0 += stepx;
                    fraction += dy;
                    target.setPixel32(x0, y0, pix);
                }
            } else {
                fraction = dx - (dy >> 1);
                while (y0 != y1)
                {
                    if (fraction >= 0)
                    {
                        x0 += stepx;
                        fraction -= dy;
                    }
                    y0 += stepy;
                    fraction += dx;
                    target.setPixel32(x0, y0, pix);
                }
            }
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.system.Capabilities;
import flash.system.System;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.utils.getTimer;

class Dot
{
    public var x:Number = 0;
    public var y:Number = 0;
    public var tx:Number = 0;
    public var ty:Number = 0;
    public var lx:Number = 0;
    public var ly:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var angle:Number = 0;
    public var size:Number = 0;
    public var speed:Number = 0;
    public var m:Number = 0;
    public var rad:Number = 0;

    public function Dot(px:Number,py:Number)
    {
        x = px;
        y = py;
        tx = x;
        ty = y;
    }
    
    public function val_(p:Dot):Dot
    {
        x = p.x;
        y = p.y;
        return this;
    }
    
    public function val_p_(px:Number, py:Number):Dot
    {
        x = px;
        y = py;
        return this;
    }
    
    public function add_(p:Dot):Dot
    {
        x += p.x;
        y += p.y;
        return this;
    }
    
    public function add_p_(px:Number, py:Number):Dot
    {
        x += px;
        y += py;
        return this;
    }
}