/**
 * Copyright Gleb.Panteleew ( http://wonderfl.net/user/Gleb.Panteleew )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qakP
 */

// forked from aomoriringo's 2001年宇宙の旅的な
/*

=========音がでます注意してください=============

2001年宇宙の旅っぽくしてみたかったんです。
他に考えつかなかったのでwonderflの宣伝にしてみました。

音源は映画と同じカラヤン指揮ウィーン・フィル1959年。
演奏から50年経っているのでパブリック・ドメインだと思うのですが。
ダメだったらすぐ削除します
*/

package
{
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.geom.ColorTransform;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.core.effects.BitmapColorEffect;
    import org.papervision3d.core.effects.BitmapLayerEffect;
    import org.papervision3d.core.effects.utils.BitmapClearMode;
    import org.papervision3d.core.effects.utils.BitmapDrawCommand;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.shaders.PhongShader;
    import org.papervision3d.materials.shaders.ShadedMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.view.layer.BitmapEffectLayer;

    [SWF(width=465, height=465, frameRate=30, backgroundColor=0x000000)]

    public class wonderfl0002_2001 extends Sprite
    {
        public static const CAMERA_DISTANCE:uint = 2000;

        private var camera:Camera3D;
        private var renderer:BasicRenderEngine;
        private var scene:Scene3D;
        private var viewport:Viewport3D;
        private var root3d:DisplayObject3D;
        
        private var earth:Sphere;
        private var bmdEarth:BitmapData;
        private var earthColor:Number = 1;        
        private var moon:Sphere;
        private var sun:Sphere;
        
        private var textFields:Array;
        private var sound:Sound;
        private var curtain:Sprite;
        private var sc:SoundChannel;
        
        public function wonderfl0002_2001()
        {
            addEventListener(Event.ADDED_TO_STAGE, initialize);
        }

        private function initialize(evt:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, initialize);

            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.HIGH;
            stage.scaleMode = StageScaleMode.NO_SCALE;

            setupPV3D();

            createEarth();
            createMoon();
            createSun();            
            createTextField();
            createCurtain();

            // BGMの読み込み
            sound = new Sound();    
            sound.addEventListener(Event.COMPLETE, playSound);
            sound.load(new URLRequest("http://iplextra.u-aizu.ac.jp/matsu/aomoringo/2001.mp3"));
            
            
        }

        // BGMの再生
        private function playSound(e:Event):void{
            sound.removeEventListener(Event.COMPLETE, playSound);
            sc = sound.play();
            
            addEventListener(Event.ENTER_FRAME, step);            
        }

        private function setupPV3D():void
        {
            camera = new Camera3D();
            camera.zoom = 1.5;
            camera.focus = 200;
            camera.target = DisplayObject3D.ZERO;

            renderer = new BasicRenderEngine();
            scene = new Scene3D();
            viewport = new Viewport3D(465, 465, true);
            addChild(viewport);

            root3d = new DisplayObject3D();
            scene.addChild(root3d);
        }

        //地球(一番手前)
        private function createEarth():void
        {
            var light:PointLight3D = new PointLight3D();
            light.y = 50;
            light.z = -0.1;
            
            // 時間の遷移と共に暗くしていくために  bmdEarth はグローバルで宣言
            bmdEarth = new BitmapData(465, 465, true, 0);
            bmdEarth.perlinNoise(465/8, 465/8, 8, 10, true, true, BitmapDataChannel.BLUE);
            bmdEarth.colorTransform(bmdEarth.rect, new ColorTransform(0.4,0.4,1,1));
            
            var mat:BitmapMaterial = new BitmapMaterial(bmdEarth);
            var shader:PhongShader = new PhongShader(light, 0xffffff, 0x000000, 8);
            
            earth = new Sphere( new ShadedMaterial(mat, shader) , 750 , 32, 24);
            earth.y = -400;
            earth.useOwnContainer = true;
            earth.filters = [
                new GlowFilter(0x0000ff, .1, 32, 32, 2),
            ];
            earth.rotationX = 90;
            root3d.addChild(earth);
        }

        //月(真ん中)
        private function createMoon():void
        {
            var light:PointLight3D = new PointLight3D();

            light.y = 300;
            light.z = 310;
            var bmd:BitmapData = new BitmapData(465, 465, true, 0);
            bmd.perlinNoise(465/8, 465/8, 8, 10, true, true);
            
            var mat:BitmapMaterial = new BitmapMaterial(bmd);
            var shader:PhongShader = new PhongShader(light, 0xffffff, 0x000000, 10);
            
            moon = new Sphere( new ShadedMaterial(mat, shader), 350 , 32, 24);
            moon.z = 300;
            moon.useOwnContainer = true;
            moon.filters = [
                new GlowFilter(0xffffff, .1, 50, 50, 2),
            ];
            root3d.addChild(moon);
        }

        //太陽(一番奥)
        private function createSun():void
        {    
            var mat:ColorMaterial = new ColorMaterial(0xFFFFFF,1);
            
            var bfx:BitmapEffectLayer = new BitmapEffectLayer(viewport, stage.stageWidth, stage.stageHeight, true, 0, BitmapClearMode.CLEAR_PRE);
            bfx.addEffect(new BitmapLayerEffect(new BlurFilter(5, 5, 1)));
            //bfx.addEffect(new BitmapLayerEffect(new GlowFilter(0xFF0000, 1, 0.01, 0.01, 0.1)));
            bfx.addEffect(new BitmapColorEffect(0.99, 0.7, 0.7, 0.99));
            bfx.drawCommand=new BitmapDrawCommand(null, new ColorTransform(1, 0.5, 0.4, 0.45), BlendMode.ADD);
            bfx.drawLayer.blendMode=BlendMode.OVERLAY;
            viewport.containerSprite.addLayer(bfx);
            
            sun = new Sphere(mat, 100 ,32, 24);
            sun.z = 600;
            sun.y = 350;
           
           bfx.addDisplayObject3D(sun);
            
            sun.useOwnContainer = true;
            root3d.addChild(sun);
        }
        
        private function createTextField():void
        {
            var format:TextFormat = new TextFormat();
            format = new TextFormat("Microsoft Sans Serif", 20);
            format.align = TextFormatAlign.CENTER;
            format.color = 0xFFFFFF;
            
            textFields = new Array(5);
            var texts:Array = ["KAYAC Inc.","PRESENTS","A KAYAC PROJECT PRODUCTION","wonderfl", "build Flash online"];
            var textSize:Array = [20, 10, 20, 50, 20];
            var textY:Array = [300, 330, 300, 300, 355];
                        
            for(var i:int=0 ; i<5 ; i++){
                textFields[i] = new TextField();
                textFields[i].text = texts[i];
                textFields[i].visible = false;
                textFields[i].width = 465;
                textFields[i].y = textY[i];
                format.size = textSize[i];
                textFields[i].setTextFormat(format);
                this.addChild(textFields[i]);
            }
         }
        
        private function createCurtain():void{
            curtain = new Sprite();
            curtain.graphics.beginFill(0x000000,1);
            curtain.graphics.drawRect(0,0,465,465);
            curtain.graphics.endFill();
            curtain.alpha = 0;
            this.addChild(curtain);
        }

        private function step(evt:Event):void
        {
        var time:int = sc.position;
        
        if(time > 6900){
            earth.y -= 1.3;
            sun.y += 0.28;
        }
        if(time > 35000){
            earthColor -= 0.0001;
            bmdEarth.colorTransform(bmdEarth.rect, new ColorTransform( 1, 1, earthColor, 1));
         
        }
        
         if(time < 38500){  
         }
         else if(time < 43500){
             textFields[0].visible = true;
            textFields[1].visible = true;
         }
         else if(time < 47500){
             textFields[0].visible = false;
             textFields[1].visible = false;
         }
         else if(time < 53900){
             textFields[2].visible = true;
         }
         else if(time < 56800){
             textFields[2].visible = false;
         }
         else if(time < 72500){
             textFields[3].visible = true;
             textFields[4].visible = true;
         }
         else{
             curtain.alpha +=0.01;
         }

            renderer.renderScene(scene, camera, viewport);
        }
    }
}