/**
 * Copyright itouhiro ( http://wonderfl.net/user/itouhiro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qYzi
 */

// forked from siouxcitizen's "forked from: ワンダフルクエスト" http://wonderfl.net/c/fMu8
/**=====================================================
 * 画像をassets.wonderfl.netにアップロードして、表示をためします
 * ===================================================== */
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    
    /**
     * ...
     * @author itouhiro
     */
    [SWF(width="465", height="465", frameRate="30", backgroundColor="0xEEEEEE")]
    public class Main extends Sprite {
        private var preload:Preloader;
        static public var loading:int = 0;
        
        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            preload = new Preloader();
            trace('preload');
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler(e:Event):void {
            if (loading <= 0) return;
            
            removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
            //画像を読み込み
            var img:Bitmap = Bitmap(preload.get().content);
            //画像の縦横比を3倍にしてmapDataにcopy
            var mapData:BitmapData = new BitmapData(img.width * 3, img.height * 3, true, 0x00000000);
            var matrix:Matrix = new Matrix(); matrix.scale(3, 3);
            mapData.draw(img, matrix);
            
            //地形をbgDataに配置
            var mapTable:Array = [
                 [ 0, 9, 0, 0, 0, 0, 1, 0, 0, 0],
                 [ 0, 9, 0, 0, 0, 0, 0, 0, 0, 0],
                 [ 0, 9, 0, 0, 0, 0, 0, 0, 0, 0],
                 [ 0, 9, 0, 0, 0, 0, 0, 0, 6, 0],
                 [ 0, 9, 0, 0, 0, 0, 0, 0, 0, 0],
                 [ 1, 9, 0, 0, 0, 0, 0, 0, 0, 0],
                 [ 1, 9, 9, 9, 9, 9, 9, 4, 4, 9],
                 [ 1, 0, 0, 0, 9, 9, 0, 0, 0, 0],
                 [ 1, 1, 0, 0, 5, 5, 0, 0, 0, 0],
                 [ 1, 1, 1, 9, 9, 9, 9, 0, 0, 1],
            ];
            var bgData:BitmapData = new BitmapData(mapTable[y].length * 48, mapTable.length * 48, false, 0x333333);
            for (var y:int = 0; y < mapTable.length; y++) {
                for (var x:int = 0; x < mapTable[y].length; x++) {
                    bgData.copyPixels(mapData, new Rectangle(mapTable[y][x]*48, 0, 48, 48), new Point(x*48, y*48));
                }
            }
            
            //勇者を配置
            bgData.copyPixels(mapData, new Rectangle(0, 48, 48, 48), new Point(mapTable[0].length * 48 / 2, mapTable.length * 48 / 2));
            
            //画面表示
            var bg:Bitmap = new Bitmap(bgData);
            bg.x = -16; bg.y = -16;
            addChild(bg);
        }
    }
}
import flash.display.Loader;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import flash.text.TextField;
import flash.text.TextFormat;

class Preloader extends Sprite{
    private var preloadText:TextField = null;
    private var ld:Loader;
    
    public function Preloader():void {
        trace('constructor');
        ld = new Loader();
        ld.contentLoaderInfo.addEventListener(Event.COMPLETE, loadCompleteHandler);
        ld.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, loadProgressHandler);
        ld.load(new URLRequest('http://assets.wonderfl.net/images/related_images/0/03/03e1/03e140c0fe09a4055ea74ea7b74af1c1a963ef68'), new LoaderContext(true));
    }
    
    public function get():Loader {
        return ld;
    }
    
    private function loadCompleteHandler(e:Event):void {
        removeChild(preloadText);
        Main.loading++;
    }
    
    private function loadProgressHandler(e:ProgressEvent):void {
        if ( ! preloadText) {
            //preloader
            preloadText = new TextField();
            preloadText.x = 160; preloadText.y = 12; preloadText.width = 160;
            preloadText.defaultTextFormat = new TextFormat('Verdana', 16, 0x000000);
            preloadText.text = 'Loading: 0 %';
            addChild(preloadText);
        }
        var percentLoaded:Number = Math.round(e.bytesLoaded / e.bytesTotal * 100);
        preloadText.text = 'Loading: ' + percentLoaded + ' %';
        trace('Loading: ' + percentLoaded + ' %');
    }
}