/**
 * Copyright takishiki ( http://wonderfl.net/user/takishiki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qYYf
 */

/*
 * draw star
 * 星の描画
 * もっと美しくてシンプルな描画方法はないものか…(>_<。) 
 * 
 */
package {
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.events.Event;
    
    public class FlashTest extends Sprite {
        private var _sp:Sprite;
        // constructor
        public function FlashTest() {
            _sp = new Sprite();
            _sp.x = stage.stageWidth / 2;
            _sp.y = stage.stageHeight / 2;
            this.addChild(_sp);
            
            var g:Graphics = _sp.graphics;
            g.clear();
            g.lineStyle(2, 0x999900);
            g.beginFill(0xFFFF00, 1.0);  
            drawStar(_sp, 5, 0, 0, 100, 50, 0);    // draw star        
            g.endFill();
            
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        // 
        private function onEnterFrame(event:Event):void {
            _sp.rotation += 4;
        }

        
        // draw star shape
        private function drawStar(sp:Sprite, num:int, x:int, y:int, r1:int, r2:int, deg:Number):void {
            /*
             * sp:対象Sprite
             * num:頂点の数
             * x:中心のx座標
             * y:中心のy座標
             * r1:外側（山）の半径
             * r2:内側（谷）の半径
             * deg:回転角度（度）
             */
            var g:Graphics = sp.graphics;
            var rad:Number;
            var i:int;
            var step:Number = 360 / num;
            
            // 描画スタート位置に移動
            rad = deg2rad(0 + deg);
            g.moveTo(x + r1 * Math.cos(rad), y + r1 * Math.sin(rad));
            
            // 谷 -> 山 -> 谷　の順番で線を描画
            for (i = 0; i < num; i++) {
                rad = deg2rad(i * step + deg + step / 2);
                g.lineTo(x + r2 * Math.cos(rad), y + r2 * Math.sin(rad));
                rad = deg2rad((i + 1) * step + deg);
                g.lineTo(x + r1 * Math.cos(rad), y + r1 * Math.sin(rad));
            }
        }
        
        // degree -> radian
        private function deg2rad(deg:Number):Number {
            deg %= 360;
            return deg / 180 * Math.PI;
        }
    }
}