/**
 * Copyright kuma360 ( http://wonderfl.net/user/kuma360 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qYE9
 */

//マリオギャラクシーが面白かったので
//キーボードの←、→、↑で操作
package 
{
    import flash.display.Graphics;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.net.URLRequest;
    
    [ SWF ( backgroundColor = "#000000" , frameRate=60 ) ]
    public class Main extends Sprite {
        
        private static var WANCO:String = 'http://swf.wonderfl.net/static/assets/checkmate05/wancoProfessional.swf';
        
        //入力
        public static var _inputL:Boolean ;
        public static var _inputR:Boolean ;
        public static var _inputU:Boolean ;
        
        
        private var _hero:Hero ;
        private var _planet1:Planet ;
        private var _planet2:Planet ;
        private var _planet3:Planet ;
        private var _planet4:Planet ;
        
        
        public function Main ( ) :void {
            
            
            var G:Graphics = this.graphics;
            G.lineStyle ( 1 , 0xFFFFFF , 1 ) ;
            for ( var I : Number = 0 ; I < 50 ; ++ I ) {
                var X:Number = Math.random ( ) * 465 ;
                var Y:Number = Math.random ( ) * 465 ;
                G.moveTo ( X , Y ) ;
                G.lineTo ( X , Y + 1 ) ;
            }

            
            stage.addEventListener (
                KeyboardEvent.KEY_DOWN,
                function ( event:KeyboardEvent ) :void {
                    _inputL = ( event.keyCode == 37 )? true : _inputL ;
                    _inputR = ( event.keyCode == 39 )? true : _inputR ;
                    _inputU = ( event.keyCode == 38 )? true : _inputU ;
                }
            ) ;
            
            stage.addEventListener (
                KeyboardEvent.KEY_UP ,
                function ( event:KeyboardEvent ) :void {
                    _inputL = ( event.keyCode == 37 )? false : _inputL ;
                    _inputR = ( event.keyCode == 39 )? false : _inputR ;
                    _inputU = ( event.keyCode == 38 )? false : _inputU ;
                }
            ) ;
            
            
            var loader:Loader;
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener (
                Event.COMPLETE,
                function ( e:Event ):void {
                    
                    var WancoClass:Class = loader.contentLoaderInfo.applicationDomain.getDefinition ( 'WakeMotion') as Class;
                    
                    _hero = new Hero ( 200 , 200 , new WancoClass ) ;
                    addChild ( _hero ) ;
                    
                    _planet1 = new Planet ( 350 , 100 , Math.random() * 10 + 30 ) ;
                    addChild ( _planet1 ) ;
                    
                    _planet2 = new Planet ( 250 , 250 , Math.random() * 10 + 60 ) ;
                    addChild ( _planet2 ) ;
                    
                    _planet3 = new Planet ( 130 , 350 , Math.random() * 10 + 10 ) ;
                    addChild ( _planet3 ) ;
                    
                    _planet4 = new Planet ( 100 , 100 , Math.random() * 99 + 20 ) ;
                    addChild ( _planet4 ) ;
                    
                    addEventListener (
                        Event.ENTER_FRAME ,
                        function ( e:Event = null ) :void {
                            
                            _hero.update ( ) ;
                            _hero.gravity ( _planet1 ) ;
                            _hero.gravity ( _planet2 ) ;
                            _hero.gravity ( _planet3 ) ;
                            _hero.gravity ( _planet4 ) ;
                            
                        }
                        
                    ) ;
                    
                }
            );
            
            loader.load ( new URLRequest ( WANCO ) ) ;
            
        }
        
        
    }
    
}


import flash.display.Graphics;
import flash.display.MovieClip;
import flash.display.Sprite;
import flash.filters.GlowFilter;

//////////////////////////////////////////
class Planet extends Sprite {
    
    private var _power:Number ;
    public function get power ( ) :Number {
        return _power ;
    }
    
    private var _SIZE:Number ;
    public function get size ( ) :Number {
        return _SIZE ;
    }
    
    public function Planet ( X:Number , Y:Number , SIZE:Number ) {
        
        x = X ;
        y = Y ;
        _SIZE = SIZE ;
        _power = _SIZE / 5 ;
        
        var G:Graphics = graphics ;
        G.beginFill ( 0xF0F070 , 1 ) ;
        G.drawCircle ( 0 , 0 , _SIZE ) ;
        G.endFill ( ) ;
    
        this.filters = [
            new GlowFilter ( 0xFFFF00 , 1 , 15 , 15 , 2 , 2 )
        ];
        
    }
    
    
}


//////////////////////////////////////////
class Hero extends Sprite {
    
    private var _VX:Number ;
    private var _VY:Number ;
    private var _SIZE:Number ;
    
    //最後に触れた星
    private var _lastPlanet:Planet ;
    private var _lastT:Number ;
    
    public function Hero ( X:Number , Y:Number , MC:MovieClip ) {
        
        _lastPlanet = null ;
        _lastT = 0 ;
        
        x = X ;
        y = Y ;
        _VX = Math.random() * 5  ;
        _VY = Math.random() * 5  ;
        _SIZE = 10 ;
        
        MC.rotation = 270 ;
        MC.scaleX = .5 ;
        MC.scaleY = .5 ;
        MC.x = _SIZE ;
        addChild ( MC ) ;
        
    }
    
    
    public function update ( ) :void {
        
        var IX:Number = ( _lastPlanet is Planet )?  _lastPlanet.x - x : - x ;
        var IY:Number = ( _lastPlanet is Planet )?  _lastPlanet.y - y : - y ;
        var R:Number = Math.atan2 ( IY , IX ) ;
        var RP:Number = R + 90 * Math.PI / 180 ;
        rotation = R * 180 / Math.PI ;
        
        
        -- _lastT ;
        
        if ( 0 < _lastT ) {
            
            if ( Main._inputL ) {
                _VX += Math.cos ( RP ) ;
                _VY += Math.sin ( RP ) ;
            }
            
            if ( Main._inputR ) {
                _VX -= Math.cos ( RP ) ;
                _VY -= Math.sin ( RP ) ;
            }
        
            if ( Main._inputU ) {
                _lastT = 0 ;
                _VX -= Math.cos ( R ) * 5 ;
                _VY -= Math.sin ( R ) * 5 ;
            }
                        
            _VX *= .8 ;
            _VY *= .8 ;

        } else {
        
            _VX *= .99 ;
            _VY *= .99 ;
            
        }
        
        
        
        x += _VX ;
        y += _VY ;
        
        if ( x < 0 ) {
            x = 0 ;
            _VX = -_VX ;
        }
        
        if ( 465 < x ) {
            x = 465 ;
            _VX = -_VX ;
        }
        
        if ( y < 0 ) {
            y = 0 ;
            _VY = -_VY ;
        }
        
        if ( 465 < y ) {
            y = 465 ;
            _VY = -_VY ;
        }
        
    }
    
    
    
    
    public function gravity ( planet:Planet ) :void {
        
        var IX:Number = planet.x - x ;
        var IY:Number = planet.y - y ;
        var L:Number  = Math.sqrt ( IX * IX + IY * IY ) ;
        var NL:Number = ( L ) ? 1 / L : 0 ;
        IX *= NL ;
        IY *= NL ;
        
        var POWER:Number = NL * planet.power ;
        _VX += IX * POWER ;
        _VY += IY * POWER ;
        
        if ( ( L < planet.size + _SIZE ) || ( 0 < _lastT && _lastPlanet == planet ) ) {
            
            var D:Number = _VX * IX + _VY * IY ;
            _VX += - D * IX * 1.1 ;
            _VY += - D * IY * 1.1 ;
            
            x = planet.x - IX * ( planet.size + _SIZE ) ;
            y = planet.y - IY * ( planet.size + _SIZE ) ;
            
            _lastPlanet = planet ;
            _lastT = 3 ;
            
        }
        
    }
    
    
}