/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qWQs
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import Box2D.Dynamics.b2World;
	import Box2D.Dynamics.b2DebugDraw;
	import Box2D.Collision.b2AABB;
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.b2Body;
 
	[SWF(backgroundColor="0x414647")]
	public class Main extends Sprite
	{
		private var world:b2World;
		private var scale:Number = 10;
 
		public function Main()
		{
			var worldAABB:b2AABB = new b2AABB();
			worldAABB.lowerBound.Set(-100, -100);
			worldAABB.upperBound.Set(stage.stageWidth + 100, stage.stageHeight + 100);
 
			var gravity:b2Vec2 = new b2Vec2(0, 10);
			world = new b2World(worldAABB, gravity, true);

			Shape.world = world;
			Shape.scale = scale;
			
			Shape.create( { shape:Shape.RECT, x:0,   y: -1,  width:465, height:1, cBits:0x11 } );
			Shape.create( { shape:Shape.RECT, x:-1,  y:  0, width:1, height:465, cBits:0x11 } );
			Shape.create( { shape:Shape.RECT, x:0,   y: 465, width:465, height:1, cBits:0x11 } );
			Shape.create( { shape:Shape.RECT, x:465, y: 0, width:1, height:465, cBits:0x11 } );
			
			var draw:b2DebugDraw = new b2DebugDraw();
			draw.m_sprite = this;
			draw.m_drawScale = scale;
			draw.m_drawFlags = b2DebugDraw.e_shapeBit | b2DebugDraw.e_jointBit;
			world.SetDebugDraw(draw);

			for (var i:int = 0; i < 3; i++)
			{
				var body:b2Body = Shape.create( { shape:Shape.CIRCLE, cBits:0x1, x:200 + 100, y:100, radius:20, density:10, restitution:1.0 } );
				body.SetLinearVelocity(new b2Vec2(-30, -30));
				body = Shape.create( { shape:Shape.RECT, cBits:0x10, x:200, y:100, width:30, height:20, density:10, restitution:1.0 } );
				body.SetLinearVelocity(new b2Vec2(30, 30));
			}
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(event:Event):void 
		{
			for (var body:b2Body = world.m_bodyList; body; body = body.m_next)
			{
				if (body.m_userData)
				{	
					body.m_userData.x = body.GetPosition().x * scale;
					body.m_userData.y = body.GetPosition().y * scale;
					body.m_userData.rotation = body.GetAngle() / (Math.PI / 180);
				}
			}
			world.Step(1 / stage.frameRate, 10);
		}
	}
}
 
import Box2D.Collision.Shapes.b2FilterData;
import flash.display.Sprite;
import Box2D.Collision.b2ContactPoint;
import Box2D.Collision.Shapes.b2CircleDef;
import Box2D.Collision.Shapes.b2PolygonDef;
import Box2D.Collision.Shapes.b2ShapeDef;
import Box2D.Common.Math.b2Vec2;
import Box2D.Dynamics.b2Body;
import Box2D.Dynamics.b2BodyDef;
import Box2D.Dynamics.b2ContactListener;
import Box2D.Dynamics.b2World;

class Shape
{
	public static const CIRCLE:int = 0;
	public static const RECT:int = 1;
 
	public static var world:b2World;
	public static var scale:Number;
	
	public static function addVec2(body:b2Body, x:Number, y:Number):void
	{
		body.SetXForm(new b2Vec2(body.GetPosition().x + x / scale, body.GetPosition().y + y / scale), body.GetAngle());
	}
 
	public static function setVec2(body:b2Body, x:Number, y:Number):void
	{
		body.SetXForm(new b2Vec2(x / scale, y / scale), body.GetAngle());
	}
 
	public static function addAngle(body:b2Body, rotate:Number):void
	{
		body.SetXForm(body.GetPosition(), body.GetAngle() + rotate * Math.PI / 180);
	}
 
	public static function setAngle(body:b2Body, rotate:Number):void
	{
		body.SetXForm(body.GetPosition(), rotate * Math.PI / 180);
	}
 
	public static function create(params:Object):b2Body
	{
		var def:b2BodyDef = new b2BodyDef();
		if (params.angle) def.angle = params.angle * Math.PI / 180;
 
		var shape:b2ShapeDef;
		
		if (params.shape == Shape.RECT)
		{
			def.position.Set((params.x + params.width / 2) / scale, (params.y + params.height / 2) / scale);
			shape = new b2PolygonDef();
			b2PolygonDef(shape).SetAsBox(params.width / 2 / scale, params.height / 2 / scale);
		}
		else if (params.shape == Shape.CIRCLE)
		{
			def.position.Set(params.x / scale, params.y / scale);
			shape = new b2CircleDef();
			b2CircleDef(shape).radius = params.radius / scale;
		}
 
		if (params.cBits)
		{
			shape.filter.categoryBits = params.cBits;
			if (params.mBits) shape.filter.maskBits = params.mBits;
			else shape.filter.maskBits = params.cBits;
		}
		
		shape.density = params.density;
		shape.restitution = params.restitution;
 
		var body:b2Body = world.CreateBody(def);
		body.CreateShape(shape);
		
 
		if (shape.density > 0) body.SetMassFromShapes();
 
		return body;
	}
}