/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qVym
 */

package {
    import com.bit101.components.ComboBox;
    import com.bit101.components.NumericStepper;
    import com.bit101.components.PushButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;

    public class FlashTest extends Sprite {
        public var bitmap:Bitmap;
        public var bitmapData:BitmapData;
        
        public var pNumericStepper:NumericStepper;
        public var qNumericStepper:NumericStepper;
        
        public var randomizeColorButton:PushButton;
        public var randomizeSeedButton:PushButton;
        
        public var selectComboBox:ComboBox;
        
        public var colorArray:Array = [5716756.854567219,14477620.605816515,12294354.923449298,12346014.201620165];

        public function FlashTest() {
            // write as3 code here..
            bitmapData = new BitmapData(465, 465, false, 0x0);
            bitmap = new Bitmap(bitmapData);
            addChild(bitmap);
            
            var shape:Shape = new Shape();
            shape.graphics.beginFill(0x292929);
            shape.graphics.drawRect(0, 435, 465, 30);
            shape.graphics.endFill();
            addChild(shape);
            
            pNumericStepper = new NumericStepper(this, 10, 440, onChangeNumericStepper);
            pNumericStepper.value = 23411;
            
            qNumericStepper = new NumericStepper(this, 100, 440, onChangeNumericStepper);
            qNumericStepper.value = 61060;
            
            selectComboBox = new ComboBox(this, 465 - 280, 440, "", ["ornament", "scale", "textile"]);
            selectComboBox.selectedIndex = 2;
            selectComboBox.openPosition = "TOP";
            selectComboBox.width = 90;
            selectComboBox.addEventListener(Event.SELECT, onTypeSelect);
            
            randomizeSeedButton = new PushButton(this, 465 - 180, 440, "Random Seed", onRandomizeSeed);
            randomizeSeedButton.width = 80;
            randomizeColorButton = new PushButton(this, 465 - 90, 440, "Random Color", onRandomizeColor);
            randomizeColorButton.width = 80;
            
            
            fillBitmap(bitmapData);
        }
        
        private function onTypeSelect(e:Event):void
        {
            fillBitmap(bitmapData);
        }
       
        private function onRandomizeSeed(e:Event):void
        {
            qNumericStepper.value = int(Math.random() * 100000);
            pNumericStepper.value = int(Math.random() * (qNumericStepper.value / 2));
            
            fillBitmap(bitmapData);
        }
        
        private function onRandomizeColor(e:Event):void
        {
            colorArray = [Math.random() * 0xffffff, Math.random() * 0xffffff, Math.random() * 0xffffff, Math.random() * 0xffffff];
            fillBitmap(bitmapData);
        }
        
        private function onChangeNumericStepper(e:Event):void
        {
            fillBitmap(bitmapData);
        }
        
        private function fillBitmap(bitmapData:BitmapData):void
        {
            var i:int;
            var j:int;
            
            var x:Number;
            var y:Number;
            
            var p:int = pNumericStepper.value;
            var q:int = qNumericStepper.value;
            var num:Number;
            var color:uint;
            
            for (i = 0; i < 465; i += 1)
            {
                for (j = 0; j < 465; j += 1)
                {
                    x = (i * p) % q;
                    y = (j * p) % q;
                    
                    switch(selectComboBox.selectedIndex)
                    {
                        case 0: //ornament
                            num = x * x + y * y + x * y;
                            break;
                            
                        case 1: //scale
                            num = x * x + y * y + 2 * x * y + x + 3 * y;
                            break;
                            
                        case 2: //textile
                            
                            if (x < y)
                            {
                                num = x * x + x + y;
                            }
                            else
                            {
                                num = y * y + x;
                            }
                            
                            break;
                    }
                    
                    num = ((p * num) % q) / (q - 1);
                    
                    color = int(num * 4.0);
                    
                    //color = int(num / q * 4.0) * 255 / 4;
                    //if (i == 0 && j < 100)
                    //{
                        //trace(color);
                    //}
                    
                    //bitmapData.setPixel(i, j, color << 16 | color << 8 | color);
                    bitmapData.setPixel(i, j, colorArray[color]);
                }
            }
            
        }
    }
}